/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.services;

import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.SelectModel;
import org.apache.tapestry5.internal.OptionModelImpl;
import org.apache.tapestry5.internal.SelectModelImpl;
import org.apache.tapestry5.internal.TapestryInternalUtils;
import org.apache.tapestry5.ioc.annotations.Symbol;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.services.ThreadLocale;
import org.apache.tapestry5.services.LocalizationSetter;
import org.apache.tapestry5.services.PersistentLocale;
import org.apache.tapestry5.services.Request;

public class LocalizationSetterImpl
implements LocalizationSetter {
    private final Request request;
    private final ThreadLocale threadLocale;
    private final Locale defaultLocale;
    private final Set<String> supportedLocaleNames;
    private final List<Locale> supportedLocales;
    private final Map<String, Locale> localeCache = CollectionFactory.newConcurrentMap();
    private final PersistentLocale persistentLocale;

    public LocalizationSetterImpl(Request request, PersistentLocale persistentLocale, ThreadLocale threadLocale, @Symbol(value="tapestry.supported-locales") String localeNames) {
        String[] names;
        this.request = request;
        this.persistentLocale = persistentLocale;
        this.threadLocale = threadLocale;
        this.supportedLocaleNames = CollectionFactory.newSet();
        for (String name : names = TapestryInternalUtils.splitAtCommas(localeNames)) {
            this.supportedLocaleNames.add(name.toLowerCase());
        }
        this.supportedLocales = this.parseNames(names);
        this.defaultLocale = this.supportedLocales.get(0);
    }

    private List<Locale> parseNames(String[] localeNames) {
        List list = CollectionFactory.newList();
        for (String name : localeNames) {
            list.add(this.toLocale(name));
        }
        return Collections.unmodifiableList(list);
    }

    @Override
    public Locale toLocale(String localeName) {
        Locale result = this.localeCache.get(localeName);
        if (result == null) {
            result = this.constructLocale(localeName);
            this.localeCache.put(localeName, result);
        }
        return result;
    }

    private Locale constructLocale(String name) {
        String[] terms = name.split("_");
        switch (terms.length) {
            case 1: {
                return new Locale(terms[0], "");
            }
            case 2: {
                return new Locale(terms[0], terms[1]);
            }
            case 3: {
                return new Locale(terms[0], terms[1], terms[2]);
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public boolean setLocaleFromLocaleName(String localeName) {
        boolean supported = this.isSupportedLocaleName(localeName);
        if (supported) {
            Locale locale = this.findClosestSupportedLocale(this.toLocale(localeName));
            this.persistentLocale.set(locale);
            this.threadLocale.setLocale(locale);
        } else {
            Locale requestLocale = this.request.getLocale();
            Locale supportedLocale = this.findClosestSupportedLocale(requestLocale);
            this.threadLocale.setLocale(supportedLocale);
        }
        return supported;
    }

    @Override
    public void setNonPersistentLocaleFromLocaleName(String localeName) {
        Locale requested = this.toLocale(localeName);
        Locale supported = this.findClosestSupportedLocale(requested);
        this.threadLocale.setLocale(supported);
    }

    private Locale findClosestSupportedLocale(Locale desiredLocale) {
        String localeName = desiredLocale.toString();
        do {
            if (!this.isSupportedLocaleName(localeName)) continue;
            return this.toLocale(localeName);
        } while ((localeName = LocalizationSetterImpl.stripTerm(localeName)).length() != 0);
        return this.defaultLocale;
    }

    static String stripTerm(String localeName) {
        int scorex = localeName.lastIndexOf(95);
        return scorex < 0 ? "" : localeName.substring(0, scorex);
    }

    @Override
    public List<Locale> getSupportedLocales() {
        return this.supportedLocales;
    }

    @Override
    public boolean isSupportedLocaleName(String localeName) {
        return this.supportedLocaleNames.contains(localeName.toLowerCase());
    }

    @Override
    public SelectModel getSupportedLocalesModel() {
        List options = CollectionFactory.newList();
        for (Locale l : this.supportedLocales) {
            options.add(new OptionModelImpl(l.getDisplayName(l), l));
        }
        return new SelectModelImpl(null, options);
    }
}

