/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.structure;

import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.tapestry5.Binding;
import org.apache.tapestry5.Block;
import org.apache.tapestry5.BlockNotFoundException;
import org.apache.tapestry5.ComponentEventCallback;
import org.apache.tapestry5.ComponentResources;
import org.apache.tapestry5.EventContext;
import org.apache.tapestry5.Link;
import org.apache.tapestry5.MarkupWriter;
import org.apache.tapestry5.Renderable;
import org.apache.tapestry5.TapestryMarkers;
import org.apache.tapestry5.annotations.AfterRender;
import org.apache.tapestry5.annotations.AfterRenderBody;
import org.apache.tapestry5.annotations.AfterRenderTemplate;
import org.apache.tapestry5.annotations.BeforeRenderTemplate;
import org.apache.tapestry5.annotations.BeginRender;
import org.apache.tapestry5.annotations.CleanupRender;
import org.apache.tapestry5.annotations.SetupRender;
import org.apache.tapestry5.dom.Element;
import org.apache.tapestry5.internal.AbstractEventContext;
import org.apache.tapestry5.internal.InternalComponentResources;
import org.apache.tapestry5.internal.InternalConstants;
import org.apache.tapestry5.internal.services.ComponentEventImpl;
import org.apache.tapestry5.internal.services.Instantiator;
import org.apache.tapestry5.internal.structure.BlockImpl;
import org.apache.tapestry5.internal.structure.ComponentCallback;
import org.apache.tapestry5.internal.structure.ComponentPageElement;
import org.apache.tapestry5.internal.structure.ComponentPageElementResources;
import org.apache.tapestry5.internal.structure.InternalComponentResourcesImpl;
import org.apache.tapestry5.internal.structure.LifecycleNotificationComponentCallback;
import org.apache.tapestry5.internal.structure.Page;
import org.apache.tapestry5.internal.structure.RenderPhaseEvent;
import org.apache.tapestry5.internal.structure.RenderPhaseEventHandler;
import org.apache.tapestry5.internal.structure.StructureMessages;
import org.apache.tapestry5.internal.util.NamedSet;
import org.apache.tapestry5.internal.util.NotificationEventCallback;
import org.apache.tapestry5.ioc.BaseLocatable;
import org.apache.tapestry5.ioc.Invokable;
import org.apache.tapestry5.ioc.Location;
import org.apache.tapestry5.ioc.OperationTracker;
import org.apache.tapestry5.ioc.internal.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.ioc.internal.util.Orderer;
import org.apache.tapestry5.ioc.internal.util.TapestryException;
import org.apache.tapestry5.ioc.services.PerThreadValue;
import org.apache.tapestry5.ioc.util.AvailableValues;
import org.apache.tapestry5.ioc.util.UnknownValueException;
import org.apache.tapestry5.model.ComponentModel;
import org.apache.tapestry5.model.ParameterModel;
import org.apache.tapestry5.runtime.Component;
import org.apache.tapestry5.runtime.ComponentEvent;
import org.apache.tapestry5.runtime.ComponentEventException;
import org.apache.tapestry5.runtime.Event;
import org.apache.tapestry5.runtime.RenderCommand;
import org.apache.tapestry5.runtime.RenderQueue;
import org.apache.tapestry5.services.pageload.ComponentResourceSelector;
import org.slf4j.Logger;

public class ComponentPageElementImpl
extends BaseLocatable
implements ComponentPageElement {
    private static final Block PLACEHOLDER_BLOCK = new PlaceholderBlock();
    private static final ComponentCallback POST_RENDER_CLEANUP = new LifecycleNotificationComponentCallback(){

        @Override
        public void run(Component component) {
            component.postRenderCleanup();
        }
    };
    private NamedSet<Block> blocks;
    private BlockImpl bodyBlock;
    private List<ComponentPageElement> children;
    private final String elementName;
    private final Logger eventLogger;
    private final String completeId;
    private final Component coreComponent;
    private List<Component> components = null;
    private final ComponentPageElementResources elementResources;
    private final ComponentPageElement container;
    private final InternalComponentResources coreResources;
    private final String id;
    private Orderer<Component> mixinBeforeOrderer;
    private Orderer<Component> mixinAfterOrderer;
    private boolean loaded;
    private NamedSet<InternalComponentResources> mixinIdToComponentResources;
    private final String nestedId;
    private final Page page;
    private final PerThreadValue<Boolean> renderingValue;
    private final boolean exactParameterCountMatch;
    private final List<RenderCommand> template = CollectionFactory.newList();
    private RenderCommand setupRenderPhase;
    private RenderCommand beginRenderPhase;
    private RenderCommand beforeRenderTemplatePhase;
    private RenderCommand beforeRenderBodyPhase;
    private RenderCommand afterRenderBodyPhase;
    private RenderCommand afterRenderTemplatePhase;
    private RenderCommand afterRenderPhase;
    private RenderCommand cleanupRenderPhase;

    private static void pushElements(RenderQueue queue, List<RenderCommand> list) {
        int count = ComponentPageElementImpl.size(list);
        for (int i = count - 1; i >= 0; --i) {
            queue.push(list.get(i));
        }
    }

    private static int size(List<?> list) {
        return list == null ? 0 : list.size();
    }

    ComponentPageElementImpl(Page page, ComponentPageElement container, String id, String nestedId, String completeId, String elementName, Instantiator instantiator, Location location, ComponentPageElementResources elementResources) {
        super(location);
        this.page = page;
        this.container = container;
        this.id = id;
        this.nestedId = nestedId;
        this.completeId = completeId;
        this.elementName = elementName;
        this.elementResources = elementResources;
        this.exactParameterCountMatch = page.isExactParameterCountMatch();
        InternalComponentResources containerResources = container == null ? null : container.getComponentResources();
        this.coreResources = new InternalComponentResourcesImpl(this.page, this, containerResources, this.elementResources, completeId, nestedId, instantiator, false);
        this.coreComponent = this.coreResources.getComponent();
        this.eventLogger = elementResources.getEventLogger(this.coreResources.getLogger());
        this.renderingValue = elementResources.createPerThreadValue();
        page.addPageLoadedCallback(new Runnable(){

            @Override
            public void run() {
                ComponentPageElementImpl.this.pageLoaded();
            }
        });
    }

    public ComponentPageElementImpl(Page page, Instantiator instantiator, ComponentPageElementResources elementResources) {
        this(page, null, null, null, page.getName(), null, instantiator, null, elementResources);
    }

    private void initializeRenderPhases() {
        this.setupRenderPhase = new SetupRenderPhase();
        this.beginRenderPhase = new BeginRenderPhase();
        this.beforeRenderTemplatePhase = new BeforeRenderTemplatePhase();
        this.beforeRenderBodyPhase = new BeforeRenderBodyPhase();
        this.afterRenderBodyPhase = new AfterRenderBodyPhase();
        this.afterRenderTemplatePhase = new AfterRenderTemplatePhase();
        this.afterRenderPhase = new AfterRenderPhase();
        this.cleanupRenderPhase = new CleanupRenderPhase();
        Set<Class> handled = this.coreResources.getComponentModel().getHandledRenderPhases();
        for (ComponentResources componentResources : NamedSet.getValues(this.mixinIdToComponentResources)) {
            handled.addAll(componentResources.getComponentModel().getHandledRenderPhases());
        }
        if (!handled.contains(CleanupRender.class)) {
            this.cleanupRenderPhase = null;
        }
        if (!handled.contains(AfterRender.class)) {
            this.afterRenderPhase = this.cleanupRenderPhase;
        }
        if (!handled.contains(AfterRenderTemplate.class)) {
            this.afterRenderTemplatePhase = null;
        }
        if (!handled.contains(AfterRenderBody.class)) {
            this.afterRenderBodyPhase = null;
        }
        if (!handled.contains(BeforeRenderTemplate.class)) {
            this.beforeRenderTemplatePhase = new RenderTemplatePhase();
        }
        if (!handled.contains(BeginRender.class)) {
            RenderCommand replacement = this.afterRenderPhase != null ? new OptimizedBeginRenderPhase() : this.beforeRenderTemplatePhase;
            this.beginRenderPhase = replacement;
        }
        if (!handled.contains(SetupRender.class)) {
            this.setupRenderPhase = this.beginRenderPhase;
        }
    }

    @Override
    public ComponentPageElement newChild(String id, String nestedId, String completeId, String elementName, Instantiator instantiator, Location location) {
        ComponentPageElementImpl child = new ComponentPageElementImpl(this.page, this, id, nestedId, completeId, elementName, instantiator, location, this.elementResources);
        this.addEmbeddedElement(child);
        return child;
    }

    void push(RenderQueue queue, boolean forward, RenderCommand forwardPhase, RenderCommand backwardPhase) {
        this.push(queue, forward ? forwardPhase : backwardPhase);
    }

    void push(RenderQueue queue, RenderCommand nextPhase) {
        if (nextPhase != null) {
            queue.push(nextPhase);
        }
    }

    void addEmbeddedElement(ComponentPageElement child) {
        if (this.children == null) {
            this.children = CollectionFactory.newList();
        }
        String childId = child.getId();
        for (ComponentPageElement existing : this.children) {
            if (!existing.getId().equalsIgnoreCase(childId)) continue;
            throw new TapestryException(StructureMessages.duplicateChildComponent(this, childId), (Object)child, (Throwable)new TapestryException(StructureMessages.originalChildComponent(this, childId, existing.getLocation()), (Object)existing, null));
        }
        this.children.add(child);
    }

    @Override
    public void addMixin(String mixinId, Instantiator instantiator, String ... order) {
        if (this.mixinIdToComponentResources == null) {
            this.mixinIdToComponentResources = NamedSet.create();
            this.components = CollectionFactory.newList();
        }
        String mixinExtension = "$" + mixinId.toLowerCase();
        InternalComponentResourcesImpl resources = new InternalComponentResourcesImpl(this.page, this, this.coreResources, this.elementResources, this.completeId + mixinExtension, this.nestedId + mixinExtension, instantiator, true);
        this.mixinIdToComponentResources.put(mixinId, resources);
        if (order == null) {
            order = InternalConstants.EMPTY_STRING_ARRAY;
        }
        if (resources.getComponentModel().isMixinAfter()) {
            if (this.mixinAfterOrderer == null) {
                this.mixinAfterOrderer = new Orderer(this.getLogger());
            }
            this.mixinAfterOrderer.add(mixinId, (Object)resources.getComponent(), order);
        } else {
            if (this.mixinBeforeOrderer == null) {
                this.mixinBeforeOrderer = new Orderer(this.getLogger());
            }
            this.mixinBeforeOrderer.add(mixinId, (Object)resources.getComponent(), order);
        }
    }

    @Override
    public void bindMixinParameter(String mixinId, String parameterName, Binding binding) {
        InternalComponentResources mixinResources = NamedSet.get(this.mixinIdToComponentResources, mixinId);
        mixinResources.bindParameter(parameterName, binding);
    }

    @Override
    public Binding getBinding(String parameterName) {
        return this.coreResources.getBinding(parameterName);
    }

    @Override
    public void bindParameter(String parameterName, Binding binding) {
        this.coreResources.bindParameter(parameterName, binding);
    }

    @Override
    public void addToBody(RenderCommand element) {
        if (this.bodyBlock == null) {
            this.bodyBlock = new BlockImpl(this.getLocation(), "Body of " + this.getCompleteId());
        }
        this.bodyBlock.addToBody(element);
    }

    @Override
    public void addToTemplate(RenderCommand element) {
        this.template.add(element);
    }

    private void addUnboundParameterNames(String prefix, List<String> unbound, InternalComponentResources resource) {
        ComponentModel model = resource.getComponentModel();
        for (String name : model.getParameterNames()) {
            ParameterModel parameterModel;
            if (resource.isBound(name) || !(parameterModel = model.getParameterModel(name)).isRequired()) continue;
            String fullName = prefix == null ? name : prefix + "." + name;
            unbound.add(fullName);
        }
    }

    private void pageLoaded() {
        if (this.components != null) {
            List ordered = CollectionFactory.newList();
            if (this.mixinBeforeOrderer != null) {
                ordered.addAll(this.mixinBeforeOrderer.getOrdered());
            }
            ordered.add(this.coreComponent);
            if (this.mixinAfterOrderer != null) {
                ordered.addAll(this.mixinAfterOrderer.getOrdered());
            }
            this.components = ordered;
            this.mixinBeforeOrderer = null;
            this.mixinAfterOrderer = null;
        }
        this.initializeRenderPhases();
        this.page.addVerifyCallback(new Runnable(){

            @Override
            public void run() {
                ComponentPageElementImpl.this.verifyRequiredParametersAreBound();
            }
        });
        this.loaded = true;
    }

    @Override
    public void enqueueBeforeRenderBody(RenderQueue queue) {
        if (this.bodyBlock != null) {
            this.push(queue, this.beforeRenderBodyPhase);
        }
    }

    @Override
    public String getCompleteId() {
        return this.completeId;
    }

    @Override
    public Component getComponent() {
        return this.coreComponent;
    }

    @Override
    public InternalComponentResources getComponentResources() {
        return this.coreResources;
    }

    @Override
    public ComponentPageElement getContainerElement() {
        return this.container;
    }

    @Override
    public Page getContainingPage() {
        return this.page;
    }

    @Override
    public ComponentPageElement getEmbeddedElement(String embeddedId) {
        ComponentPageElement embeddedElement = null;
        if (this.children != null) {
            for (ComponentPageElement child : this.children) {
                if (!child.getId().equalsIgnoreCase(embeddedId)) continue;
                embeddedElement = child;
                break;
            }
        }
        if (embeddedElement == null) {
            Set ids = CollectionFactory.newSet();
            if (this.children != null) {
                for (ComponentPageElement child : this.children) {
                    ids.add(child.getId());
                }
            }
            throw new UnknownValueException(String.format("Component %s does not contain embedded component '%s'.", this.getCompleteId(), embeddedId), new AvailableValues("Embedded components", (Collection)ids));
        }
        return embeddedElement;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Logger getLogger() {
        return this.coreResources.getLogger();
    }

    @Override
    public Component getMixinByClassName(String mixinClassName) {
        Component result = this.mixinForClassName(mixinClassName);
        if (result == null) {
            throw new TapestryException(StructureMessages.unknownMixin(this.completeId, mixinClassName), this.getLocation(), null);
        }
        return result;
    }

    private Component mixinForClassName(String mixinClassName) {
        if (this.mixinIdToComponentResources == null) {
            return null;
        }
        for (InternalComponentResources resources : NamedSet.getValues(this.mixinIdToComponentResources)) {
            if (!resources.getComponentModel().getComponentClassName().equals(mixinClassName)) continue;
            return resources.getComponent();
        }
        return null;
    }

    @Override
    public ComponentResources getMixinResources(String mixinId) {
        ComponentResources result = NamedSet.get(this.mixinIdToComponentResources, mixinId);
        if (result == null) {
            throw new IllegalArgumentException(String.format("Unable to locate mixin '%s' for component '%s'.", mixinId, this.completeId));
        }
        return result;
    }

    @Override
    public String getNestedId() {
        return this.nestedId;
    }

    @Override
    public boolean dispatchEvent(ComponentEvent event) {
        if (this.components == null) {
            return this.coreComponent.dispatchComponentEvent(event);
        }
        boolean result = false;
        for (Component component : this.components) {
            result |= component.dispatchComponentEvent(event);
            if (!event.isAborted()) continue;
            break;
        }
        return result;
    }

    private void invoke(boolean reverse, ComponentCallback callback) {
        try {
            Iterator<Component> i;
            if (this.components == null) {
                callback.run(this.coreComponent);
                return;
            }
            Iterator<Component> iterator = i = reverse ? InternalUtils.reverseIterator(this.components) : this.components.iterator();
            while (i.hasNext()) {
                callback.run(i.next());
                if (!callback.isEventAborted()) continue;
                return;
            }
        }
        catch (RuntimeException ex) {
            throw new TapestryException(ex.getMessage(), this.getLocation(), (Throwable)ex);
        }
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public boolean isRendering() {
        return (Boolean)this.renderingValue.get((Object)false);
    }

    private String phaseToString(String phaseName) {
        return String.format("%s[%s]", phaseName, this.completeId);
    }

    @Override
    public final void render(MarkupWriter writer, RenderQueue queue) {
        this.renderingValue.set((Object)true);
        queue.startComponent(this.coreResources);
        queue.push(new PostRenderCleanupPhase(writer.getElement()));
        this.push(queue, this.setupRenderPhase);
    }

    public String toString() {
        return String.format("ComponentPageElement[%s]", this.completeId);
    }

    @Override
    public boolean triggerEvent(String eventType, Object[] contextValues, ComponentEventCallback callback) {
        return this.triggerContextEvent(eventType, this.createParameterContext(contextValues == null ? new Object[]{} : contextValues), callback);
    }

    private EventContext createParameterContext(final Object ... values) {
        return new AbstractEventContext(){

            @Override
            public int getCount() {
                return values.length;
            }

            @Override
            public <T> T get(Class<T> desiredType, int index) {
                return ComponentPageElementImpl.this.elementResources.coerce(values[index], desiredType);
            }
        };
    }

    @Override
    public boolean triggerContextEvent(final String eventType, final EventContext context, final ComponentEventCallback callback) {
        assert (InternalUtils.isNonBlank((String)eventType));
        assert (context != null);
        String description = "Triggering event '" + eventType + "' on " + this.completeId;
        return (Boolean)this.elementResources.invoke(description, (Invokable)new Invokable<Boolean>(){

            public Boolean invoke() {
                return ComponentPageElementImpl.this.processEventTriggering(eventType, context, callback);
            }
        });
    }

    private boolean processEventTriggering(String eventType, EventContext context, ComponentEventCallback callback) {
        boolean result = false;
        ComponentPageElement component = this;
        String componentId = "";
        final ComponentEventCallback providedHandler = callback == null ? new NotificationEventCallback(eventType, this.completeId) : callback;
        ComponentEventCallback wrapped = new ComponentEventCallback(){

            public boolean handleResult(Object result) {
                if (result instanceof Boolean) {
                    return (Boolean)result;
                }
                return providedHandler.handleResult(result);
            }
        };
        ComponentEventException rootException = null;
        String currentEventType = eventType;
        EventContext currentContext = context;
        Location location = component.getComponentResources().getLocation();
        while (component != null) {
            try {
                Logger logger = component.getEventLogger();
                ComponentEventImpl event = new ComponentEventImpl(currentEventType, componentId, currentContext, wrapped, this.elementResources, this.exactParameterCountMatch, this.coreResources.getComponentModel(), logger);
                logger.debug(TapestryMarkers.EVENT_DISPATCH, "Dispatch event: {}", (Object)event);
                result |= component.dispatchEvent(event);
                if (event.isAborted()) {
                    return result;
                }
            }
            catch (Exception ex) {
                if (rootException != null) {
                    throw rootException;
                }
                rootException = new ComponentEventException(ex.getMessage(), eventType, context, location, ex);
                currentEventType = "exception";
                currentContext = this.createParameterContext(new Object[]{rootException});
                continue;
            }
            componentId = component.getId();
            component = component.getContainerElement();
        }
        if (rootException != null) {
            throw rootException;
        }
        return result;
    }

    private void verifyRequiredParametersAreBound() {
        List unbound = CollectionFactory.newList();
        this.addUnboundParameterNames(null, unbound, this.coreResources);
        List sortedNames = CollectionFactory.newList(NamedSet.getNames(this.mixinIdToComponentResources));
        Collections.sort(sortedNames);
        for (String name : sortedNames) {
            this.addUnboundParameterNames(name, unbound, this.mixinIdToComponentResources.get(name));
        }
        if (!unbound.isEmpty()) {
            throw new TapestryException(StructureMessages.missingParameters(unbound, this), (Object)this, null);
        }
    }

    @Override
    public Locale getLocale() {
        return this.page.getSelector().locale;
    }

    @Override
    public String getElementName(String defaultElementName) {
        return this.elementName != null ? this.elementName : defaultElementName;
    }

    @Override
    public Block getBlock(String id) {
        Block result = this.findBlock(id);
        if (result == null) {
            throw new BlockNotFoundException(StructureMessages.blockNotFound(this.completeId, id), this.getLocation());
        }
        return result;
    }

    @Override
    public Block findBlock(String id) {
        assert (InternalUtils.isNonBlank((String)id));
        return NamedSet.get(this.blocks, id);
    }

    @Override
    public void addBlock(String blockId, Block block) {
        if (this.blocks == null) {
            this.blocks = NamedSet.create();
        }
        if (!this.blocks.putIfNew(blockId, block)) {
            throw new TapestryException(StructureMessages.duplicateBlock(this, blockId), (Object)block, null);
        }
    }

    @Override
    public String getPageName() {
        return this.page.getName();
    }

    @Override
    public boolean hasBody() {
        return this.bodyBlock != null;
    }

    @Override
    public Block getBody() {
        return this.bodyBlock == null ? PLACEHOLDER_BLOCK : this.bodyBlock;
    }

    @Override
    public Map<String, Binding> getInformalParameterBindings() {
        return this.coreResources.getInformalParameterBindings();
    }

    @Override
    public Logger getEventLogger() {
        return this.eventLogger;
    }

    @Override
    public Link createEventLink(String eventType, Object ... context) {
        return this.elementResources.createComponentEventLink(this.coreResources, eventType, false, context);
    }

    @Override
    public Link createFormEventLink(String eventType, Object ... context) {
        return this.elementResources.createComponentEventLink(this.coreResources, eventType, true, context);
    }

    protected RenderPhaseEvent createRenderEvent(RenderQueue queue) {
        return new RenderPhaseEvent(new RenderPhaseEventHandler(queue), this.eventLogger, (OperationTracker)this.elementResources);
    }

    boolean isRenderTracingEnabled() {
        return this.elementResources.isRenderTracingEnabled();
    }

    @Override
    public ComponentResourceSelector getResourceSelector() {
        return this.page.getSelector();
    }

    private class PostRenderCleanupPhase
    implements RenderCommand {
        private final Element expectedElementAtCompletion;

        PostRenderCleanupPhase(Element expectedElementAtCompletion) {
            this.expectedElementAtCompletion = expectedElementAtCompletion;
        }

        @Override
        public void render(MarkupWriter writer, RenderQueue queue) {
            ComponentPageElementImpl.this.renderingValue.set((Object)false);
            Element current = writer.getElement();
            if (current != this.expectedElementAtCompletion) {
                throw new TapestryException(StructureMessages.unbalancedElements(ComponentPageElementImpl.this.completeId), ComponentPageElementImpl.this.getLocation(), null);
            }
            ComponentPageElementImpl.this.invoke(false, POST_RENDER_CLEANUP);
            queue.endComponent();
        }

        public String toString() {
            return ComponentPageElementImpl.this.phaseToString("PostRenderCleanup");
        }
    }

    private class CleanupRenderPhase
    extends AbstractPhase {
        private CleanupRenderPhase() {
            super("CleanupRender", true);
        }

        @Override
        protected void invokeComponent(Component component, MarkupWriter writer, Event event) {
            component.cleanupRender(writer, event);
        }

        @Override
        public void render(MarkupWriter writer, RenderQueue queue) {
            RenderPhaseEvent event = ComponentPageElementImpl.this.createRenderEvent(queue);
            this.invoke(writer, event);
            ComponentPageElementImpl.this.push(queue, event.getResult(), null, ComponentPageElementImpl.this.setupRenderPhase);
            event.enqueueSavedRenderCommands();
        }
    }

    private class AfterRenderPhase
    extends AbstractPhase {
        private AfterRenderPhase() {
            super("AfterRender", true);
        }

        @Override
        protected void invokeComponent(Component component, MarkupWriter writer, Event event) {
            component.afterRender(writer, event);
            if (ComponentPageElementImpl.this.isRenderTracingEnabled()) {
                writer.comment("END " + component.getComponentResources().getCompleteId());
            }
        }

        @Override
        public void render(MarkupWriter writer, RenderQueue queue) {
            RenderPhaseEvent event = ComponentPageElementImpl.this.createRenderEvent(queue);
            this.invoke(writer, event);
            ComponentPageElementImpl.this.push(queue, event.getResult(), ComponentPageElementImpl.this.cleanupRenderPhase, ComponentPageElementImpl.this.beginRenderPhase);
            event.enqueueSavedRenderCommands();
        }
    }

    private class AfterRenderTemplatePhase
    extends AbstractPhase {
        private AfterRenderTemplatePhase() {
            super("AfterRenderTemplate", true);
        }

        @Override
        protected void invokeComponent(Component component, MarkupWriter writer, Event event) {
            component.afterRenderTemplate(writer, event);
        }

        @Override
        public void render(MarkupWriter writer, RenderQueue queue) {
            RenderPhaseEvent event = ComponentPageElementImpl.this.createRenderEvent(queue);
            this.invoke(writer, event);
            ComponentPageElementImpl.this.push(queue, event.getResult(), null, ComponentPageElementImpl.this.beforeRenderTemplatePhase);
            event.enqueueSavedRenderCommands();
        }
    }

    private class AfterRenderBodyPhase
    extends AbstractPhase {
        private AfterRenderBodyPhase() {
            super("AfterRenderBody", true);
        }

        @Override
        protected void invokeComponent(Component component, MarkupWriter writer, Event event) {
            component.afterRenderBody(writer, event);
        }

        @Override
        public void render(MarkupWriter writer, RenderQueue queue) {
            RenderPhaseEvent event = ComponentPageElementImpl.this.createRenderEvent(queue);
            this.invoke(writer, event);
            ComponentPageElementImpl.this.push(queue, event.getResult(), null, ComponentPageElementImpl.this.beforeRenderBodyPhase);
            event.enqueueSavedRenderCommands();
        }
    }

    private class BeforeRenderBodyPhase
    extends AbstractPhase {
        private BeforeRenderBodyPhase() {
            super("BeforeRenderBody");
        }

        @Override
        protected void invokeComponent(Component component, MarkupWriter writer, Event event) {
            component.beforeRenderBody(writer, event);
        }

        @Override
        public void render(MarkupWriter writer, RenderQueue queue) {
            RenderPhaseEvent event = ComponentPageElementImpl.this.createRenderEvent(queue);
            this.invoke(writer, event);
            ComponentPageElementImpl.this.push(queue, ComponentPageElementImpl.this.afterRenderBodyPhase);
            if (event.getResult() && ComponentPageElementImpl.this.bodyBlock != null) {
                queue.push(ComponentPageElementImpl.this.bodyBlock);
            }
            event.enqueueSavedRenderCommands();
        }
    }

    private class RenderTemplatePhase
    implements RenderCommand {
        private RenderTemplatePhase() {
        }

        @Override
        public void render(MarkupWriter writer, RenderQueue queue) {
            ComponentPageElementImpl.this.push(queue, ComponentPageElementImpl.this.afterRenderTemplatePhase);
            ComponentPageElementImpl.pushElements(queue, ComponentPageElementImpl.this.template);
        }

        public String toString() {
            return ComponentPageElementImpl.this.phaseToString("RenderTemplate");
        }
    }

    private class BeforeRenderTemplatePhase
    extends AbstractPhase {
        private BeforeRenderTemplatePhase() {
            super("BeforeRenderTemplate");
        }

        @Override
        protected void invokeComponent(Component component, MarkupWriter writer, Event event) {
            component.beforeRenderTemplate(writer, event);
        }

        @Override
        public void render(MarkupWriter writer, RenderQueue queue) {
            RenderPhaseEvent event = ComponentPageElementImpl.this.createRenderEvent(queue);
            this.invoke(writer, event);
            ComponentPageElementImpl.this.push(queue, ComponentPageElementImpl.this.afterRenderTemplatePhase);
            if (event.getResult()) {
                ComponentPageElementImpl.pushElements(queue, ComponentPageElementImpl.this.template);
            }
            event.enqueueSavedRenderCommands();
        }
    }

    private class OptimizedBeginRenderPhase
    implements RenderCommand {
        private OptimizedBeginRenderPhase() {
        }

        @Override
        public void render(MarkupWriter writer, RenderQueue queue) {
            ComponentPageElementImpl.this.push(queue, ComponentPageElementImpl.this.afterRenderPhase);
            ComponentPageElementImpl.this.push(queue, ComponentPageElementImpl.this.beforeRenderTemplatePhase);
        }

        public String toString() {
            return ComponentPageElementImpl.this.phaseToString("OptimizedBeginRenderPhase");
        }
    }

    private class BeginRenderPhase
    extends AbstractPhase {
        private BeginRenderPhase() {
            super("BeginRender");
        }

        @Override
        protected void invokeComponent(Component component, MarkupWriter writer, Event event) {
            if (ComponentPageElementImpl.this.isRenderTracingEnabled()) {
                writer.comment("BEGIN " + component.getComponentResources().getCompleteId() + " (" + ComponentPageElementImpl.this.getLocation() + ")");
            }
            component.beginRender(writer, event);
        }

        @Override
        public void render(MarkupWriter writer, RenderQueue queue) {
            RenderPhaseEvent event = ComponentPageElementImpl.this.createRenderEvent(queue);
            this.invoke(writer, event);
            ComponentPageElementImpl.this.push(queue, ComponentPageElementImpl.this.afterRenderPhase);
            ComponentPageElementImpl.this.push(queue, event.getResult(), ComponentPageElementImpl.this.beforeRenderTemplatePhase, null);
            event.enqueueSavedRenderCommands();
        }
    }

    private class SetupRenderPhase
    extends AbstractPhase {
        public SetupRenderPhase() {
            super("SetupRender");
        }

        @Override
        protected void invokeComponent(Component component, MarkupWriter writer, Event event) {
            component.setupRender(writer, event);
        }

        @Override
        public void render(MarkupWriter writer, RenderQueue queue) {
            RenderPhaseEvent event = ComponentPageElementImpl.this.createRenderEvent(queue);
            this.invoke(writer, event);
            ComponentPageElementImpl.this.push(queue, event.getResult(), ComponentPageElementImpl.this.beginRenderPhase, ComponentPageElementImpl.this.cleanupRenderPhase);
            event.enqueueSavedRenderCommands();
        }
    }

    private abstract class AbstractPhase
    implements RenderCommand {
        private final String name;
        private final boolean reverse;

        AbstractPhase(String name) {
            this(name, false);
        }

        AbstractPhase(String name, boolean reverse) {
            this.name = name;
            this.reverse = reverse;
        }

        public String toString() {
            return ComponentPageElementImpl.this.phaseToString(this.name);
        }

        void invoke(MarkupWriter writer, Event event) {
            try {
                Iterator i;
                if (ComponentPageElementImpl.this.components == null) {
                    this.invokeComponent(ComponentPageElementImpl.this.coreComponent, writer, event);
                    return;
                }
                Iterator iterator = i = this.reverse ? InternalUtils.reverseIterator((List)ComponentPageElementImpl.this.components) : ComponentPageElementImpl.this.components.iterator();
                while (i.hasNext()) {
                    this.invokeComponent((Component)i.next(), writer, event);
                    if (!event.isAborted()) continue;
                    break;
                }
            }
            catch (Exception ex) {
                throw new TapestryException(ex.getMessage(), ComponentPageElementImpl.this.getLocation(), (Throwable)ex);
            }
        }

        protected abstract void invokeComponent(Component var1, MarkupWriter var2, Event var3);
    }

    private static class PlaceholderBlock
    implements Block,
    Renderable,
    RenderCommand {
        private PlaceholderBlock() {
        }

        @Override
        public void render(MarkupWriter writer) {
        }

        @Override
        public void render(MarkupWriter writer, RenderQueue queue) {
        }

        public String toString() {
            return "<PlaceholderBlock>";
        }
    }
}

