/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tapestry5.internal.transform;

import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.apache.tapestry5.annotations.PageActivationContext;
import org.apache.tapestry5.commons.util.CollectionFactory;
import org.apache.tapestry5.ioc.internal.util.InternalUtils;
import org.apache.tapestry5.model.MutableComponentModel;
import org.apache.tapestry5.plastic.FieldHandle;
import org.apache.tapestry5.plastic.PlasticClass;
import org.apache.tapestry5.plastic.PlasticField;
import org.apache.tapestry5.runtime.Component;
import org.apache.tapestry5.runtime.ComponentEvent;
import org.apache.tapestry5.services.ComponentEventHandler;
import org.apache.tapestry5.services.transform.ComponentClassTransformWorker2;
import org.apache.tapestry5.services.transform.TransformationSupport;

public class PageActivationContextWorker
implements ComponentClassTransformWorker2 {
    private static final Comparator<PlasticField> INDEX_COMPARATOR = new Comparator<PlasticField>(){

        @Override
        public int compare(PlasticField field1, PlasticField field2) {
            int compare;
            int index2;
            int index1 = ((PageActivationContext)field1.getAnnotation(PageActivationContext.class)).index();
            int n = index1 < (index2 = ((PageActivationContext)field2.getAnnotation(PageActivationContext.class)).index()) ? -1 : (compare = index1 > index2 ? 1 : 0);
            if (compare == 0) {
                compare = field1.getName().compareTo(field2.getName());
            }
            return compare;
        }
    };

    @Override
    public void transform(PlasticClass plasticClass, TransformationSupport support, MutableComponentModel model) {
        List fields = plasticClass.getFieldsWithAnnotation(PageActivationContext.class);
        if (!fields.isEmpty()) {
            this.transformFields(support, fields);
        }
    }

    private void transformFields(TransformationSupport support, List<PlasticField> fields) {
        List sortedFields = CollectionFactory.newList(fields);
        Collections.sort(sortedFields, INDEX_COMPARATOR);
        this.validateSortedFields(sortedFields);
        PlasticField firstField = (PlasticField)sortedFields.get(0);
        PageActivationContext firstAnnotation = (PageActivationContext)firstField.getAnnotation(PageActivationContext.class);
        FieldHandle[] handles = new FieldHandle[sortedFields.size()];
        String[] typeNames = new String[sortedFields.size()];
        int i = 0;
        for (PlasticField field : sortedFields) {
            handles[i] = field.getHandle();
            typeNames[i] = field.getTypeName();
            ++i;
        }
        if (firstAnnotation.activate()) {
            support.addEventHandler("activate", 1, "PageActivationContextWorker activate event handler", PageActivationContextWorker.createActivationHandler(handles, typeNames));
        }
        if (firstAnnotation.passivate()) {
            support.addEventHandler("passivate", 0, "PageActivationContextWorker passivate event handler", PageActivationContextWorker.createPassivateHandler(handles));
        }
    }

    private void validateSortedFields(List<PlasticField> sortedFields) {
        List expectedIndexes = CollectionFactory.newList();
        List actualIndexes = CollectionFactory.newList();
        Set activates = CollectionFactory.newSet();
        Set passivates = CollectionFactory.newSet();
        for (int i = 0; i < sortedFields.size(); ++i) {
            PlasticField field = sortedFields.get(i);
            PageActivationContext annotation = (PageActivationContext)field.getAnnotation(PageActivationContext.class);
            expectedIndexes.add(i);
            actualIndexes.add(annotation.index());
            activates.add(annotation.activate());
            passivates.add(annotation.passivate());
        }
        List errors = CollectionFactory.newList();
        if (!expectedIndexes.equals(actualIndexes)) {
            errors.add(String.format("Index values must start at 0 and increment by 1 (expected [%s], found [%s])", InternalUtils.join((List)expectedIndexes), InternalUtils.join((List)actualIndexes)));
        }
        if (activates.size() > 1) {
            errors.add("Illegal values for 'activate' (all fields must have the same value)");
        }
        if (passivates.size() > 1) {
            errors.add("Illegal values for 'passivate' (all fields must have the same value)");
        }
        if (!errors.isEmpty()) {
            throw new RuntimeException(String.format("Invalid values for @PageActivationContext: %s", InternalUtils.join((List)errors)));
        }
    }

    private static ComponentEventHandler createActivationHandler(final FieldHandle[] handles, final String[] fieldTypes) {
        return new ComponentEventHandler(){

            @Override
            public void handleEvent(Component instance, ComponentEvent event) {
                int count = Math.min(handles.length, event.getEventContext().getCount());
                for (int i = 0; i < count; ++i) {
                    String fieldType = fieldTypes[i];
                    FieldHandle handle = handles[i];
                    Object value = event.coerceContext(i, fieldType);
                    handle.set((Object)instance, value);
                }
            }
        };
    }

    private static ComponentEventHandler createPassivateHandler(final FieldHandle[] handles) {
        return new ComponentEventHandler(){

            @Override
            public void handleEvent(Component instance, ComponentEvent event) {
                Object result;
                if (handles.length == 1) {
                    result = handles[0].get((Object)instance);
                } else {
                    LinkedList list = CollectionFactory.newLinkedList();
                    for (int i = handles.length - 1; i > -1; --i) {
                        FieldHandle handle = handles[i];
                        Object value = handle.get((Object)instance);
                        if (value == null && list.isEmpty()) continue;
                        list.addFirst(value);
                    }
                    result = list.isEmpty() ? null : list;
                }
                event.storeResult(result);
            }
        };
    }
}

