/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import java.util.Arrays;
import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaStructure;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.DateTime;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.NodeId;
import org.eclipse.milo.opcua.stack.core.types.structured.HistoryUpdateDetails;

public class DeleteAtTimeDetails
extends HistoryUpdateDetails
implements UaStructure {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=689");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=691");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=690");
    private final DateTime[] reqTimes;

    public DeleteAtTimeDetails(NodeId nodeId, DateTime[] reqTimes) {
        super(nodeId);
        this.reqTimes = reqTimes;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    public DateTime[] getReqTimes() {
        return this.reqTimes;
    }

    protected DeleteAtTimeDetails(DeleteAtTimeDetailsBuilder<?, ?> b) {
        super((HistoryUpdateDetails.HistoryUpdateDetailsBuilder<?, ?>)b);
        this.reqTimes = ((DeleteAtTimeDetailsBuilder)b).reqTimes;
    }

    public static DeleteAtTimeDetailsBuilder<?, ?> builder() {
        return new DeleteAtTimeDetailsBuilderImpl();
    }

    public DeleteAtTimeDetailsBuilder<?, ?> toBuilder() {
        return new DeleteAtTimeDetailsBuilderImpl().$fillValuesFrom(this);
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DeleteAtTimeDetails)) {
            return false;
        }
        DeleteAtTimeDetails other = (DeleteAtTimeDetails)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        return Arrays.deepEquals(this.getReqTimes(), other.getReqTimes());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof DeleteAtTimeDetails;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + Arrays.deepHashCode(this.getReqTimes());
        return result;
    }

    @Override
    public String toString() {
        return "DeleteAtTimeDetails(reqTimes=" + Arrays.deepToString(this.getReqTimes()) + ")";
    }

    private static final class DeleteAtTimeDetailsBuilderImpl
    extends DeleteAtTimeDetailsBuilder<DeleteAtTimeDetails, DeleteAtTimeDetailsBuilderImpl> {
        private DeleteAtTimeDetailsBuilderImpl() {
        }

        @Override
        protected DeleteAtTimeDetailsBuilderImpl self() {
            return this;
        }

        @Override
        public DeleteAtTimeDetails build() {
            return new DeleteAtTimeDetails(this);
        }
    }

    public static abstract class DeleteAtTimeDetailsBuilder<C extends DeleteAtTimeDetails, B extends DeleteAtTimeDetailsBuilder<C, B>>
    extends HistoryUpdateDetails.HistoryUpdateDetailsBuilder<C, B> {
        private DateTime[] reqTimes;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            DeleteAtTimeDetailsBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(DeleteAtTimeDetails instance, DeleteAtTimeDetailsBuilder<?, ?> b) {
            b.reqTimes(instance.reqTimes);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B reqTimes(DateTime[] reqTimes) {
            this.reqTimes = reqTimes;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "DeleteAtTimeDetails.DeleteAtTimeDetailsBuilder(super=" + super.toString() + ", reqTimes=" + Arrays.deepToString(this.reqTimes) + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<DeleteAtTimeDetails> {
        @Override
        public Class<DeleteAtTimeDetails> getType() {
            return DeleteAtTimeDetails.class;
        }

        @Override
        public DeleteAtTimeDetails decode(SerializationContext context, UaDecoder decoder) {
            NodeId nodeId = decoder.readNodeId("NodeId");
            DateTime[] reqTimes = decoder.readDateTimeArray("ReqTimes");
            return new DeleteAtTimeDetails(nodeId, reqTimes);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, DeleteAtTimeDetails value) {
            encoder.writeNodeId("NodeId", value.getNodeId());
            encoder.writeDateTimeArray("ReqTimes", value.getReqTimes());
        }
    }
}

