/*
 * Decompiled with CFR 0.152.
 */
package org.ascape.model.space;

import java.util.Collection;
import org.ascape.model.space.Coordinate;
import org.ascape.model.space.CoordinateDiscrete;
import org.ascape.model.space.ListSpace;
import org.ascape.model.space.Location;
import org.ascape.model.space.Space;
import org.ascape.model.space.SubSpace;

public class SubListSpace
extends ListSpace
implements SubSpace {
    private static final long serialVersionUID = 1L;
    private Space superSpace;

    public SubListSpace() {
    }

    public SubListSpace(CoordinateDiscrete extent) {
        this();
        this.setExtent(extent);
    }

    public void populate() {
        this.superSpace.removeAll(this);
        super.populate();
        this.superSpace.addAll(this);
    }

    public boolean remove(Object o) {
        try {
            return super.remove(o) && this.superSpace.remove(o);
        }
        catch (NullPointerException e) {
            throw new RuntimeException("No superlist specified for " + this.getContext().getName());
        }
    }

    public boolean addAll(int index, Collection c) {
        try {
            boolean listAdded = super.addAll(index, c);
            boolean superSpaceAdded = this.superSpace.addAll(c);
            return listAdded && superSpaceAdded;
        }
        catch (NullPointerException e) {
            throw new RuntimeException("No superlist specified for " + this.getContext().getName());
        }
    }

    public boolean addAll(Collection c) {
        try {
            boolean listAdded = super.addAll(c);
            boolean superSpaceAdded = this.superSpace.addAll(c);
            return listAdded && superSpaceAdded;
        }
        catch (NullPointerException e) {
            throw new RuntimeException("No superlist specified for " + this.getContext().getName());
        }
    }

    public boolean removeAll(Collection c) {
        try {
            return super.removeAll(c) && this.superSpace.removeAll(c);
        }
        catch (NullPointerException e) {
            throw new RuntimeException("No superlist specified for " + this.getContext().getName());
        }
    }

    public boolean retainAll(Collection c) {
        boolean removedAllSub = this.superSpace.removeAll(this);
        boolean retainedAll = super.retainAll(c);
        boolean addedAllSub = this.superSpace.addAll(this);
        return removedAllSub && retainedAll && addedAllSub;
    }

    public void clear() {
        this.superSpace.removeAll(this);
        super.clear();
    }

    protected void addToSuper(int index, Object o, boolean isParent) {
        try {
            this.superSpace.add(o, false);
            super.add(index, o, isParent);
        }
        catch (NullPointerException e) {
            throw new RuntimeException("No superlist specified for " + this.getContext().getName());
        }
    }

    public boolean add(Object o, boolean isParent) {
        try {
            this.superSpace.add(o, false);
            return super.add(o, isParent);
        }
        catch (NullPointerException e) {
            throw new RuntimeException("No superlist specified for " + this.getContext().getName());
        }
    }

    public void add(int index, Object o, boolean isParent) {
        try {
            this.superSpace.add(o, false);
            super.add(index, o, isParent);
        }
        catch (NullPointerException e) {
            throw new RuntimeException("No superlist specified for " + this.getContext().getName());
        }
    }

    public Space getSuperSpace() {
        return this.superSpace;
    }

    public void setSuperSpace(Space superSpace) {
        this.superSpace = superSpace;
        if (this.collection != null && this.collection.size() > 0) {
            superSpace.addAll(this);
        }
    }

    public void moveToward(Location origin, Coordinate target, double distance) {
        this.getSuperSpace().moveToward(origin, target, distance);
    }

    public void moveAway(Location origin, Coordinate target, double distance) {
        this.getSuperSpace().moveAway(origin, target, distance);
    }

    public double calculateDistance(Coordinate origin, Coordinate target) {
        return this.getSuperSpace().calculateDistance(origin, target);
    }
}

