/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.draw3d.graphics3d.lwjgl.util;

import java.nio.ByteBuffer;
import java.nio.IntBuffer;
import org.eclipse.draw3d.ISceneListener;
import org.eclipse.draw3d.RenderContext;
import org.eclipse.draw3d.camera.ICamera;
import org.eclipse.draw3d.util.ImageConverter;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.ImageLoader;
import org.lwjgl.BufferUtils;
import org.lwjgl.opengl.GL11;

public class BackBufferDumper
implements ISceneListener {
    private ByteBuffer m_pBuffer;
    private int m_pBufferSize = 0;
    private IntBuffer m_vpBuffer = BufferUtils.createIntBuffer((int)16);

    public void cameraChanged(ICamera i_oldCamera, ICamera i_newCamera) {
    }

    public void renderPassFinished(RenderContext i_renderContext) {
        this.m_vpBuffer.rewind();
        GL11.glGetInteger((int)2978, (IntBuffer)this.m_vpBuffer);
        int x = this.m_vpBuffer.get(0);
        int y = this.m_vpBuffer.get(1);
        int width = this.m_vpBuffer.get(2);
        int height = this.m_vpBuffer.get(3);
        if (width == 0 || height == 0) {
            return;
        }
        int size = width * height * 4;
        if (this.m_pBuffer == null || size > this.m_pBufferSize) {
            this.m_pBuffer = BufferUtils.createByteBuffer((int)size);
            this.m_pBufferSize = size;
        } else {
            this.m_pBuffer.limit(size);
        }
        GL11.glReadPixels((int)x, (int)y, (int)width, (int)height, (int)6408, (int)5121, (ByteBuffer)this.m_pBuffer);
        ImageData imageData = ImageConverter.colorBufferToImage((ByteBuffer)this.m_pBuffer, (int)6408, (int)5121, (int)width, (int)height);
        ImageLoader imageLoader = new ImageLoader();
        imageLoader.data = new ImageData[]{imageData};
        String home = System.getProperty("user.home");
        String path = String.valueOf(home) + "/backbuffer_" + System.currentTimeMillis() + ".png";
        imageLoader.save(path, 5);
    }

    public void renderPassStarted(RenderContext i_renderContext) {
    }
}

