/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.ui.internal.actions;

import java.net.URL;
import org.eclipse.codewind.core.internal.CodewindApplication;
import org.eclipse.codewind.core.internal.CoreUtil;
import org.eclipse.codewind.core.internal.Logger;
import org.eclipse.codewind.core.internal.constants.AppStatus;
import org.eclipse.codewind.ui.internal.messages.Messages;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.browser.IWorkbenchBrowserSupport;

public class OpenAppAction
implements IObjectActionDelegate,
IViewActionDelegate {
    protected CodewindApplication app;

    public void selectionChanged(IAction action, ISelection selection) {
        Object obj;
        if (!(selection instanceof IStructuredSelection)) {
            action.setEnabled(false);
            return;
        }
        IStructuredSelection sel = (IStructuredSelection)selection;
        if (sel.size() == 1 && (obj = sel.getFirstElement()) instanceof CodewindApplication) {
            this.app = (CodewindApplication)obj;
            action.setEnabled(this.app.isAvailable() && (this.app.getAppStatus() == AppStatus.STARTING || this.app.getAppStatus() == AppStatus.STARTED));
            return;
        }
        action.setEnabled(false);
    }

    public void run(IAction action) {
        if (this.app == null) {
            Logger.logError((String)"OpenAppAction ran but no application was selected");
            return;
        }
        if (!this.app.isRunning()) {
            CoreUtil.openDialog((boolean)true, (String)Messages.OpenAppAction_CantOpenNotRunningAppTitle, (String)Messages.OpenAppAction_CantOpenNotRunningAppMsg);
            return;
        }
        OpenAppAction.openAppInBrowser(this.app);
    }

    public static void openAppInBrowser(CodewindApplication app) {
        URL appRootUrl = app.getRootUrl();
        if (appRootUrl == null) {
            Logger.logError((String)("The application could not be opened in the browser because the url is null: " + app.name));
            return;
        }
        try {
            IWorkbenchBrowserSupport browserSupport = PlatformUI.getWorkbench().getBrowserSupport();
            IWebBrowser browser = browserSupport.createBrowser(6, app.projectID, app.name, NLS.bind((String)Messages.BrowserTooltipApp, (Object)app.name));
            browser.openURL(appRootUrl);
        }
        catch (PartInitException e) {
            Logger.logError((String)"Error opening app in browser", (Throwable)e);
        }
    }

    public void setActivePart(IAction arg0, IWorkbenchPart arg1) {
    }

    public void init(IViewPart arg0) {
    }
}

