/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.codewind.core.internal.cli;

import org.eclipse.codewind.core.internal.connection.JSONObjectResult;
import org.json.JSONObject;

public class AuthToken
extends JSONObjectResult {
    private static final String ACCESS_TOKEN_KEY = "access_token";
    private static final String TOKEN_TYPE_KEY = "token_type";
    private static final String EXPIRES_IN_KEY = "expires_in";
    private static long EXPIRY_BUFFER = 300000L;
    private static long CREATE_BUFFER = 300000L;
    private final long createTimeMillis = System.currentTimeMillis();

    public AuthToken(JSONObject authToken) {
        super(authToken, "authorization token");
    }

    public String getToken() {
        return this.getString(ACCESS_TOKEN_KEY);
    }

    public String getTokenType() {
        return this.getString(TOKEN_TYPE_KEY);
    }

    public Integer getExpiresInSeconds() {
        return this.getInt(EXPIRES_IN_KEY);
    }

    public long getCreateTimeMillis() {
        return this.createTimeMillis;
    }

    public boolean aboutToExpire() {
        Integer expiresInSeconds = this.getExpiresInSeconds();
        if (expiresInSeconds == null) {
            return false;
        }
        long expiryTime = this.createTimeMillis + (long)(expiresInSeconds * 1000);
        return System.currentTimeMillis() > expiryTime - EXPIRY_BUFFER;
    }

    public boolean recentlyCreated() {
        return this.createTimeMillis + CREATE_BUFFER > System.currentTimeMillis();
    }
}

