/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.comma.monitoring.lib.CComponentConstraintMonitor;
import org.eclipse.comma.monitoring.lib.CComponentConstraintResult;
import org.eclipse.comma.monitoring.lib.CComponentMonitoringContext;
import org.eclipse.comma.monitoring.lib.CComponentResults;
import org.eclipse.comma.monitoring.lib.CConnectionResults;
import org.eclipse.comma.monitoring.lib.CMessageInfo;
import org.eclipse.comma.monitoring.lib.CPathDescription;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;

public class CComponentMonitor {
    private CComponentMonitoringContext context;
    private List<CMessageInfo> eventQueue = new ArrayList<CMessageInfo>();
    private String componentInstance;
    private boolean inErrorState = false;
    private List<CComponentConstraintMonitor> monitors;
    private CComponentResults result;

    public CComponentMonitor(CComponentMonitoringContext context) {
        this.context = context;
        this.componentInstance = context.getComponentInstanceName();
        this.monitors = context.getFactory().createComponentConstraintMonitors(context);
        this.result = new CComponentResults(this.componentInstance);
    }

    public void traceEnded() throws Exception {
        if (!this.inErrorState) {
            for (CMessageInfo mInfo : this.eventQueue) {
                for (CPathDescription pd : mInfo.getPathDescriptions()) {
                    if (pd.postStatesKnown()) continue;
                    pd.setActiveStatesAsPostStates();
                    pd.setPostStatesKnown();
                }
                for (CComponentConstraintMonitor monitor : this.monitors) {
                    monitor.consume(mInfo.getMessage(), mInfo.getPathDescriptions(), this.determinePort(mInfo.getMessage()).getKey());
                }
            }
        }
        for (CComponentConstraintMonitor monitor : this.monitors) {
            monitor.traceEnded();
            CComponentConstraintResult monResult = monitor.getResults();
            this.result.addConstraintErrors(monResult.getConstraintErrors());
            this.result.addFunctionalConstraintResults(monResult.getFunctionaConstraintResults());
        }
    }

    public CComponentResults getResults() {
        return this.result;
    }

    public void consume(CObservedMessage message, List<CPathDescription> pathDescriptions) throws Exception {
        if (this.inErrorState) {
            return;
        }
        CMessageInfo messageInfo = new CMessageInfo(message, pathDescriptions);
        if (messageInfo.isComplete() && this.eventQueue.isEmpty()) {
            for (CComponentConstraintMonitor monitor : this.monitors) {
                monitor.consume(message, pathDescriptions, this.determinePort(message).getKey());
            }
        } else {
            this.resolveIncompletePaths(messageInfo);
            this.flushQueue();
        }
    }

    private AbstractMap.SimpleEntry<String, String> determinePort(CObservedMessage message) {
        if (message.getSource().equals(this.componentInstance)) {
            return new AbstractMap.SimpleEntry<String, String>(message.getSourcePort(), message.getDestination());
        }
        return new AbstractMap.SimpleEntry<String, String>(message.getDestinationPort(), message.getSource());
    }

    public void connectionError(CConnectionResults connectionResult) {
        this.inErrorState = true;
        this.result.addConnectionResult(connectionResult);
    }

    public void connectionMonitoringDone(CConnectionResults connectionResult) {
        this.result.addConnectionResult(connectionResult);
    }

    public boolean inErrorState() {
        return this.inErrorState;
    }

    private void resolveIncompletePaths(CMessageInfo messageInfo) {
        AbstractMap.SimpleEntry<String, String> portInfo1 = this.determinePort(messageInfo.getMessage());
        String p1 = portInfo1.getKey();
        String cp1 = portInfo1.getValue();
        for (CMessageInfo mInfo : this.eventQueue) {
            boolean sameConnection;
            AbstractMap.SimpleEntry<String, String> portInfo2 = this.determinePort(mInfo.getMessage());
            String p2 = portInfo2.getKey();
            String cp2 = portInfo2.getValue();
            if (this.context.isSingletonPort(p1)) {
                sameConnection = p1.equals(p2);
            } else {
                boolean bl = sameConnection = p1.equals(p2) && cp1.equals(cp2);
            }
            if (!sameConnection || mInfo.isComplete()) continue;
            mInfo.resolvePostEventStates(messageInfo.getPathDescriptions());
            break;
        }
        this.eventQueue.add(messageInfo);
    }

    private void flushQueue() throws Exception {
        while (!this.eventQueue.isEmpty() && this.eventQueue.get(0).isComplete()) {
            for (CComponentConstraintMonitor monitor : this.monitors) {
                monitor.consume(this.eventQueue.get(0).getMessage(), this.eventQueue.get(0).getPathDescriptions(), this.determinePort(this.eventQueue.get(0).getMessage()).getKey());
            }
            this.eventQueue.remove(0);
        }
    }
}

