/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.java;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import org.eclipse.comma.java.JArtifactInfo;
import org.eclipse.comma.java.JCmd;
import org.eclipse.comma.java.JDependencyInfo;
import org.eclipse.comma.java.JDependencyInfos;
import org.eclipse.comma.java.impl.JCmdImpl;

public class JCmdBuilder {
    private final List<String> options;
    private final List<String> arguments;
    private String javaExec;
    private JArtifactInfo artifactInfo;

    protected JCmdBuilder(List<String> options, List<String> arguments) {
        this.options = Objects.requireNonNull(options, "options must not be null");
        this.arguments = Objects.requireNonNull(arguments, "arguments must not be null");
    }

    public JCmdBuilder(int optionsSize, int argumentsSize) {
        this(new ArrayList<String>(optionsSize), new ArrayList<String>(argumentsSize));
    }

    public JCmdBuilder() {
        this(5, 3);
    }

    public JCmdBuilder withJavaExec(String javaExec) {
        this.javaExec = javaExec;
        return this;
    }

    public JCmdBuilder withArtifactInfo(JArtifactInfo artifactInfo) {
        this.artifactInfo = Objects.requireNonNull(artifactInfo, "artifactInfo must not be null");
        return this;
    }

    public JCmdBuilder withOptions(Collection<String> options) {
        this.options.addAll(options);
        return this;
    }

    public JCmdBuilder withOptions(String ... options) {
        String[] stringArray = options;
        int n = options.length;
        int n2 = 0;
        while (n2 < n) {
            String o = stringArray[n2];
            this.options.add(Objects.requireNonNull(o, "option must not be null"));
            ++n2;
        }
        return this;
    }

    public JCmdBuilder withArguments(Collection<String> arguments) {
        this.arguments.addAll(arguments);
        return this;
    }

    public JCmdBuilder withArguments(String ... arguments) {
        String[] stringArray = arguments;
        int n = arguments.length;
        int n2 = 0;
        while (n2 < n) {
            String a = stringArray[n2];
            this.arguments.add(Objects.requireNonNull(a, "argument must not be null"));
            ++n2;
        }
        return this;
    }

    public JCmd build() {
        ArrayList<String> items = new ArrayList<String>(4 + this.options.size() + this.arguments.size());
        items.add(this.getJavaExec());
        items.add("-classpath");
        items.add(this.getClasspathItems());
        items.addAll(this.options);
        items.add(this.artifactInfo.getMainClass());
        items.addAll(this.arguments);
        return new JCmdImpl(items);
    }

    private String getJavaExec() {
        return this.javaExec != null ? this.javaExec : JCmdBuilder.findJavaExec();
    }

    private static String findJavaExec() {
        String javaHome = System.getProperty("java.home");
        if (javaHome == null || javaHome.isEmpty()) {
            javaHome = System.getenv("JAVA_HOME");
        }
        if (javaHome == null) {
            throw new IllegalArgumentException("find java home dir failed");
        }
        return new File(javaHome, "bin/java").getAbsolutePath();
    }

    private String getClasspathItems() {
        String jarFile = this.artifactInfo.getLocation().getAbsolutePath();
        List<JDependencyInfo> dependencyInfos = this.artifactInfo.getDependencyInfos();
        StringBuilder classpath = new StringBuilder();
        classpath.append(jarFile);
        if (!this.artifactInfo.getIncludesDependencies() && !dependencyInfos.isEmpty()) {
            classpath.append(JDependencyInfos.getClasspathSeparator());
            classpath.append(JDependencyInfos.toClasspath(dependencyInfos));
        }
        return classpath.toString();
    }
}

