/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.comma.monitoring.lib.messages;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.comma.monitoring.lib.messages.CMatchResult;
import org.eclipse.comma.monitoring.lib.messages.CMessageCompositePattern;
import org.eclipse.comma.monitoring.lib.messages.CMessagePattern;
import org.eclipse.comma.monitoring.lib.messages.CObservedMessage;

public class CSequencePattern
extends CMessageCompositePattern {
    private List<CMessageCompositePattern> elements = new ArrayList<CMessageCompositePattern>();
    private int current = 0;

    public CSequencePattern addElement(CMessageCompositePattern element) {
        this.elements.add(element);
        return this;
    }

    public boolean isEmpty() {
        return this.current == this.elements.size();
    }

    @Override
    public boolean isSkippable() {
        if (this.isEmpty()) {
            return true;
        }
        int i = this.current;
        while (i < this.elements.size()) {
            if (!this.elements.get(i).isSkippable()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public CMatchResult match(CObservedMessage observedMessage) {
        CMatchResult result = this.elements.get(this.current).match(observedMessage);
        switch (result) {
            case DROP: {
                if (this.current < this.elements.size() - 1) {
                    result = CMatchResult.MATCH;
                }
                ++this.current;
                break;
            }
            case SKIP: {
                if (this.current < this.elements.size() - 1) {
                    ++this.current;
                    result = this.match(observedMessage);
                    break;
                }
                ++this.current;
                break;
            }
        }
        return result;
    }

    @Override
    public List<CMessagePattern> getPossibleEvents() {
        return this.elements.get(this.current).getPossibleEvents();
    }
}

