/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hyades.logging.adapter.impl;

import org.eclipse.hyades.logging.adapter.AdapterInvalidConfig;
import org.eclipse.hyades.logging.adapter.ISensor;
import org.eclipse.hyades.logging.adapter.impl.ProcessUnit;
import org.eclipse.hyades.logging.adapter.impl.SensorStatus;
import org.eclipse.hyades.logging.adapter.util.Messages;
import org.eclipse.hyades.logging.events.cbe.CommonBaseEvent;
import org.w3c.dom.Element;

public abstract class Sensor
extends ProcessUnit
implements ISensor {
    private String type = null;
    protected int maximumBlocking = 1;
    protected boolean flushingMode = false;
    private boolean initialized = false;
    protected int confidenceBufferSize = 1024;
    protected int fileFooterSize = 90;

    public Sensor() {
        this.status = new SensorStatus();
    }

    public Object[] getNext() {
        CommonBaseEvent event = this.getEventFactory().createCommonBaseEvent();
        event.getMsgDataElement().setMsgCatalogId("HyadesGA_CBE_Sensor_getNext_INFO_");
        event.getMsgDataElement().setMsgCatalogTokensAsStrings(new String[]{this.getUniqueID()});
        event.setSeverity((short)10);
        this.log(event);
        return null;
    }

    public Object[] testGetNext() {
        return null;
    }

    public Object[] flush() {
        if (!this.initialized) {
            return null;
        }
        this.flushingMode = true;
        Object[] temp = this.getNext();
        this.flushingMode = false;
        return temp;
    }

    public void update() throws AdapterInvalidConfig {
        String attrValue;
        super.update();
        Element element = this.getConfiguration();
        this.setType(element.getAttribute(Messages.getString("HyadesGAtypeAttributeName")));
        String attrName = Messages.getString("HyadesGAmaximumBlockingAttributeName");
        if (element.hasAttribute(attrName)) {
            attrValue = element.getAttribute(attrName);
            try {
                this.maximumBlocking = Integer.valueOf(attrValue);
            }
            catch (NumberFormatException numberFormatException) {
                throw new AdapterInvalidConfig(Messages.getString("HyadesGAComponentConfiguration_Invalid_Integer_Attribute_Value_ERROR_", attrValue, attrName, this.getName()));
            }
        } else {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGAComponentConfiguration_Required_Attribute_Missing_ERROR_", attrName, this.getName()));
        }
        if (this.maximumBlocking <= 0) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGAComponentConfiguration_Invalid_Integer_Attribute_Value_ERROR_", Integer.toString(this.maximumBlocking), attrName, this.getName()));
        }
        attrName = Messages.getString("HyadesGAconfidenceBufferSizeAttributeName");
        if (element.hasAttribute(attrName)) {
            attrValue = element.getAttribute(attrName);
            try {
                this.confidenceBufferSize = Integer.valueOf(attrValue);
            }
            catch (NumberFormatException numberFormatException) {
                throw new AdapterInvalidConfig(Messages.getString("HyadesGAComponentConfiguration_Invalid_Positive_Integer_Attribute_Value_ERROR_", attrValue, attrName, this.getName()));
            }
        }
        if (this.confidenceBufferSize < 0) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGAComponentConfiguration_Invalid_Positive_Integer_Attribute_Value_ERROR_", Integer.toString(this.confidenceBufferSize), attrName, this.getName()));
        }
        attrName = Messages.getString("HyadesGAfileFooterSizeAttributeName");
        if (element.hasAttribute(attrName)) {
            attrValue = element.getAttribute(attrName);
            try {
                this.fileFooterSize = Integer.valueOf(attrValue);
            }
            catch (NumberFormatException numberFormatException) {
                throw new AdapterInvalidConfig(Messages.getString("HyadesGAComponentConfiguration_Invalid_Positive_Integer_Attribute_Value_ERROR_", attrValue, attrName, this.getName()));
            }
        }
        if (this.fileFooterSize < 0) {
            throw new AdapterInvalidConfig(Messages.getString("HyadesGAComponentConfiguration_Invalid_Positive_Integer_Attribute_Value_ERROR_", Integer.toString(this.fileFooterSize), attrName, this.getName()));
        }
        this.initialized = true;
    }

    public void setType(String newType) {
        this.type = newType;
    }

    public String getType() {
        return this.type;
    }
}

