/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.connectors.http.adapters;

import java.io.BufferedInputStream;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.SAXReader;
import org.dom4j.io.XMLWriter;
import org.eclipse.ebpm.connectors.http.adapters.IHTTPInputProtocolAdapter;
import org.eclipse.ebpm.core.ExchangeUtils;
import org.eclipse.ebpm.messaging.api.Exchange;
import org.eclipse.ebpm.messaging.api.Message;
import org.eclipse.ebpm.messaging.api.Pattern;
import org.eclipse.ebpm.util.properties.PropertyConfigurator;

public class PlainHTTPInputProtocolAdapter
implements IHTTPInputProtocolAdapter {
    @Override
    public String getAdapterId() {
        return "PlainHTTP";
    }

    @Override
    public Exchange createExchange(HttpServletRequest request, String mep, String sender, String target, PropertyConfigurator pc, Object binding) throws Exception {
        Exchange exchange = null;
        if (mep.equalsIgnoreCase("in-out")) {
            exchange = ExchangeUtils.createExchange((String)sender, (String)target, (Pattern)Pattern.InOut);
        } else if (mep.equalsIgnoreCase("in-only")) {
            exchange = ExchangeUtils.createExchange((String)sender, (String)target, (Pattern)Pattern.InOnly);
        }
        Message in = exchange.getIn();
        Object is = request.getInputStream();
        is = new BufferedInputStream((InputStream)is);
        SAXReader reader = new SAXReader();
        Document doc = reader.read((InputStream)is);
        in.setBody(doc.asXML());
        exchange.setIn(in);
        return exchange;
    }

    @Override
    public void sendAccepted(Exchange exchange, HttpServletRequest request, HttpServletResponse response, PropertyConfigurator pc, Object binding) {
        response.setStatus(202);
    }

    @Override
    public void sendError(Exchange exchange, Exception error, HttpServletRequest request, HttpServletResponse response, PropertyConfigurator pc, Object binding) throws Exception {
        response.setStatus(500);
        XMLWriter responseWriter = new XMLWriter((Writer)response.getWriter());
        Document doc = DocumentHelper.createDocument();
        Element root = doc.addElement("error");
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        error.printStackTrace(pw);
        pw.close();
        root.addText(sw.toString());
        responseWriter.write(doc);
        responseWriter.flush();
        responseWriter.close();
    }

    @Override
    public void sendFault(Exchange exchange, Message fault, HttpServletRequest request, HttpServletResponse response, PropertyConfigurator pc, Object binding) throws Exception {
        XMLWriter responseWriter = new XMLWriter((Writer)response.getWriter());
        Document doc = DocumentHelper.parseText((String)fault.getBodyText());
        responseWriter.write(doc);
        responseWriter.flush();
        responseWriter.close();
    }

    @Override
    public void sendOut(Exchange exchange, Message out, HttpServletRequest request, HttpServletResponse response, PropertyConfigurator pc, Object binding) throws Exception {
        XMLWriter responseWriter = new XMLWriter((Writer)response.getWriter());
        Document doc = DocumentHelper.parseText((String)out.getBodyText());
        responseWriter.write(doc);
        responseWriter.flush();
        responseWriter.close();
    }

    @Override
    public void setProperty(Map<String, String> map) {
    }
}

