/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.soap.bindings.soap.interceptors;

import java.io.OutputStream;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.dom4j.io.XMLWriter;
import org.eclipse.ebpm.soap.api.Fault;
import org.eclipse.ebpm.soap.api.Message;
import org.eclipse.ebpm.soap.bindings.soap.SoapVersion;
import org.eclipse.ebpm.soap.core.AbstractInterceptor;
import org.eclipse.ebpm.soap.util.DomUtil;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SoapDOM4JOutInterceptor
extends AbstractInterceptor {
    private final SoapVersion soapVersion;

    public SoapDOM4JOutInterceptor() {
        this(null);
    }

    public SoapDOM4JOutInterceptor(SoapVersion soapVersion) {
        this.soapVersion = soapVersion;
    }

    @Override
    public void handleMessage(Message message) {
        OutputStream os = message.getContent(OutputStream.class);
        if (os == null) {
            throw new NullPointerException("XMLStreamWriter content not found");
        }
        SoapVersion soapVersion = message.get(SoapVersion.class);
        if (soapVersion == null && (soapVersion = this.soapVersion) == null) {
            throw new IllegalStateException("No soap version specified");
        }
        try {
            String forceEmptySoapHeader;
            XMLWriter writer = new XMLWriter(os);
            Document doc = DocumentHelper.createDocument();
            Namespace soapNameSpace = new Namespace(soapVersion.getPrefix(), soapVersion.getNamespace());
            QName soapEnvelope = new QName(soapVersion.getEnvelope().getLocalPart(), soapNameSpace);
            org.dom4j.Element soapEnvelopeNode = doc.addElement(soapEnvelope);
            org.dom4j.Element soapHeaderElement = null;
            if (message.getSoapHeaders().size() > 0) {
                QName soapHeader = new QName(soapVersion.getHeader().getLocalPart(), soapNameSpace);
                soapHeaderElement = soapEnvelopeNode.addElement(soapHeader);
                for (DocumentFragment df : message.getSoapHeaders().values()) {
                    Element root = DomUtil.getFirstChildElement(df);
                    int i = 0;
                    while (i < root.getChildNodes().getLength()) {
                        Node node = root.getChildNodes().item(i);
                        Namespace ns = new Namespace(node.getPrefix(), node.getNamespaceURI());
                        org.dom4j.Element elementToAdd = soapHeaderElement.addElement(new QName(node.getLocalName(), ns));
                        elementToAdd.setText(node.getTextContent());
                        ++i;
                    }
                }
            }
            if ((forceEmptySoapHeader = (String)message.get("forceEmptySoapHeader")) != null && soapHeaderElement == null) {
                QName soapHeader = new QName(soapVersion.getHeader().getLocalPart(), soapNameSpace);
                soapHeaderElement = soapEnvelopeNode.addElement(soapHeader);
            }
            QName soapBody = new QName(soapVersion.getBody().getLocalPart(), soapNameSpace);
            org.dom4j.Element soapBodyNode = soapEnvelopeNode.addElement(soapBody);
            Document nmDoc = message.getContent(Document.class);
            org.dom4j.Element bodyEl = nmDoc.getRootElement();
            bodyEl.detach();
            soapBodyNode.add(bodyEl);
            writer.write(doc);
            writer.flush();
        }
        catch (Exception e) {
            throw new Fault(e);
        }
    }
}

