/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.soap.ws.addressing;

import javax.xml.namespace.QName;
import org.eclipse.ebpm.common.util.DOMUtil;
import org.eclipse.ebpm.soap.bindings.soap.SoapInterceptor;
import org.eclipse.ebpm.soap.core.AbstractInterceptor;
import org.eclipse.ebpm.soap.util.DomUtil;
import org.eclipse.ebpm.soap.ws.addressing.WsAddressingPolicy;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;

public abstract class AbstractWsAddressingInterceptor
extends AbstractInterceptor
implements SoapInterceptor {
    private final WsAddressingPolicy policy;
    private final boolean server;

    protected AbstractWsAddressingInterceptor(WsAddressingPolicy policy, boolean server) {
        this.policy = policy;
        this.server = server;
    }

    public WsAddressingPolicy getPolicy() {
        return this.policy;
    }

    public boolean isServer() {
        return this.server;
    }

    protected boolean isWSANamespace(String ns) {
        return "http://schemas.xmlsoap.org/ws/2003/03/addressing".equals(ns) || "http://schemas.xmlsoap.org/ws/2004/03/addressing".equals(ns) || "http://schemas.xmlsoap.org/ws/2004/08/addressing".equals(ns) || "http://www.w3.org/2005/08/addressing".equals(ns);
    }

    protected String getHeaderText(Object header) {
        Element el = (Element)((DocumentFragment)header).getFirstChild();
        return DOMUtil.getElementText(el);
    }

    protected DocumentFragment createHeader(QName name, String value) throws Exception {
        Document doc = DomUtil.createDocument();
        DocumentFragment df = doc.createDocumentFragment();
        Element el = doc.createElementNS(name.getNamespaceURI(), this.getQualifiedName(name));
        el.appendChild(doc.createTextNode(value));
        df.appendChild(el);
        return df;
    }

    protected String getPrefix(QName qname, String defaultPrefix) {
        String prefix = qname.getPrefix();
        if (prefix == null || "".equals(prefix)) {
            prefix = defaultPrefix;
        }
        return prefix;
    }

    protected String getQualifiedName(QName qname) {
        String name = qname.getLocalPart();
        String prefix = qname.getPrefix();
        if (prefix != null && !"".equals(prefix)) {
            name = String.valueOf(prefix) + ":" + name;
        }
        return name;
    }
}

