/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ebpm.service.model;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.ebpm.service.model.IComboProvider;
import org.eclipse.ebpm.service.model.IConfigurableComboProvider;
import org.w3c.dom.Node;

public class ComboProviderFactory {
    private Map<String, IComboProvider> providers;

    public ComboProviderFactory() {
        this.init();
    }

    private void init() {
        this.providers = new HashMap<String, IComboProvider>();
    }

    public void addComboProviders(Map<? extends String, ? extends IComboProvider> m) {
        this.providers.putAll(m);
    }

    public IComboProvider getComboProvider(String type, List<Node> comboProviderNodes) {
        IComboProvider provider = null;
        provider = this.providers.get(type);
        try {
            if (provider != null) {
                IComboProvider instance = (IComboProvider)provider.getClass().newInstance();
                if (instance instanceof IConfigurableComboProvider) {
                    ((IConfigurableComboProvider)instance).setConfig(comboProviderNodes);
                }
                return instance;
            }
            StringBuilder sb = new StringBuilder(type);
            sb.append(" has no associated IComboProvider!!!");
        }
        catch (InstantiationException instantiationException) {
            StringBuilder sb = new StringBuilder("Very Strange! Error in the IComboPorovider instantiation: ");
            sb.append(provider.getClass().getName());
            sb.append(" seems a non instantiable class - but was instanced before... this is creepy!");
        }
        catch (IllegalAccessException e) {
            StringBuilder sb = new StringBuilder("Very Strange! Error accessing an IComboPorovider: ");
            sb.append(provider.getClass().getName());
            sb.append(" seems not to have the setConfig() method even if implements IConfigurableComboProvider... this is creepy!");
            e.printStackTrace();
        }
        return null;
    }
}

