/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.engine;

import fr.inria.zvtm.engine.Camera;
import fr.inria.zvtm.engine.ViewPanel;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.VText;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.util.Arrays;
import java.util.Vector;
import javax.swing.JPanel;

public class OffscreenViewPanel
extends ViewPanel {
    protected JPanel panel;
    BufferedImage buffImg;

    public Component getComponent() {
        return this.panel;
    }

    public BufferedImage getImage() {
        return this.buffImg;
    }

    public OffscreenViewPanel(Vector cameras) {
        this.cams = new Camera[cameras.size()];
        for (int nbcam = 0; nbcam < cameras.size(); ++nbcam) {
            this.cams[nbcam] = (Camera)cameras.get(nbcam);
        }
        this.visibilityPadding = new int[this.cams.length][4];
        for (int i = 0; i < this.visibilityPadding.length; ++i) {
            Arrays.fill(this.visibilityPadding[i], 0);
        }
        this.panel.setBackground(Color.white);
        this.size = this.panel.getSize();
    }

    void stop() {
    }

    public void setRefreshRate(int rr) {
        throw new Error("not implemented");
    }

    public int getRefreshRate() {
        throw new Error("not implemented");
    }

    public Dimension getSize() {
        return this.size != null ? this.size : new Dimension(0, 0);
    }

    public BufferedImage rasterize(int w, int h) {
        return this.rasterize(w, h, this.backColor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage rasterize(int w, int h, Color backgroundColor) {
        this.backColor = backgroundColor;
        this.size = new Dimension(w, h);
        Graphics BufferG2D = null;
        Graphics g2d = null;
        if (this.buffImg == null) {
            this.buffImg = new BufferedImage(this.size.width, this.size.height, 2);
        }
        if (BufferG2D == null) {
            BufferG2D = this.buffImg.createGraphics();
        }
        BufferG2D.setFont(VText.getMainFont());
        if (this.antialias) {
            ((Graphics2D)BufferG2D).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        } else {
            ((Graphics2D)BufferG2D).setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        }
        g2d = BufferG2D;
        this.standardStroke = ((Graphics2D)g2d).getStroke();
        this.standardTransform = ((Graphics2D)g2d).getTransform();
        g2d.setPaintMode();
        ((Graphics2D)g2d).setBackground(this.backColor);
        g2d.clearRect(0, 0, this.size.width, this.size.height);
        for (int nbcam = 0; nbcam < this.cams.length; ++nbcam) {
            if (this.cams[nbcam] == null || !this.cams[nbcam].enabled) continue;
            this.camIndex = this.cams[nbcam].getIndex();
            this.drawnGlyphs = this.cams[nbcam].parentSpace.getDrawnGlyphs(this.camIndex);
            Vector vector = this.drawnGlyphs;
            synchronized (vector) {
                this.drawnGlyphs.removeAllElements();
                float uncoef = (float)((this.cams[nbcam].focal + this.cams[nbcam].altitude) / this.cams[nbcam].focal);
                double viewW = this.getSize().width;
                double viewH = this.getSize().height;
                double viewEC = this.cams[nbcam].vx + viewW / 2.0 * (double)uncoef;
                double viewNC = this.cams[nbcam].vy + viewH / 2.0 * (double)uncoef;
                double viewWC = this.cams[nbcam].vx - viewW / 2.0 * (double)uncoef;
                double viewSC = this.cams[nbcam].vy - viewH / 2.0 * (double)uncoef;
                this.gll = this.cams[nbcam].parentSpace.getDrawingList();
                for (int i = 0; i < this.gll.length; ++i) {
                    if (!this.gll[i].visibleInViewport(viewWC, viewNC, viewEC, viewSC, this.cams[nbcam])) continue;
                    Glyph glyph = this.gll[i];
                    synchronized (glyph) {
                        this.gll[i].project(this.cams[nbcam], this.size);
                        if (this.gll[i].isVisible()) {
                            this.gll[i].draw((Graphics2D)g2d, this.size.width, this.size.height, this.cams[nbcam].getIndex(), this.standardStroke, this.standardTransform, 0, 0);
                            this.cams[nbcam].parentSpace.drewGlyph(this.gll[i], this.camIndex);
                        }
                        continue;
                    }
                }
                continue;
            }
        }
        if (this.repaintListener != null) {
            this.repaintListener.viewRepainted(this.parent);
        }
        return this.buffImg;
    }
}

