/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.apt.core.internal.util;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.apt.core.internal.AptPlugin;

public final class FileSystemUtil {
    private FileSystemUtil() {
    }

    public static boolean deleteDerivedResources(IResource resource) throws CoreException {
        if (resource == null) {
            return false;
        }
        if (resource.getType() == 2) {
            boolean deleteFolder = resource.isDerived();
            IResource[] members = ((IFolder)resource).members();
            int i = 0;
            int len = members.length;
            while (i < len) {
                deleteFolder &= FileSystemUtil.deleteDerivedResources(members[i]);
                ++i;
            }
            if (deleteFolder) {
                FileSystemUtil.deleteResource(resource);
                return true;
            }
            return false;
        }
        if (resource.getType() == 1) {
            if (resource.isDerived()) {
                FileSystemUtil.deleteResource(resource);
                return true;
            }
            return false;
        }
        return false;
    }

    private static void deleteResource(IResource resource) {
        block2: {
            try {
                resource.delete(true, null);
            }
            catch (CoreException e) {
                if (!resource.exists()) break block2;
                AptPlugin.log(e, "Unable to delete derived resource " + resource);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void mkdirs(File parent) {
        if (parent == null) {
            return;
        }
        Class<FileSystemUtil> clazz = FileSystemUtil.class;
        synchronized (FileSystemUtil.class) {
            if (!parent.exists()) {
                boolean succeed = false;
                int i = 0;
                while (!succeed && i < 5) {
                    succeed = parent.mkdirs();
                    ++i;
                }
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    public static void makeDerivedParentFolders(IContainer container) throws CoreException {
        if (container instanceof IFolder && !container.exists()) {
            block3: {
                FileSystemUtil.makeDerivedParentFolders(container.getParent());
                try {
                    ((IFolder)container).create(true, true, null);
                }
                catch (CoreException e) {
                    if (container.exists()) break block3;
                    throw e;
                }
            }
            container.setDerived(true, null);
        }
    }

    public static String getContentsOfIFile(IFile file) throws IOException, CoreException {
        return FileSystemUtil.getContents(file.getContents(true));
    }

    public static String getContentsOfFile(File file) throws IOException {
        return FileSystemUtil.getContents(new FileInputStream(file));
    }

    private static String getContents(InputStream in) throws IOException {
        String string;
        try {
            String s;
            int len;
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            byte[] buffer = new byte[512];
            while ((len = in.read(buffer)) > 0) {
                out.write(buffer, 0, len);
            }
            out.close();
            string = s = new String(out.toByteArray(), "UTF8");
        }
        catch (Throwable throwable) {
            try {
                in.close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            in.close();
        }
        catch (IOException iOException) {}
        return string;
    }

    public static void writeStringToIFile(IFile file, String contents) throws IOException, CoreException {
        byte[] data = contents.getBytes("UTF8");
        ByteArrayInputStream input = new ByteArrayInputStream(data);
        if (file.exists()) {
            if (file.isReadOnly()) {
                ResourcesPlugin.getWorkspace().validateEdit(new IFile[]{file}, null);
            }
            file.setContents((InputStream)input, true, false, null);
        } else {
            file.create((InputStream)input, 1, null);
        }
    }

    public static void writeStringToFile(File file, String contents) throws IOException {
        byte[] data = contents.getBytes("UTF8");
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(file));
        try {
            byte[] byArray = data;
            int n = data.length;
            int n2 = 0;
            while (n2 < n) {
                byte b = byArray[n2];
                ((OutputStream)out).write(b);
                ++n2;
            }
        }
        catch (Throwable throwable) {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((OutputStream)out).close();
        }
        catch (IOException iOException) {}
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean compareStreams(InputStream is1, InputStream is2) {
        try {
            int b1 = is1.read();
            while (true) {
                int b2;
                if (b1 == -1) {
                    b2 = is2.read();
                    return -1 == b2;
                }
                b2 = is2.read();
                if (b1 != b2) {
                    return false;
                }
                b1 = is1.read();
            }
        }
        catch (IOException iOException) {
            return false;
        }
    }
}

