/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.efm.execution.configuration.common.ui.editors;

import org.eclipse.core.runtime.Assert;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.efm.execution.configuration.common.ui.api.AbstractConfigurationPage;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.FontMetrics;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;

public abstract class FieldEditor {
    protected String fStoreKey;
    public static final String IS_VALID = "field_editor_is_valid";
    protected static final int HORIZONTAL_GAP = 8;
    private boolean isDefaultPresented = false;
    private String labelText;
    private Label label;
    private IPropertyChangeListener propertyChangeListener;
    private AbstractConfigurationPage fConfigurationPage;

    public String getStoreKey() {
        return this.fStoreKey;
    }

    protected FieldEditor() {
    }

    protected FieldEditor(AbstractConfigurationPage configurationPage, String storeKey, String labelText, Composite parent) {
        this.fConfigurationPage = configurationPage;
        this.fStoreKey = storeKey;
        this.createControl(parent);
    }

    protected abstract void adjustForNumColumns(int var1);

    protected void applyFont() {
    }

    protected void checkParent(Control control, Composite parent) {
        Assert.isTrue((control.getParent() == parent ? 1 : 0) != 0, (String)"Different parents");
    }

    protected void clearErrorMessage() {
        if (this.fConfigurationPage != null) {
            this.fConfigurationPage.propagateErrorMessage(null);
        }
    }

    protected void clearMessage() {
        if (this.fConfigurationPage != null) {
            this.fConfigurationPage.propagateMessage(null);
        }
    }

    protected int convertHorizontalDLUsToPixels(Control control, int dlus) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        int averageWidth = gc.getFontMetrics().getAverageCharWidth();
        gc.dispose();
        double horizontalDialogUnitSize = (double)averageWidth * 0.25;
        return (int)Math.round((double)dlus * horizontalDialogUnitSize);
    }

    protected int convertVerticalDLUsToPixels(Control control, int dlus) {
        GC gc = new GC((Drawable)control);
        gc.setFont(control.getFont());
        int height = gc.getFontMetrics().getHeight();
        gc.dispose();
        double verticalDialogUnitSize = (double)height * 0.125;
        return (int)Math.round((double)dlus * verticalDialogUnitSize);
    }

    protected void createControl(Composite parent) {
        GridLayout layout = new GridLayout();
        layout.numColumns = this.getNumberOfControls();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.horizontalSpacing = 8;
        parent.setLayout((Layout)layout);
        this.doFillIntoGrid(parent, layout.numColumns);
    }

    public void dispose() {
    }

    protected abstract void doFillIntoGrid(Composite var1, int var2);

    public void fillIntoGrid(Composite parent, int numColumns) {
        Assert.isTrue((numColumns >= this.getNumberOfControls() ? 1 : 0) != 0);
        Assert.isTrue((boolean)(parent.getLayout() instanceof GridLayout));
        this.doFillIntoGrid(parent, numColumns);
    }

    protected void fireStateChanged(String property, boolean oldValue, boolean newValue) {
        if (oldValue == newValue) {
            return;
        }
        this.fireValueChanged(property, oldValue ? Boolean.TRUE : Boolean.FALSE, newValue ? Boolean.TRUE : Boolean.FALSE);
    }

    protected void fireValueChanged(String property, Object oldValue, Object newValue) {
        if (this.propertyChangeListener == null) {
            return;
        }
        this.propertyChangeListener.propertyChange(new PropertyChangeEvent((Object)this, property, oldValue, newValue));
    }

    public String getFieldEditorFontName() {
        return "org.eclipse.jface.dialogfont";
    }

    public void setToolTipText(String string) {
        Label control = this.getLabelControl();
        if (control != null) {
            control.setToolTipText(string);
        }
    }

    protected Label getLabelControl() {
        return this.label;
    }

    public Label getLabelControl(Composite parent) {
        if (this.label == null) {
            this.label = this.fConfigurationPage.getWidgetToolkit().newLabel(parent, this.getLabelText(), 16384);
            this.label.setFont(parent.getFont());
            this.label.addDisposeListener(new DisposeListener(){

                public void widgetDisposed(DisposeEvent event) {
                    FieldEditor.this.label = null;
                }
            });
        } else {
            this.checkParent((Control)this.label, parent);
        }
        return this.label;
    }

    public String getLabelText() {
        return this.labelText;
    }

    public abstract int getNumberOfControls();

    protected AbstractConfigurationPage getConfigurationPage() {
        return this.fConfigurationPage;
    }

    protected void init(AbstractConfigurationPage configurationPage, String storeKey, String labelText) {
        Assert.isNotNull((Object)configurationPage);
        this.fConfigurationPage = configurationPage;
        Assert.isNotNull((Object)storeKey);
        this.fStoreKey = storeKey;
        Assert.isNotNull((Object)labelText);
        this.labelText = labelText;
    }

    public boolean isValid() {
        return true;
    }

    public boolean presentsDefaultValue() {
        return this.isDefaultPresented;
    }

    protected void refreshValidState() {
    }

    public void setFocus() {
    }

    public void setLabelText(String text) {
        Assert.isNotNull((Object)text);
        this.labelText = text;
        if (this.label != null) {
            this.label.setText(text);
        }
    }

    protected void setPresentsDefaultValue(boolean booleanValue) {
        this.isDefaultPresented = booleanValue;
    }

    public void setPropertyChangeListener(IPropertyChangeListener listener) {
        this.propertyChangeListener = listener;
    }

    protected void showErrorMessage(String msg) {
        if (this.fConfigurationPage != null) {
            this.fConfigurationPage.propagateErrorMessage(msg);
        }
    }

    protected void showMessage(String msg) {
        if (this.fConfigurationPage != null) {
            this.fConfigurationPage.propagateMessage(msg);
        }
    }

    public void updateLaunchConfigurationDialog() {
        if (this.fConfigurationPage != null) {
            this.fConfigurationPage.propagateGUIupdate();
        }
    }

    protected void setButtonLayoutData(Button button) {
        GridData data = new GridData(256);
        GC gc = new GC((Drawable)button);
        gc.setFont(button.getFont());
        FontMetrics fontMetrics = gc.getFontMetrics();
        gc.dispose();
        int widthHint = Dialog.convertVerticalDLUsToPixels((FontMetrics)fontMetrics, (int)61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
    }

    public void setEnabled(boolean enabled, Composite parent) {
        this.getLabelControl(parent).setEnabled(enabled);
    }

    protected abstract void setDefaultsImpl(ILaunchConfigurationWorkingCopy var1);

    public final void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        this.setDefaultsImpl(configuration);
        this.refreshValidState();
    }

    protected abstract void initializeFromImpl(ILaunchConfiguration var1);

    public final void initializeFrom(ILaunchConfiguration configuration) {
        this.initializeFromImpl(configuration);
        this.refreshValidState();
    }

    protected abstract void performApplyImpl(ILaunchConfigurationWorkingCopy var1);

    public final void performApply(ILaunchConfigurationWorkingCopy configuration) {
        this.performApplyImpl(configuration);
    }
}

