/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.event;

import fr.inria.zvtm.engine.ViewPanel;
import fr.inria.zvtm.engine.VirtualSpaceManager;
import fr.inria.zvtm.event.ViewAdapter;
import fr.inria.zvtm.glyphs.Glyph;
import fr.inria.zvtm.glyphs.VSwingComponent;
import java.awt.Component;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.SwingUtilities;

public class SwingListener
extends ViewAdapter {
    private Component focusedComponent = null;

    @Override
    public void press1(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        this.pickAndForward(v, e);
    }

    @Override
    public void release1(ViewPanel v, int mod, int jpx, int jpy, MouseEvent e) {
        this.pickAndForward(v, e);
    }

    @Override
    public void click1(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
        this.pickAndForward(v, e);
    }

    @Override
    public void click2(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
        this.pickAndForward(v, e);
    }

    @Override
    public void click3(ViewPanel v, int mod, int jpx, int jpy, int clickNumber, MouseEvent e) {
        this.pickAndForward(v, e);
    }

    @Override
    public void mouseMoved(ViewPanel v, int jpx, int jpy, MouseEvent e) {
        this.pickAndForward(v, e);
    }

    @Override
    public void mouseDragged(ViewPanel v, int mod, int buttonNumber, int jpx, int jpy, MouseEvent e) {
        this.pickAndForward(v, e);
    }

    @Override
    public void Kpress(ViewPanel v, char c, int code, int mod, KeyEvent e) {
        if (this.focusedComponent == null) {
            return;
        }
        e.setSource(this.focusedComponent);
        this.focusedComponent.dispatchEvent(e);
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public void Krelease(ViewPanel v, char c, int code, int mod, KeyEvent e) {
        if (this.focusedComponent == null) {
            return;
        }
        e.setSource(this.focusedComponent);
        this.focusedComponent.dispatchEvent(e);
        VirtualSpaceManager.INSTANCE.repaint();
    }

    @Override
    public void Ktype(ViewPanel v, char c, int code, int mod, KeyEvent e) {
        if (this.focusedComponent == null) {
            return;
        }
        e.setSource(this.focusedComponent);
        this.focusedComponent.dispatchEvent(e);
        VirtualSpaceManager.INSTANCE.repaint();
    }

    protected boolean pickAndForward(ViewPanel v, MouseEvent e) {
        this.focusedComponent = null;
        Glyph[] pickList = v.getVCursor().getPicker().getPickedGlyphList();
        if (pickList.length == 0) {
            return false;
        }
        Glyph pickedGlyph = pickList[pickList.length - 1];
        if (pickedGlyph instanceof VSwingComponent) {
            this.redispatchMouse(v, e, (VSwingComponent)pickedGlyph);
            return true;
        }
        return false;
    }

    private void redispatchMouse(ViewPanel v, MouseEvent evt, VSwingComponent c) {
        Point2D.Double vsCoords = v.viewToSpaceCoords(v.cams[v.activeLayer], evt.getX(), evt.getY());
        Point2D pt = this.spaceToComponent(c, vsCoords);
        Component cmp = SwingUtilities.getDeepestComponentAt(c.getComponent(), (int)pt.getX(), (int)pt.getY());
        if (cmp.isFocusable()) {
            this.focusedComponent = cmp;
        }
        Point2D.Double deepestCoords = new Point2D.Double(pt.getX() - (double)cmp.getX(), pt.getY() - (double)cmp.getY());
        evt.translatePoint((int)(((Point2D)deepestCoords).getX() - (double)evt.getX()), (int)(((Point2D)deepestCoords).getY() - (double)evt.getY()));
        evt.setSource(cmp);
        cmp.dispatchEvent(evt);
        VirtualSpaceManager.INSTANCE.repaint();
    }

    protected Point2D spaceToComponent(VSwingComponent c, Point2D vsCoords) {
        return new Point2D.Double(vsCoords.getX() - (c.vx - c.getWidth() / 2.0), c.vy + c.getHeight() / 2.0 - vsCoords.getY());
    }
}

