/*
 * Decompiled with CFR 0.152.
 */
package fr.inria.zvtm.lens;

import fr.inria.zvtm.lens.FixedSizeLens;

public class FSInverseCosineLens
extends FixedSizeLens {
    protected float a = 0.0f;
    protected float b = 0.0f;
    protected float c = 0.0f;
    double d = 0.0;

    public FSInverseCosineLens() {
        this(2.0f, 100, 50, 0, 0);
    }

    public FSInverseCosineLens(float mm) {
        this(mm, 100, 50, 0, 0);
    }

    public FSInverseCosineLens(float mm, int outerRadius, int innerRadius) {
        this(mm, outerRadius, innerRadius, 0, 0);
    }

    public FSInverseCosineLens(float mm, int outerRadius, int innerRadius, int x, int y) {
        this.MM = mm;
        this.LR1 = outerRadius;
        this.LR2 = innerRadius;
        this.updateMagBufferWorkingDimensions();
        this.c = 0.63661975f * (this.MM - 1.0f);
        this.a = 1.0f / (float)(this.LR1 - this.LR2);
        this.b = (float)this.LR2 / (float)(this.LR2 - this.LR1);
        this.lx = x;
        this.ly = y;
    }

    @Override
    public void setOuterRadius(int r) {
        super.setOuterRadius(r);
        this.a = 1.0f / (float)(this.LR1 - this.LR2);
        this.b = (float)this.LR2 / (float)(this.LR2 - this.LR1);
    }

    @Override
    public void setInnerRadius(int r) {
        super.setInnerRadius(r);
        this.a = 1.0f / (float)(this.LR1 - this.LR2);
        this.b = (float)this.LR2 / (float)(this.LR2 - this.LR1);
    }

    @Override
    public void setRadii(int outerRadius, int innerRadius) {
        this.setRadii(outerRadius, innerRadius, true);
    }

    @Override
    public void setRadii(int outerRadius, int innerRadius, boolean forceRaster) {
        super.setRadii(outerRadius, innerRadius, forceRaster);
        this.a = 1.0f / (float)(this.LR1 - this.LR2);
        this.b = (float)this.LR2 / (float)(this.LR2 - this.LR1);
    }

    @Override
    public void setMMandRadii(float mm, int outerRadius, int innerRadius) {
        this.setMMandRadii(mm, outerRadius, innerRadius, true);
    }

    @Override
    public void setMMandRadii(float mm, int outerRadius, int innerRadius, boolean forceRaster) {
        super.setMMandRadii(mm, outerRadius, innerRadius, forceRaster);
        this.a = 1.0f / (float)(this.LR1 - this.LR2);
        this.b = (float)this.LR2 / (float)(this.LR2 - this.LR1);
        this.c = 0.63661975f * (this.MM - 1.0f);
    }

    @Override
    public void setMaximumMagnification(float mm) {
        this.setMaximumMagnification(mm, true);
    }

    @Override
    public void setMaximumMagnification(float mm, boolean forceRaster) {
        super.setMaximumMagnification(mm, forceRaster);
        this.c = 0.63661975f * (this.MM - 1.0f);
    }

    @Override
    public void gf(float x, float y, float[] g) {
        this.d = Math.sqrt((x - (float)this.sw - (float)this.lx) * (x - (float)this.sw - (float)this.lx) + (y - (float)this.sh - (float)this.ly) * (y - (float)this.sh - (float)this.ly));
        if (this.d <= (double)this.LR2) {
            g[0] = g[1] = this.MM;
        } else if (this.d <= (double)this.LR1) {
            g[0] = g[1] = this.MM - this.c * (float)Math.acos((this.d * (double)this.a + (double)this.b - 1.0) * (this.d * (double)this.a + (double)this.b - 1.0));
        } else {
            g[1] = 1.0f;
            g[0] = 1.0f;
        }
    }
}

