/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.garbagecollector;

import java.util.Arrays;
import java.util.HashSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.equinox.internal.p2.core.helpers.Tracing;
import org.eclipse.equinox.p2.metadata.IArtifactKey;
import org.eclipse.equinox.p2.query.IQuery;
import org.eclipse.equinox.p2.query.IQueryResult;
import org.eclipse.equinox.p2.query.QueryUtil;
import org.eclipse.equinox.p2.repository.IRunnableWithProgress;
import org.eclipse.equinox.p2.repository.artifact.IArtifactRepository;

public class CoreGarbageCollector {
    static boolean debugMode = false;

    public synchronized void clean(IArtifactKey[] markSet, final IArtifactRepository aRepository) {
        HashSet<IArtifactKey> set = new HashSet<IArtifactKey>(Arrays.asList(markSet));
        IQuery query = QueryUtil.createQuery(IArtifactKey.class, (String)"unique($0)", (Object[])new Object[]{set});
        final IQueryResult inactive = aRepository.query(query, null);
        aRepository.executeBatch(new IRunnableWithProgress(){

            public void run(IProgressMonitor monitor) {
                for (IArtifactKey key : inactive) {
                    aRepository.removeDescriptor(key);
                    if (!debugMode) continue;
                    Tracing.debug((String)("Key removed:" + key));
                }
            }
        }, (IProgressMonitor)new NullProgressMonitor());
    }

    public static void setDebugMode(boolean inDebugMode) {
        debugMode = inDebugMode;
    }
}

