/*
 * Decompiled with CFR 0.152.
 */
package org.slf4j.profiler;

import org.slf4j.profiler.DurationUnit;
import org.slf4j.profiler.TimeInstrument;
import org.slf4j.profiler.TimeInstrumentStatus;
import org.slf4j.profiler.Util;

public class StopWatch
implements TimeInstrument {
    private String name;
    private long startTime;
    private long stopTime;
    TimeInstrumentStatus status;

    public StopWatch(String name) {
        this.start(name);
    }

    StopWatch(StopWatch original) {
        this.name = original.name;
        this.startTime = original.startTime;
        this.stopTime = original.stopTime;
        this.status = original.status;
    }

    public void start(String name) {
        this.name = name;
        this.startTime = System.nanoTime();
        this.status = TimeInstrumentStatus.STARTED;
    }

    public String getName() {
        return this.name;
    }

    public TimeInstrument stop() {
        if (this.status == TimeInstrumentStatus.STOPPED) {
            return this;
        }
        return this.stop(System.nanoTime());
    }

    public StopWatch stop(long stopTime) {
        this.status = TimeInstrumentStatus.STOPPED;
        this.stopTime = stopTime;
        return this;
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        buf.append("StopWatch [");
        buf.append(this.name);
        buf.append("] ");
        switch (this.status) {
            case STARTED: {
                buf.append("STARTED");
                break;
            }
            case STOPPED: {
                buf.append("elapsed time: ");
                buf.append(Util.durationInDurationUnitsAsStr(this.elapsedTime(), DurationUnit.MICROSECOND));
                break;
            }
            default: {
                throw new IllegalStateException("Status " + (Object)((Object)this.status) + " is not expected");
            }
        }
        return buf.toString();
    }

    public final long elapsedTime() {
        if (this.status == TimeInstrumentStatus.STARTED) {
            return 0L;
        }
        return this.stopTime - this.startTime;
    }

    public TimeInstrumentStatus getStatus() {
        return this.status;
    }

    public void print() {
        System.out.println(this.toString());
    }

    public void log() {
        throw new UnsupportedOperationException("A stopwatch instance does not know how to log");
    }
}

