/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jface.text.source;

import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.rules.BufferedDocumentScanner;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.Token;

public class FastJavaLikePartitionScanner
implements IPartitionTokenScanner {
    private static final int JAVA = 0;
    private static final int SINGLE_LINE_COMMENT = 1;
    private static final int MULTI_LINE_COMMENT = 2;
    private static final int JAVADOC = 3;
    private static final int CHARACTER = 4;
    private static final int STRING = 5;
    private static final int NONE = 0;
    private static final int BACKSLASH = 1;
    private static final int SLASH = 2;
    private static final int SLASH_STAR = 3;
    private static final int SLASH_STAR_STAR = 4;
    private static final int STAR = 5;
    private static final int CARRIAGE_RETURN = 6;
    private final BufferedDocumentScanner fScanner = new BufferedDocumentScanner(1000);
    private int fTokenOffset;
    private int fTokenLength;
    private int fState;
    private int fLast;
    private int fPrefixLength;
    private boolean fEmulate = false;
    private int fJavaOffset;
    private int fJavaLength;
    private final IToken[] fTokens;

    public FastJavaLikePartitionScanner(String singleLineCommentKey, String multiLineCommentKey, String javaDocKey, String characterKey, String stringKey) {
        this.fTokens = new IToken[]{new Token(null), new Token(singleLineCommentKey), new Token(multiLineCommentKey), new Token(javaDocKey), new Token(characterKey), new Token(stringKey)};
    }

    @Override
    public IToken nextToken() {
        if (this.fEmulate) {
            if (this.fJavaOffset != -1 && this.fTokenOffset + this.fTokenLength != this.fJavaOffset + this.fJavaLength) {
                this.fTokenOffset += this.fTokenLength;
                return this.fTokens[0];
            }
            this.fJavaOffset = -1;
            this.fJavaLength = 0;
        }
        this.fTokenOffset += this.fTokenLength;
        this.fTokenLength = this.fPrefixLength;
        block56: while (true) {
            int ch = this.fScanner.read();
            switch (ch) {
                case -1: {
                    if (this.fTokenLength > 0) {
                        this.fLast = 0;
                        return this.preFix(this.fState, 0, 0, 0);
                    }
                    this.fLast = 0;
                    this.fPrefixLength = 0;
                    return Token.EOF;
                }
                case 13: {
                    if (!this.fEmulate && this.fLast != 6) {
                        this.fLast = 6;
                        ++this.fTokenLength;
                        continue block56;
                    }
                    switch (this.fState) {
                        case 1: 
                        case 4: 
                        case 5: {
                            if (this.fTokenLength > 0) {
                                IToken token = this.fTokens[this.fState];
                                if (this.fEmulate) {
                                    ++this.fTokenLength;
                                    this.fLast = 0;
                                    this.fPrefixLength = 0;
                                } else {
                                    this.fLast = 6;
                                    this.fPrefixLength = 1;
                                }
                                this.fState = 0;
                                return token;
                            }
                            this.consume();
                            continue block56;
                        }
                    }
                    this.consume();
                    continue block56;
                }
                case 10: {
                    switch (this.fState) {
                        case 1: 
                        case 4: 
                        case 5: {
                            return this.postFix(this.fState);
                        }
                    }
                    this.consume();
                    continue block56;
                }
            }
            if (!this.fEmulate && this.fLast == 6) {
                switch (this.fState) {
                    case 1: 
                    case 4: 
                    case 5: {
                        int newState;
                        int last;
                        switch (ch) {
                            case 47: {
                                last = 2;
                                newState = 0;
                                break;
                            }
                            case 42: {
                                last = 5;
                                newState = 0;
                                break;
                            }
                            case 39: {
                                last = 0;
                                newState = 4;
                                break;
                            }
                            case 34: {
                                last = 0;
                                newState = 5;
                                break;
                            }
                            case 13: {
                                last = 6;
                                newState = 0;
                                break;
                            }
                            case 92: {
                                last = 1;
                                newState = 0;
                                break;
                            }
                            default: {
                                last = 0;
                                newState = 0;
                            }
                        }
                        this.fLast = 0;
                        return this.preFix(this.fState, newState, last, 1);
                    }
                }
            }
            block22 : switch (this.fState) {
                case 0: {
                    switch (ch) {
                        case 47: {
                            if (this.fLast == 2) {
                                if (this.fTokenLength - FastJavaLikePartitionScanner.getLastLength(this.fLast) > 0) {
                                    return this.preFix(0, 1, 0, 2);
                                }
                                this.preFix(0, 1, 0, 2);
                                this.fTokenOffset += this.fTokenLength;
                                this.fTokenLength = this.fPrefixLength;
                                break;
                            }
                            ++this.fTokenLength;
                            this.fLast = 2;
                            break;
                        }
                        case 42: {
                            if (this.fLast == 2) {
                                if (this.fTokenLength - FastJavaLikePartitionScanner.getLastLength(this.fLast) > 0) {
                                    return this.preFix(0, 2, 3, 2);
                                }
                                this.preFix(0, 2, 3, 2);
                                this.fTokenOffset += this.fTokenLength;
                                this.fTokenLength = this.fPrefixLength;
                                break;
                            }
                            this.consume();
                            break;
                        }
                        case 39: {
                            this.fLast = 0;
                            if (this.fTokenLength > 0) {
                                return this.preFix(0, 4, 0, 1);
                            }
                            this.preFix(0, 4, 0, 1);
                            this.fTokenOffset += this.fTokenLength;
                            this.fTokenLength = this.fPrefixLength;
                            break;
                        }
                        case 34: {
                            this.fLast = 0;
                            if (this.fTokenLength > 0) {
                                return this.preFix(0, 5, 0, 1);
                            }
                            this.preFix(0, 5, 0, 1);
                            this.fTokenOffset += this.fTokenLength;
                            this.fTokenLength = this.fPrefixLength;
                            break;
                        }
                        default: {
                            this.consume();
                            break;
                        }
                    }
                    break;
                }
                case 1: {
                    this.consume();
                    break;
                }
                case 3: {
                    switch (ch) {
                        case 47: {
                            switch (this.fLast) {
                                case 4: {
                                    return this.postFix(2);
                                }
                                case 5: {
                                    return this.postFix(3);
                                }
                            }
                            this.consume();
                            break;
                        }
                        case 42: {
                            ++this.fTokenLength;
                            this.fLast = 5;
                            break;
                        }
                        default: {
                            this.consume();
                            break;
                        }
                    }
                    break;
                }
                case 2: {
                    switch (ch) {
                        case 42: {
                            if (this.fLast == 3) {
                                this.fLast = 4;
                                ++this.fTokenLength;
                                this.fState = 3;
                                break;
                            }
                            ++this.fTokenLength;
                            this.fLast = 5;
                            break;
                        }
                        case 47: {
                            if (this.fLast == 5) {
                                return this.postFix(2);
                            }
                            this.consume();
                            break;
                        }
                        default: {
                            this.consume();
                            break;
                        }
                    }
                    break;
                }
                case 5: {
                    switch (ch) {
                        case 92: {
                            this.fLast = this.fLast == 1 ? 0 : 1;
                            ++this.fTokenLength;
                            break;
                        }
                        case 34: {
                            if (this.fLast != 1) {
                                return this.postFix(5);
                            }
                            this.consume();
                            break;
                        }
                        default: {
                            this.consume();
                            break;
                        }
                    }
                    break;
                }
                case 4: {
                    switch (ch) {
                        case 92: {
                            this.fLast = this.fLast == 1 ? 0 : 1;
                            ++this.fTokenLength;
                            break block22;
                        }
                        case 39: {
                            if (this.fLast != 1) {
                                return this.postFix(4);
                            }
                            this.consume();
                            break block22;
                        }
                        default: {
                            this.consume();
                        }
                    }
                }
            }
        }
    }

    private static final int getLastLength(int last) {
        switch (last) {
            default: {
                return -1;
            }
            case 0: {
                return 0;
            }
            case 1: 
            case 2: 
            case 5: 
            case 6: {
                return 1;
            }
            case 3: {
                return 2;
            }
            case 4: 
        }
        return 3;
    }

    private final void consume() {
        ++this.fTokenLength;
        this.fLast = 0;
    }

    private final IToken postFix(int state) {
        ++this.fTokenLength;
        this.fLast = 0;
        this.fState = 0;
        this.fPrefixLength = 0;
        return this.fTokens[state];
    }

    private final IToken preFix(int state, int newState, int last, int prefixLength) {
        if (this.fEmulate && state == 0 && this.fTokenLength - FastJavaLikePartitionScanner.getLastLength(this.fLast) > 0) {
            this.fTokenLength -= FastJavaLikePartitionScanner.getLastLength(this.fLast);
            this.fJavaOffset = this.fTokenOffset;
            this.fJavaLength = this.fTokenLength;
            this.fTokenLength = 1;
            this.fState = newState;
            this.fPrefixLength = prefixLength;
            this.fLast = last;
            return this.fTokens[state];
        }
        this.fTokenLength -= FastJavaLikePartitionScanner.getLastLength(this.fLast);
        this.fLast = last;
        this.fPrefixLength = prefixLength;
        IToken token = this.fTokens[state];
        this.fState = newState;
        return token;
    }

    private int getState(String contentType) {
        if (contentType == null) {
            return 0;
        }
        if (contentType.equals(this.fTokens[1].getData())) {
            return 1;
        }
        if (contentType.equals(this.fTokens[2].getData())) {
            return 2;
        }
        if (contentType.equals(this.fTokens[3].getData())) {
            return 3;
        }
        if (contentType.equals(this.fTokens[5].getData())) {
            return 5;
        }
        if (contentType.equals(this.fTokens[4].getData())) {
            return 4;
        }
        return 0;
    }

    @Override
    public void setPartialRange(IDocument document, int offset, int length, String contentType, int partitionOffset) {
        this.fScanner.setRange(document, offset, length);
        this.fTokenOffset = partitionOffset;
        this.fTokenLength = 0;
        this.fPrefixLength = offset - partitionOffset;
        this.fLast = 0;
        this.fState = offset == partitionOffset ? 0 : this.getState(contentType);
        if (this.fEmulate) {
            this.fJavaOffset = -1;
            this.fJavaLength = 0;
        }
    }

    @Override
    public void setRange(IDocument document, int offset, int length) {
        this.fScanner.setRange(document, offset, length);
        this.fTokenOffset = offset;
        this.fTokenLength = 0;
        this.fPrefixLength = 0;
        this.fLast = 0;
        this.fState = 0;
        if (this.fEmulate) {
            this.fJavaOffset = -1;
            this.fJavaLength = 0;
        }
    }

    @Override
    public int getTokenLength() {
        return this.fTokenLength;
    }

    @Override
    public int getTokenOffset() {
        return this.fTokenOffset;
    }
}

