/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.xtext.xbase.compiler;

import com.google.common.collect.Sets;
import com.google.inject.Inject;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.common.types.JvmArrayType;
import org.eclipse.xtext.common.types.JvmConstructor;
import org.eclipse.xtext.common.types.JvmFormalParameter;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeParameter;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.JvmVoid;
import org.eclipse.xtext.common.types.access.impl.URIHelperConstants;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.xbase.XAbstractFeatureCall;
import org.eclipse.xtext.xbase.XBlockExpression;
import org.eclipse.xtext.xbase.XConstructorCall;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XFeatureCall;
import org.eclipse.xtext.xbase.XVariableDeclaration;
import org.eclipse.xtext.xbase.compiler.JavaKeywords;
import org.eclipse.xtext.xbase.compiler.Later;
import org.eclipse.xtext.xbase.compiler.TypeReferenceSerializer;
import org.eclipse.xtext.xbase.compiler.output.ITreeAppendable;
import org.eclipse.xtext.xbase.controlflow.IEarlyExitComputer;
import org.eclipse.xtext.xbase.featurecalls.IdentifiableSimpleNameProvider;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.Procedures;
import org.eclipse.xtext.xbase.typesystem.IBatchTypeResolver;
import org.eclipse.xtext.xbase.typesystem.IResolvedTypes;
import org.eclipse.xtext.xbase.typesystem.references.ITypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.references.LightweightTypeReference;
import org.eclipse.xtext.xbase.typesystem.references.StandardTypeReferenceOwner;
import org.eclipse.xtext.xbase.typesystem.util.CommonTypeComputationServices;

public abstract class AbstractXbaseCompiler {
    @Inject
    private TypeReferenceSerializer referenceSerializer;
    @Inject
    private CommonTypeComputationServices services;
    @Inject
    private JavaKeywords javaUtils;
    @Inject
    private IBatchTypeResolver typeResolver;
    @Inject
    private IEarlyExitComputer exitComputer;
    @Inject
    private IdentifiableSimpleNameProvider nameProvider;

    public TypeReferenceSerializer getTypeReferenceSerializer() {
        return this.referenceSerializer;
    }

    private IBatchTypeResolver getTypeResolver() {
        return this.typeResolver;
    }

    protected JvmType findKnownTopLevelType(Class<?> rawType, Notifier context) {
        if (rawType.isArray()) {
            throw new IllegalArgumentException(rawType.getCanonicalName());
        }
        if (rawType.isPrimitive()) {
            throw new IllegalArgumentException(rawType.getName());
        }
        ResourceSet resourceSet = EcoreUtil2.getResourceSet((Notifier)context);
        if (resourceSet == null) {
            return null;
        }
        Resource typeResource = resourceSet.getResource(URIHelperConstants.OBJECTS_URI.appendSegment(rawType.getName()), true);
        EList resourceContents = typeResource.getContents();
        if (resourceContents.isEmpty()) {
            return null;
        }
        JvmType type = (JvmType)resourceContents.get(0);
        return type;
    }

    protected JvmType findKnownType(Class<?> rawType, Notifier context) {
        if (rawType.isArray()) {
            throw new IllegalArgumentException(rawType.getCanonicalName());
        }
        if (rawType.isPrimitive()) {
            throw new IllegalArgumentException(rawType.getName());
        }
        ResourceSet resourceSet = EcoreUtil2.getResourceSet((Notifier)context);
        if (resourceSet == null) {
            return null;
        }
        Class<?> declaringClass = rawType.getDeclaringClass();
        if (declaringClass == null) {
            return this.findKnownTopLevelType(rawType, (Notifier)resourceSet);
        }
        JvmType result = (JvmType)resourceSet.getEObject(URIHelperConstants.OBJECTS_URI.appendSegment(declaringClass.getName()).appendFragment(rawType.getName()), true);
        return result;
    }

    protected CommonTypeComputationServices getTypeComputationServices() {
        return this.services;
    }

    protected ITypeReferenceOwner newTypeReferenceOwner(EObject context) {
        return new StandardTypeReferenceOwner(this.services, context);
    }

    protected LightweightTypeReference toLightweight(JvmTypeReference reference, EObject context) {
        return this.newTypeReferenceOwner(context).toLightweightTypeReference(reference);
    }

    public ITreeAppendable compile(XExpression obj, ITreeAppendable appendable, LightweightTypeReference expectedReturnType) {
        this.compile(obj, appendable, expectedReturnType, null);
        return appendable;
    }

    public ITreeAppendable compileAsJavaExpression(XExpression obj, ITreeAppendable parentAppendable, JvmTypeReference expectedType) {
        LightweightTypeReference converted = null;
        if (expectedType != null) {
            converted = this.newTypeReferenceOwner(obj).toLightweightTypeReference(expectedType);
        }
        return this.compileAsJavaExpression(obj, parentAppendable, converted);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public ITreeAppendable compileAsJavaExpression(XExpression obj, ITreeAppendable parentAppendable, LightweightTypeReference expectedType) {
        boolean needsToBeWrapped;
        ITreeAppendable appendable = parentAppendable.trace(obj, true);
        if (expectedType == null && (expectedType = this.getLightweightReturnType(obj)) == null) {
            expectedType = this.getLightweightType(obj);
        }
        boolean isPrimitiveVoidExpected = expectedType.isPrimitiveVoid();
        boolean isPrimitiveVoid = this.isPrimitiveVoid(obj);
        boolean earlyExit = this.isEarlyExit(obj);
        boolean needsSneakyThrow = this.needsSneakyThrow(obj, Collections.<JvmTypeReference>emptySet());
        boolean bl = needsToBeWrapped = earlyExit || needsSneakyThrow || !this.canCompileToJavaExpression(obj, appendable);
        if (needsToBeWrapped) {
            appendable.openScope();
            try {
                Object thisElement;
                if (appendable.hasObject("this") && (thisElement = appendable.getObject("this")) instanceof JvmType) {
                    Object superElement;
                    appendable.declareVariable(thisElement, String.valueOf(((JvmType)thisElement).getSimpleName()) + ".this");
                    if (appendable.hasObject("super") && (superElement = appendable.getObject("super")) instanceof JvmType) {
                        appendable.declareVariable(superElement, String.valueOf(((JvmType)thisElement).getSimpleName()) + ".super");
                    }
                }
                appendable.append("new ");
                JvmType procedureOrFunction = null;
                procedureOrFunction = isPrimitiveVoidExpected ? this.findKnownType(Procedures.Procedure0.class, (Notifier)obj) : this.findKnownType(Functions.Function0.class, (Notifier)obj);
                if (procedureOrFunction != null) {
                    appendable.append(procedureOrFunction);
                    if (!isPrimitiveVoidExpected) {
                        appendable.append("<");
                        appendable.append(expectedType.getWrapperTypeIfPrimitive());
                        appendable.append(">");
                    }
                } else {
                    appendable.append("Object");
                }
                appendable.append("() {").increaseIndentation();
                appendable.newLine().append("public ");
                appendable.append(expectedType.getWrapperTypeIfPrimitive());
                appendable.append(" apply() {").increaseIndentation();
                if (needsSneakyThrow) {
                    appendable.newLine().append("try {").increaseIndentation();
                }
                this.internalToJavaStatement(obj, appendable, !isPrimitiveVoidExpected && !isPrimitiveVoid && !earlyExit);
                if (!isPrimitiveVoidExpected && !earlyExit) {
                    appendable.newLine().append("return ");
                    if (isPrimitiveVoid && !isPrimitiveVoidExpected) {
                        this.appendDefaultLiteral(appendable, expectedType);
                    } else {
                        this.internalToJavaExpression(obj, appendable);
                    }
                    appendable.append(";");
                }
                if (needsSneakyThrow) {
                    this.generateCheckedExceptionHandling(appendable);
                }
                appendable.decreaseIndentation().newLine().append("}");
                appendable.decreaseIndentation().newLine().append("}.apply()");
                if (!expectedType.isPrimitive()) return parentAppendable;
                appendable.append(".").append(expectedType.getSimpleName()).append("Value()");
                return parentAppendable;
            }
            finally {
                appendable.closeScope();
            }
        } else {
            this.internalToJavaExpression(obj, appendable);
        }
        return parentAppendable;
    }

    protected void appendDefaultLiteral(ITreeAppendable b, LightweightTypeReference type) {
        if (type != null && type.isPrimitive()) {
            Primitives.Primitive primitiveKind = type.getPrimitiveKind();
            switch (primitiveKind) {
                case Boolean: {
                    b.append("false");
                    break;
                }
                default: {
                    b.append("0");
                    break;
                }
            }
        } else {
            b.append("null");
        }
    }

    protected void generateCheckedExceptionHandling(ITreeAppendable appendable) {
        String name = appendable.declareSyntheticVariable(new Object(), "_e");
        appendable.decreaseIndentation().newLine().append("} catch (").append(Throwable.class).append(" ").append(name).append(") {").increaseIndentation();
        appendable.newLine().append("throw ");
        appendable.append(Exceptions.class);
        appendable.append(".sneakyThrow(");
        appendable.append(name);
        appendable.append(");");
        appendable.decreaseIndentation().newLine().append("}");
    }

    protected boolean canCompileToJavaExpression(XExpression expression, ITreeAppendable appendable) {
        return this.internalCanCompileToJavaExpression(expression, appendable);
    }

    protected boolean internalCanCompileToJavaExpression(XExpression expression, ITreeAppendable appendable) {
        return true;
    }

    public ITreeAppendable compile(XExpression obj, ITreeAppendable parentAppendable, JvmTypeReference expectedReturnType, Set<JvmTypeReference> declaredExceptions) {
        LightweightTypeReference converted = null;
        if (expectedReturnType != null) {
            converted = this.newTypeReferenceOwner(obj).toLightweightTypeReference(expectedReturnType);
        }
        return this.compile(obj, parentAppendable, converted, declaredExceptions);
    }

    public ITreeAppendable compile(XExpression obj, ITreeAppendable parentAppendable, LightweightTypeReference expectedReturnType, Set<JvmTypeReference> declaredExceptions) {
        if (declaredExceptions == null) {
            declaredExceptions = Sets.newHashSet();
            assert (declaredExceptions != null);
        }
        ITreeAppendable appendable = parentAppendable.trace(obj, true);
        boolean isPrimitiveVoidExpected = expectedReturnType.isPrimitiveVoid();
        boolean isPrimitiveVoid = this.isPrimitiveVoid(obj);
        boolean earlyExit = this.isEarlyExit(obj);
        boolean needsSneakyThrow = this.needsSneakyThrow(obj, declaredExceptions);
        if (needsSneakyThrow && isPrimitiveVoidExpected && this.hasJvmConstructorCall(obj)) {
            this.compileWithJvmConstructorCall((XBlockExpression)obj, appendable);
            return parentAppendable;
        }
        if (needsSneakyThrow) {
            appendable.newLine().append("try {").increaseIndentation();
        }
        this.internalToJavaStatement(obj, appendable, !isPrimitiveVoidExpected && !isPrimitiveVoid && !earlyExit);
        if (!isPrimitiveVoidExpected && !earlyExit) {
            appendable.newLine().append("return ");
            if (isPrimitiveVoid && !isPrimitiveVoidExpected) {
                this.appendDefaultLiteral(appendable, expectedReturnType);
            } else {
                this.internalToConvertedExpression(obj, appendable, expectedReturnType);
            }
            appendable.append(";");
        }
        if (needsSneakyThrow) {
            this.generateCheckedExceptionHandling(appendable);
        }
        return parentAppendable;
    }

    protected void compileWithJvmConstructorCall(XBlockExpression obj, ITreeAppendable apendable) {
        EList<XExpression> expressions = obj.getExpressions();
        this.internalToJavaStatement((XExpression)expressions.get(0), apendable.trace(obj, false), false);
        if (expressions.size() == 1) {
            return;
        }
        apendable.newLine().append("try {").increaseIndentation();
        ITreeAppendable b = apendable.trace(obj, false);
        int i = 1;
        while (i < expressions.size()) {
            XExpression ex = (XExpression)expressions.get(i);
            this.internalToJavaStatement(ex, b, false);
            ++i;
        }
        this.generateCheckedExceptionHandling(apendable);
    }

    protected boolean hasJvmConstructorCall(XExpression obj) {
        if (!(obj instanceof XBlockExpression)) {
            return false;
        }
        XBlockExpression blockExpression = (XBlockExpression)obj;
        EList<XExpression> expressions = blockExpression.getExpressions();
        if (expressions.isEmpty()) {
            return false;
        }
        XExpression expr = (XExpression)expressions.get(0);
        if (!(expr instanceof XFeatureCall)) {
            return false;
        }
        XFeatureCall featureCall = (XFeatureCall)expr;
        return featureCall.getFeature() instanceof JvmConstructor;
    }

    protected boolean needsSneakyThrow(XExpression obj, Collection<JvmTypeReference> declaredExceptions) {
        IResolvedTypes resolvedTypes = this.getResolvedTypes(obj);
        List<LightweightTypeReference> thrownExceptions = resolvedTypes.getThrownExceptions(obj);
        return this.hasUnhandledException(thrownExceptions, declaredExceptions);
    }

    protected boolean hasUnhandledException(List<LightweightTypeReference> thrownExceptions, Collection<JvmTypeReference> declaredExceptions) {
        for (LightweightTypeReference thrownException : thrownExceptions) {
            if (thrownException.isSubtypeOf(RuntimeException.class) || !this.isUnhandledException(thrownException, declaredExceptions)) continue;
            return true;
        }
        return false;
    }

    protected boolean isUnhandledException(LightweightTypeReference thrownException, Collection<JvmTypeReference> declaredExceptions) {
        for (JvmTypeReference declaredException : declaredExceptions) {
            if (!thrownException.isSubtypeOf(declaredException.getType())) continue;
            return false;
        }
        return true;
    }

    public ITreeAppendable compile(XBlockExpression expr, ITreeAppendable b, LightweightTypeReference expectedReturnType) {
        boolean isPrimitiveVoidExpected = expectedReturnType.isPrimitiveVoid();
        boolean isPrimitiveVoid = this.isPrimitiveVoid(expr);
        boolean earlyExit = this.isEarlyExit(expr);
        boolean isImplicitReturn = !isPrimitiveVoidExpected && !isPrimitiveVoid && !earlyExit;
        EList<XExpression> expressions = expr.getExpressions();
        int i = 0;
        while (i < expressions.size()) {
            XExpression ex = (XExpression)expressions.get(i);
            if (i < expressions.size() - 1) {
                this.internalToJavaStatement(ex, b.trace(ex, true), false);
            } else {
                this.internalToJavaStatement(ex, b.trace(ex, true), isImplicitReturn);
                if (isImplicitReturn) {
                    b.newLine().append("return (");
                    this.internalToConvertedExpression(ex, b, expectedReturnType);
                    b.append(");");
                }
            }
            ++i;
        }
        return b;
    }

    protected boolean isEarlyExit(XExpression expr) {
        return this.exitComputer.isEarlyExit(expr);
    }

    protected boolean isPrimitiveVoid(JvmTypeReference typeRef) {
        JvmType type = typeRef.getType();
        if (type instanceof JvmVoid) {
            return !type.eIsProxy();
        }
        return false;
    }

    protected JvmTypeReference getType(XExpression expr) {
        LightweightTypeReference actualType = this.getLightweightType(expr);
        if (actualType != null) {
            return actualType.toTypeReference();
        }
        return null;
    }

    protected JvmTypeReference getType(JvmIdentifiableElement identifiable) {
        LightweightTypeReference actualType = this.getLightweightType(identifiable);
        if (actualType != null) {
            return actualType.toTypeReference();
        }
        return null;
    }

    protected LightweightTypeReference getLightweightType(XExpression expr) {
        IResolvedTypes resolvedTypes = this.getResolvedTypes(expr);
        LightweightTypeReference actualType = resolvedTypes.getActualType(expr);
        return actualType;
    }

    protected LightweightTypeReference getLightweightType(JvmIdentifiableElement identifiable) {
        IResolvedTypes resolvedTypes = this.getResolvedTypes((EObject)identifiable);
        LightweightTypeReference actualType = resolvedTypes.getActualType(identifiable);
        return actualType;
    }

    protected LightweightTypeReference getLightweightReturnType(XExpression expr) {
        IResolvedTypes resolvedTypes = this.getResolvedTypes(expr);
        LightweightTypeReference returnType = resolvedTypes.getReturnType(expr);
        return returnType;
    }

    protected IResolvedTypes getResolvedTypes(EObject obj) {
        return this.getTypeResolver().resolveTypes(obj);
    }

    protected JvmTypeReference getExpectedType(XExpression expr) {
        LightweightTypeReference expectedType = this.getLightweightExpectedType(expr);
        if (expectedType != null) {
            return expectedType.toTypeReference();
        }
        return null;
    }

    protected LightweightTypeReference getLightweightExpectedType(XExpression expr) {
        IResolvedTypes resolvedTypes = this.getResolvedTypes(expr);
        LightweightTypeReference expectedType = resolvedTypes.getExpectedType(expr);
        return expectedType;
    }

    protected abstract void internalToConvertedExpression(XExpression var1, ITreeAppendable var2, LightweightTypeReference var3);

    protected boolean isPrimitiveVoid(XExpression xExpression) {
        LightweightTypeReference type = this.getLightweightType(xExpression);
        return type != null && type.isPrimitiveVoid();
    }

    protected final void internalToJavaStatement(XExpression obj, ITreeAppendable builder, boolean isReferenced) {
        ITreeAppendable trace = builder.trace(obj, true);
        this.doInternalToJavaStatement(obj, trace, isReferenced);
    }

    protected void doInternalToJavaStatement(XExpression obj, ITreeAppendable builder, boolean isReferenced) {
        this._toJavaStatement(obj, builder, isReferenced);
    }

    public void toJavaExpression(XExpression obj, ITreeAppendable appendable) {
        this.internalToJavaExpression(obj, appendable.trace(obj, true));
    }

    public void toJavaStatement(XExpression obj, ITreeAppendable appendable, boolean isReferenced) {
        this.internalToJavaStatement(obj, appendable.trace(obj, true), isReferenced);
    }

    protected void internalToJavaExpression(XExpression obj, ITreeAppendable appendable) {
        this._toJavaExpression(obj, appendable);
    }

    public void _toJavaStatement(XExpression func, ITreeAppendable b, boolean isReferenced) {
        throw new UnsupportedOperationException("Coudn't find a compilation strategy for expressions of type " + func.getClass().getCanonicalName());
    }

    public void _toJavaExpression(XExpression func, ITreeAppendable b) {
        throw new UnsupportedOperationException("Coudn't find a compilation strategy for expressions of type " + func.getClass().getCanonicalName());
    }

    protected void serialize(JvmTypeReference type, EObject context, ITreeAppendable appendable) {
        this.serialize(type, context, appendable, false, true);
    }

    protected void serialize(JvmTypeReference type, EObject context, ITreeAppendable appendable, boolean withoutConstraints, boolean paramsToWildcard) {
        this.serialize(type, context, appendable, withoutConstraints, paramsToWildcard, false, true);
    }

    protected void serialize(JvmTypeReference type, EObject context, ITreeAppendable appendable, boolean withoutConstraints, boolean paramsToWildcard, boolean paramsToObject, boolean allowPrimitives) {
        this.referenceSerializer.serialize(type, context, appendable, withoutConstraints, paramsToWildcard, paramsToObject, allowPrimitives);
    }

    protected boolean isReferenceToForeignTypeParameter(JvmTypeReference reference, EObject context) {
        JvmType type = reference.getType();
        if (type instanceof JvmTypeParameter) {
            return !this.referenceSerializer.isLocalTypeParameter(context, (JvmTypeParameter)type);
        }
        return false;
    }

    protected JvmTypeReference resolveMultiType(JvmTypeReference typeRef, EObject context) {
        return this.referenceSerializer.resolveMultiType(typeRef, context);
    }

    protected String getVarName(Object ex, ITreeAppendable appendable) {
        String name = appendable.getName(ex);
        return name;
    }

    public void setNameProvider(IdentifiableSimpleNameProvider nameProvider) {
        this.nameProvider = nameProvider;
    }

    protected IdentifiableSimpleNameProvider getNameProvider() {
        return this.nameProvider;
    }

    protected String getFavoriteVariableName(EObject ex) {
        if (ex instanceof XVariableDeclaration) {
            return ((XVariableDeclaration)ex).getName();
        }
        if (ex instanceof JvmFormalParameter) {
            return ((JvmFormalParameter)ex).getName();
        }
        if (ex instanceof JvmArrayType) {
            return this.getFavoriteVariableName((EObject)((JvmArrayType)ex).getComponentType());
        }
        if (ex instanceof JvmType) {
            return "_" + Strings.toFirstLower((String)((JvmType)ex).getSimpleName());
        }
        if (ex instanceof JvmIdentifiableElement) {
            return ((JvmIdentifiableElement)ex).getSimpleName();
        }
        if (ex instanceof XAbstractFeatureCall) {
            String name = this.nameProvider.getSimpleName(((XAbstractFeatureCall)ex).getFeature());
            if (name == null) {
                throw new IllegalStateException("name may not be null");
            }
            int indexOf = name.indexOf(40);
            if (indexOf != -1) {
                name = name.substring(0, indexOf);
            }
            if ((indexOf = name.lastIndexOf(46)) != -1) {
                name = name.substring(indexOf + 1);
            }
            if (name.startsWith("operator_")) {
                name = Strings.toFirstLower((String)name.substring("operator_".length()));
            } else if (name.startsWith("get") && name.length() > 3) {
                name = Strings.toFirstLower((String)name.substring(3));
            } else if (name.startsWith("to") && name.length() > 2) {
                name = Strings.toFirstLower((String)name.substring(2));
            }
            return "_" + name;
        }
        if (ex instanceof XConstructorCall) {
            String name = ((XConstructorCall)ex).getConstructor().getSimpleName();
            return "_" + Strings.toFirstLower((String)name);
        }
        return "_" + Strings.toFirstLower((String)ex.eClass().getName().toLowerCase());
    }

    protected String makeJavaIdentifier(String name) {
        return this.javaUtils.isJavaKeyword(name) ? String.valueOf(name) + "_" : name;
    }

    protected boolean isJavaConformant(LightweightTypeReference left, LightweightTypeReference right) {
        boolean result = (this.services.getTypeConformanceComputer().isConformant(left, right, 60) & 0x200) != 0;
        return result;
    }

    protected void declareSyntheticVariable(final XExpression expr, ITreeAppendable b) {
        this.declareFreshLocalVariable(expr, b, new Later(){

            @Override
            public void exec(ITreeAppendable appendable) {
                appendable.append(AbstractXbaseCompiler.this.getDefaultValueLiteral(expr));
            }
        });
    }

    protected String getDefaultValueLiteral(XExpression expr) {
        LightweightTypeReference type = this.getTypeForVariableDeclaration(expr);
        if (type.isPrimitive()) {
            if (type.getPrimitiveKind() == Primitives.Primitive.Boolean) {
                return "false";
            }
            return "(" + type.getSimpleName() + ") 0";
        }
        return "null";
    }

    protected void declareFreshLocalVariable(XExpression expr, ITreeAppendable b, Later expression) {
        LightweightTypeReference type = this.getTypeForVariableDeclaration(expr);
        String proposedName = this.makeJavaIdentifier(this.getFavoriteVariableName(expr));
        String varName = b.declareSyntheticVariable(expr, proposedName);
        b.newLine();
        b.append(type);
        b.append(" ").append(varName).append(" = ");
        expression.exec(b);
        b.append(";");
    }

    protected LightweightTypeReference getTypeForVariableDeclaration(XExpression expr) {
        IResolvedTypes resolvedTypes = this.getResolvedTypes(expr);
        LightweightTypeReference actualType = resolvedTypes.getActualType(expr);
        if (actualType.isPrimitiveVoid()) {
            LightweightTypeReference expectedType = resolvedTypes.getExpectedType(expr);
            if (expectedType == null && (expectedType = resolvedTypes.getExpectedReturnType(expr)) == null) {
                expectedType = resolvedTypes.getReturnType(expr);
            }
            if (expectedType != null && !expectedType.isPrimitiveVoid()) {
                actualType = expectedType;
            }
        }
        return actualType;
    }

    protected boolean isVariableDeclarationRequired(XExpression expr, ITreeAppendable b) {
        return true;
    }

    protected String getReferenceName(XExpression expr, ITreeAppendable b) {
        XFeatureCall featureCall;
        if (b.hasName(expr)) {
            return b.getName(expr);
        }
        if (expr instanceof XFeatureCall && b.hasName((featureCall = (XFeatureCall)expr).getFeature())) {
            return b.getName(featureCall.getFeature());
        }
        return null;
    }
}

