/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.osgi.container;

import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicReference;
import org.eclipse.osgi.container.ModuleCapability;
import org.eclipse.osgi.container.ModuleDatabase;
import org.eclipse.osgi.container.ModuleLoader;
import org.eclipse.osgi.container.ModuleRequirement;
import org.eclipse.osgi.container.ModuleRevision;
import org.eclipse.osgi.container.ModuleRevisionBuilder;
import org.eclipse.osgi.container.ModuleWire;
import org.eclipse.osgi.internal.container.AtomicLazyInitializer;
import org.eclipse.osgi.internal.container.InternalUtils;
import org.osgi.framework.AdminPermission;
import org.osgi.framework.Bundle;
import org.osgi.framework.wiring.BundleCapability;
import org.osgi.framework.wiring.BundleRequirement;
import org.osgi.framework.wiring.BundleWire;
import org.osgi.framework.wiring.BundleWiring;
import org.osgi.resource.Capability;
import org.osgi.resource.Requirement;
import org.osgi.resource.Wire;

public final class ModuleWiring
implements BundleWiring {
    private static final RuntimePermission GET_CLASSLOADER_PERM = new RuntimePermission("getClassLoader");
    private static final String DYNAMICALLY_ADDED_IMPORT_DIRECTIVE = "x.dynamically.added";
    private final ModuleRevision revision;
    private volatile List<ModuleCapability> capabilities;
    private volatile List<ModuleRequirement> requirements;
    private final Collection<String> substitutedPkgNames;
    private final AtomicLazyInitializer<ModuleLoader> loader = new AtomicLazyInitializer();
    private final LoaderInitializer loaderInitializer = new LoaderInitializer();
    private volatile List<ModuleWire> providedWires;
    private volatile List<ModuleWire> requiredWires;
    volatile boolean isValid = true;
    private final AtomicReference<Set<String>> dynamicMissRef = new AtomicReference();

    ModuleWiring(ModuleRevision revision, List<ModuleCapability> capabilities, List<ModuleRequirement> requirements, List<ModuleWire> providedWires, List<ModuleWire> requiredWires, Collection<String> substitutedPkgNames) {
        this.revision = revision;
        this.capabilities = capabilities;
        this.requirements = requirements;
        this.providedWires = providedWires;
        this.requiredWires = requiredWires;
        this.substitutedPkgNames = substitutedPkgNames;
    }

    @Override
    public Bundle getBundle() {
        return this.revision.getBundle();
    }

    @Override
    public boolean isCurrent() {
        return this.isValid && this.revision.isCurrent();
    }

    @Override
    public boolean isInUse() {
        return this.isCurrent() || !this.providedWires.isEmpty() || this.isFragmentInUse();
    }

    private boolean isFragmentInUse() {
        if ((1 & this.revision.getTypes()) != 0) {
            List<ModuleWire> hostWires = this.getRequiredModuleWires("osgi.wiring.host");
            return hostWires == null ? false : !hostWires.isEmpty();
        }
        return false;
    }

    public List<ModuleCapability> getModuleCapabilities(String namespace) {
        return this.getModuleCapabilities(namespace, this.capabilities);
    }

    private List<ModuleCapability> getModuleCapabilities(String namespace, List<ModuleCapability> allCapabilities) {
        if (!this.isValid) {
            return null;
        }
        if (namespace == null) {
            return new ArrayList<ModuleCapability>(allCapabilities);
        }
        ArrayList<ModuleCapability> result = new ArrayList<ModuleCapability>();
        for (ModuleCapability capability : allCapabilities) {
            if (!namespace.equals(capability.getNamespace())) continue;
            result.add(capability);
        }
        return result;
    }

    public List<ModuleRequirement> getModuleRequirements(String namespace) {
        return this.getModuleRequirements(namespace, this.requirements);
    }

    List<ModuleRequirement> getPersistentRequirements() {
        List<ModuleRequirement> persistentRequriements = this.getModuleRequirements(null);
        if (persistentRequriements == null) {
            return null;
        }
        Iterator<ModuleRequirement> iRequirements = persistentRequriements.iterator();
        while (iRequirements.hasNext()) {
            ModuleRequirement requirement = iRequirements.next();
            if (!"osgi.wiring.package".equals(requirement.getNamespace()) || !"true".equals(requirement.getDirectives().get(DYNAMICALLY_ADDED_IMPORT_DIRECTIVE))) continue;
            iRequirements.remove();
        }
        return persistentRequriements;
    }

    private List<ModuleRequirement> getModuleRequirements(String namespace, List<ModuleRequirement> allRequirements) {
        if (!this.isValid) {
            return null;
        }
        if (namespace == null) {
            return new ArrayList<ModuleRequirement>(allRequirements);
        }
        ArrayList<ModuleRequirement> result = new ArrayList<ModuleRequirement>();
        for (ModuleRequirement requirement : allRequirements) {
            if (!namespace.equals(requirement.getNamespace())) continue;
            result.add(requirement);
        }
        return result;
    }

    @Override
    public List<BundleCapability> getCapabilities(String namespace) {
        return InternalUtils.asListBundleCapability(this.getModuleCapabilities(namespace));
    }

    @Override
    public List<BundleRequirement> getRequirements(String namespace) {
        return InternalUtils.asListBundleRequirement(this.getModuleRequirements(namespace));
    }

    public List<ModuleWire> getProvidedModuleWires(String namespace) {
        return this.getWires(namespace, this.providedWires);
    }

    List<ModuleWire> getPersistentProvidedWires() {
        return this.getPersistentWires(this.providedWires);
    }

    public List<ModuleWire> getRequiredModuleWires(String namespace) {
        return this.getWires(namespace, this.requiredWires);
    }

    List<ModuleWire> getPersistentRequiredWires() {
        return this.getPersistentWires(this.requiredWires);
    }

    private List<ModuleWire> getPersistentWires(List<ModuleWire> allWires) {
        List<ModuleWire> persistentWires = this.getWires(null, allWires);
        if (persistentWires == null) {
            return null;
        }
        Iterator<ModuleWire> iWires = persistentWires.iterator();
        while (iWires.hasNext()) {
            ModuleWire wire = iWires.next();
            if (!"osgi.wiring.package".equals(wire.getRequirement().getNamespace()) || !"true".equals(wire.getRequirement().getDirectives().get(DYNAMICALLY_ADDED_IMPORT_DIRECTIVE))) continue;
            iWires.remove();
        }
        return persistentWires;
    }

    @Override
    public List<BundleWire> getProvidedWires(String namespace) {
        return InternalUtils.asListBundleWire(this.getWires(namespace, this.providedWires));
    }

    @Override
    public List<BundleWire> getRequiredWires(String namespace) {
        return InternalUtils.asListBundleWire(this.getWires(namespace, this.requiredWires));
    }

    private List<ModuleWire> getWires(String namespace, List<ModuleWire> allWires) {
        if (!this.isValid) {
            return null;
        }
        if (namespace == null) {
            return new ArrayList<ModuleWire>(allWires);
        }
        ArrayList<ModuleWire> result = new ArrayList<ModuleWire>();
        for (ModuleWire moduleWire : allWires) {
            if (!namespace.equals(moduleWire.getCapability().getNamespace())) continue;
            result.add(moduleWire);
        }
        return result;
    }

    @Override
    public ModuleRevision getRevision() {
        return this.revision;
    }

    @Override
    public ClassLoader getClassLoader() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(GET_CLASSLOADER_PERM);
        }
        if (!this.isValid) {
            return null;
        }
        ModuleLoader current = this.getModuleLoader();
        if (current == null) {
            return null;
        }
        return current.getClassLoader();
    }

    public ModuleLoader getModuleLoader() {
        return this.loader.getInitialized(this.loaderInitializer);
    }

    void loadFragments(Collection<ModuleRevision> fragments) {
        ModuleLoader current = this.loader.get();
        if (current != null) {
            current.loadFragments(fragments);
        }
    }

    @Override
    public List<URL> findEntries(String path, String filePattern, int options) {
        if (!this.hasResourcePermission()) {
            return Collections.emptyList();
        }
        if (!this.isValid) {
            return null;
        }
        ModuleLoader current = this.getModuleLoader();
        if (current == null) {
            return null;
        }
        return current.findEntries(path, filePattern, options);
    }

    @Override
    public Collection<String> listResources(String path, String filePattern, int options) {
        if (!this.hasResourcePermission()) {
            return Collections.emptyList();
        }
        if (!this.isValid) {
            return null;
        }
        ModuleLoader current = this.getModuleLoader();
        if (current == null) {
            return null;
        }
        return current.listResources(path, filePattern, options);
    }

    @Override
    public List<Capability> getResourceCapabilities(String namespace) {
        return InternalUtils.asListCapability(this.getCapabilities(namespace));
    }

    @Override
    public List<Requirement> getResourceRequirements(String namespace) {
        return InternalUtils.asListRequirement(this.getRequirements(namespace));
    }

    @Override
    public List<Wire> getProvidedResourceWires(String namespace) {
        return InternalUtils.asListWire(this.getWires(namespace, this.providedWires));
    }

    @Override
    public List<Wire> getRequiredResourceWires(String namespace) {
        return InternalUtils.asListWire(this.getWires(namespace, this.requiredWires));
    }

    @Override
    public ModuleRevision getResource() {
        return this.revision;
    }

    void setProvidedWires(List<ModuleWire> providedWires) {
        this.providedWires = providedWires;
    }

    void setRequiredWires(List<ModuleWire> requiredWires) {
        this.requiredWires = requiredWires;
    }

    void setCapabilities(List<ModuleCapability> capabilities) {
        this.capabilities = capabilities;
    }

    void unload() {
        this.invalidate0(true);
    }

    void invalidate() {
        this.invalidate0(false);
    }

    private void invalidate0(boolean releaseLoader) {
        this.isValid = false;
        ModuleLoader current = releaseLoader ? this.loader.getAndClear() : this.loader.get();
        this.revision.getRevisions().getContainer().getAdaptor().invalidateWiring(this, current);
    }

    void validate() {
        this.isValid = true;
    }

    boolean isSubtituted(ModuleCapability capability) {
        if (!"osgi.wiring.package".equals(capability.getNamespace())) {
            return false;
        }
        return this.substitutedPkgNames.contains(capability.getAttributes().get("osgi.wiring.package"));
    }

    public boolean isSubstitutedPackage(String packageName) {
        return this.substitutedPkgNames.contains(packageName);
    }

    public Collection<String> getSubstitutedNames() {
        return Collections.unmodifiableCollection(this.substitutedPkgNames);
    }

    private boolean hasResourcePermission() {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPermission(new AdminPermission(this.getBundle(), "resource"));
            }
            catch (SecurityException securityException) {
                return false;
            }
        }
        return true;
    }

    public void addDynamicImports(ModuleRevisionBuilder builder) {
        List<ModuleRevisionBuilder.GenericInfo> newImports = builder.getRequirements();
        ArrayList<ModuleRequirement> newRequirements = new ArrayList<ModuleRequirement>();
        for (ModuleRevisionBuilder.GenericInfo info : newImports) {
            if (!"osgi.wiring.package".equals(info.getNamespace())) {
                throw new IllegalArgumentException("Invalid namespace for package imports: " + info.getNamespace());
            }
            HashMap<String, Object> attributes = new HashMap<String, Object>(info.getAttributes());
            HashMap<String, String> directives = new HashMap<String, String>(info.getDirectives());
            directives.put(DYNAMICALLY_ADDED_IMPORT_DIRECTIVE, "true");
            directives.put("resolution", "dynamic");
            newRequirements.add(new ModuleRequirement(info.getNamespace(), directives, attributes, this.revision));
        }
        ModuleDatabase moduleDatabase = this.revision.getRevisions().getContainer().moduleDatabase;
        moduleDatabase.writeLock();
        try {
            ArrayList<ModuleRequirement> updatedRequirements = new ArrayList<ModuleRequirement>(this.requirements);
            updatedRequirements.addAll(newRequirements);
            this.requirements = updatedRequirements;
        }
        finally {
            moduleDatabase.writeUnlock();
        }
    }

    void addDynamicPackageMiss(String packageName) {
        Set<String> misses = this.dynamicMissRef.get();
        if (misses == null) {
            this.dynamicMissRef.compareAndSet(null, Collections.synchronizedSet(new HashSet()));
            misses = this.dynamicMissRef.get();
        }
        misses.add(packageName);
    }

    boolean isDynamicPackageMiss(String packageName) {
        Set<String> misses = this.dynamicMissRef.get();
        return misses != null && misses.contains(packageName);
    }

    void removeDynamicPackageMisses(Collection<String> packageNames) {
        Set<String> misses = this.dynamicMissRef.get();
        if (misses != null) {
            misses.removeAll(packageNames);
        }
    }

    class LoaderInitializer
    implements Callable<ModuleLoader> {
        LoaderInitializer() {
        }

        @Override
        public ModuleLoader call() throws Exception {
            if (!ModuleWiring.this.isValid) {
                return null;
            }
            return ModuleWiring.this.getRevision().getRevisions().getContainer().adaptor.createModuleLoader(ModuleWiring.this);
        }
    }
}

