/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jetty.security;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.jetty.security.MappedLoginService;
import org.eclipse.jetty.security.PropertyUserStore;
import org.eclipse.jetty.server.UserIdentity;
import org.eclipse.jetty.util.log.Log;
import org.eclipse.jetty.util.log.Logger;
import org.eclipse.jetty.util.resource.Resource;
import org.eclipse.jetty.util.security.Credential;

public class HashLoginService
extends MappedLoginService
implements PropertyUserStore.UserListener {
    private static final Logger LOG = Log.getLogger(HashLoginService.class);
    private PropertyUserStore _propertyUserStore;
    private String _config;
    private Resource _configResource;
    private boolean hotReload = false;

    public HashLoginService() {
    }

    public HashLoginService(String name) {
        this.setName(name);
    }

    public HashLoginService(String name, String config) {
        this.setName(name);
        this.setConfig(config);
    }

    public String getConfig() {
        return this._config;
    }

    public void getConfig(String config) {
        this._config = config;
    }

    public Resource getConfigResource() {
        return this._configResource;
    }

    public void setConfig(String config) {
        this._config = config;
    }

    public boolean isHotReload() {
        return this.hotReload;
    }

    public void setHotReload(boolean enable) {
        if (this.isRunning()) {
            throw new IllegalStateException("Cannot set hot reload while user store is running");
        }
        this.hotReload = enable;
    }

    @Deprecated
    public void setRefreshInterval(int sec) {
    }

    @Deprecated
    public int getRefreshInterval() {
        return this.hotReload ? 1 : 0;
    }

    @Override
    protected UserIdentity loadUser(String username) {
        return null;
    }

    @Override
    public void loadUsers() throws IOException {
    }

    @Override
    protected String[] loadRoleInfo(MappedLoginService.KnownUser user) {
        UserIdentity id = this._propertyUserStore.getUserIdentity(user.getName());
        if (id == null) {
            return null;
        }
        Set<MappedLoginService.RolePrincipal> roles = id.getSubject().getPrincipals(MappedLoginService.RolePrincipal.class);
        if (roles == null) {
            return null;
        }
        ArrayList<String> list = new ArrayList<String>();
        for (MappedLoginService.RolePrincipal r : roles) {
            list.add(r.getName());
        }
        return list.toArray(new String[roles.size()]);
    }

    @Override
    protected MappedLoginService.KnownUser loadUserInfo(String userName) {
        UserIdentity id = this._propertyUserStore.getUserIdentity(userName);
        if (id != null) {
            return (MappedLoginService.KnownUser)id.getUserPrincipal();
        }
        return null;
    }

    @Override
    protected void doStart() throws Exception {
        super.doStart();
        if (this._propertyUserStore == null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("doStart: Starting new PropertyUserStore. PropertiesFile: " + this._config + " hotReload: " + this.hotReload, new Object[0]);
            }
            this._propertyUserStore = new PropertyUserStore();
            this._propertyUserStore.setHotReload(this.hotReload);
            this._propertyUserStore.setConfigPath(this._config);
            this._propertyUserStore.registerUserListener(this);
            this._propertyUserStore.start();
        }
    }

    @Override
    protected void doStop() throws Exception {
        super.doStop();
        if (this._propertyUserStore != null) {
            this._propertyUserStore.stop();
        }
        this._propertyUserStore = null;
    }

    @Override
    public void update(String userName, Credential credential, String[] roleArray) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("update: " + userName + " Roles: " + roleArray.length, new Object[0]);
        }
    }

    @Override
    public void remove(String userName) {
        if (LOG.isDebugEnabled()) {
            LOG.debug("remove: " + userName, new Object[0]);
        }
        this.removeUser(userName);
    }

    public class HashKnownUser
    extends MappedLoginService.KnownUser {
        String[] _roles;

        public HashKnownUser(String name, Credential credential) {
            super(name, credential);
        }

        public void setRoles(String[] roles) {
            this._roles = roles;
        }

        public String[] getRoles() {
            return this._roles;
        }
    }
}

