/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.core.di.context.internal;

import java.util.Collections;
import org.eclipse.e4.core.contexts.ContextFunction;
import org.eclipse.e4.core.contexts.ContextInjectionFactory;
import org.eclipse.e4.core.contexts.IContextFunction;
import org.eclipse.e4.core.contexts.IEclipseContext;
import org.eclipse.e4.core.di.InjectionException;
import org.eclipse.e4.core.services.events.IEventBroker;
import org.eclipse.fx.core.di.Invoke;
import org.eclipse.fx.core.di.ScopedObjectFactory;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import org.osgi.service.component.annotations.Component;

@Component(service={IContextFunction.class}, property={"service.context.key:String=org.eclipse.fx.core.di.ScopedObjectFactory"})
public class ScopedObjectFactoryFunction
extends ContextFunction {
    public Object compute(IEclipseContext context, String contextKey) {
        IEventBroker eventBroker = (IEventBroker)context.get(IEventBroker.class);
        return new ScopedObjectFactoryImpl(context, eventBroker);
    }

    static class ScopedObjectFactoryImpl
    implements ScopedObjectFactory {
        private final IEclipseContext context;
        private final IEventBroker eventBroker;

        ScopedObjectFactoryImpl(IEclipseContext context, IEventBroker eventBroker) {
            this.context = context;
            this.eventBroker = eventBroker;
        }

        public <C> C newInstance(Class<C> c) {
            return (C)ContextInjectionFactory.make(c, (IEclipseContext)this.context);
        }

        public @NonNull ScopedObjectFactory createChild(@NonNull String name) {
            return new ScopedObjectFactoryImpl(this.context.createChild(name), this.eventBroker);
        }

        public <O> void put(@NonNull Class<@NonNull O> key, @NonNull O value) {
            this.context.set(key, value);
            if (this.eventBroker != null) {
                this.eventBroker.send("org/eclipse/fx/context/key", Collections.singletonMap(key.toString(), value));
            }
        }

        public void put(@NonNull String key, @NonNull Object value) {
            this.context.set(key, value);
            if (this.eventBroker != null) {
                this.eventBroker.send("org/eclipse/fx/context/key", Collections.singletonMap(key, value));
            }
        }

        public <O> @Nullable O invoke(@NonNull Object instance) throws IllegalStateException {
            try {
                return (O)ContextInjectionFactory.invoke((Object)instance, Invoke.class, (IEclipseContext)this.context);
            }
            catch (InjectionException e) {
                throw new IllegalStateException(e);
            }
        }

        public void dispose() {
            this.context.dispose();
        }
    }
}

