/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.core.builder;

import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.compiler.CharOperation;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFileReader;
import org.eclipse.jdt.internal.compiler.classfmt.ClassFormatException;
import org.eclipse.jdt.internal.compiler.env.AccessRuleSet;
import org.eclipse.jdt.internal.compiler.env.IBinaryModule;
import org.eclipse.jdt.internal.compiler.env.IModule;
import org.eclipse.jdt.internal.compiler.env.IMultiModuleEntry;
import org.eclipse.jdt.internal.compiler.env.NameEnvironmentAnswer;
import org.eclipse.jdt.internal.compiler.util.JRTUtil;
import org.eclipse.jdt.internal.compiler.util.SimpleSet;
import org.eclipse.jdt.internal.compiler.util.SuffixConstants;
import org.eclipse.jdt.internal.core.JavaProject;
import org.eclipse.jdt.internal.core.builder.ClasspathJar;
import org.eclipse.jdt.internal.core.builder.ClasspathLocation;
import org.eclipse.jdt.internal.core.util.Util;

public class ClasspathJrt
extends ClasspathLocation
implements IMultiModuleEntry {
    protected static Map<String, Map<String, SimpleSet>> PackageCache = new ConcurrentHashMap<String, Map<String, SimpleSet>>();
    protected static Map<String, Map<String, IModule>> ModulesCache = new ConcurrentHashMap<String, Map<String, IModule>>();
    String zipFilename;
    File jrtFile;
    static final Set<String> NO_LIMIT_MODULES = Collections.emptySet();

    protected ClasspathJrt() {
    }

    public ClasspathJrt(String zipFilename, AccessRuleSet accessRuleSet, IPath externalAnnotationPath) {
        this.setZipFile(zipFilename);
        this.accessRuleSet = accessRuleSet;
        if (externalAnnotationPath != null) {
            this.externalAnnotationPath = externalAnnotationPath.toString();
        }
        ClasspathJrt.loadModules(this);
    }

    void setZipFile(String zipFilename) {
        this.zipFilename = zipFilename;
        if (zipFilename != null) {
            this.jrtFile = new File(zipFilename);
        }
    }

    static Map<String, SimpleSet> findPackagesInModules(ClasspathJrt jrt) {
        if (jrt.zipFilename == null) {
            return Map.of();
        }
        Map cache = PackageCache.computeIfAbsent(jrt.zipFilename, zipFileName -> {
            HashMap<String, SimpleSet> packagesInModule = new HashMap<String, SimpleSet>();
            try {
                JRTUtil.walkModuleImage(classpathJrt.jrtFile, new JrtPackageVisitor(packagesInModule), 6);
            }
            catch (IOException e) {
                Util.log(e, "Failed to init packages for " + zipFileName);
            }
            return packagesInModule.isEmpty() ? null : Collections.unmodifiableMap(packagesInModule);
        });
        return cache;
    }

    public static void loadModules(final ClasspathJrt jrt) {
        String jrtKey = jrt.getKey();
        if (jrtKey == null) {
            return;
        }
        ModulesCache.computeIfAbsent(jrtKey, key -> {
            final HashMap newCache = new HashMap();
            try {
                final File imageFile = classpathJrt.jrtFile;
                JRTUtil.walkModuleImage(imageFile, new JRTUtil.JrtFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitModule(Path path, String name) throws IOException {
                        jrt.acceptModule(JRTUtil.getClassfileContent(imageFile, "module-info.class", name), name, newCache);
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                }, 4);
            }
            catch (IOException e) {
                Util.log(e, "Failed to init packages for " + jrt);
            }
            return newCache.isEmpty() ? null : Collections.unmodifiableMap(newCache);
        });
    }

    protected String getKey() {
        return this.zipFilename;
    }

    void acceptModule(byte[] content, String name, Map<String, IModule> cache) {
        if (content == null) {
            return;
        }
        try {
            ClassFileReader reader = new ClassFileReader(content, "module-info.class".toCharArray());
            IBinaryModule moduleDecl = reader.getModuleDeclaration();
            if (moduleDecl != null) {
                cache.put(name, moduleDecl);
            }
        }
        catch (ClassFormatException e) {
            Util.log(e, "Failed to read module-info.class for " + name + " in " + this.toString());
        }
    }

    @Override
    public void cleanup() {
        if (this.annotationZipFile != null) {
            try {
                this.annotationZipFile.close();
            }
            catch (IOException iOException) {}
            this.annotationZipFile = null;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ClasspathJrt)) {
            return false;
        }
        ClasspathJrt jar = (ClasspathJrt)o;
        if (!(this.accessRuleSet == jar.accessRuleSet || this.accessRuleSet != null && this.accessRuleSet.equals(jar.accessRuleSet))) {
            return false;
        }
        return this.zipFilename.endsWith(jar.zipFilename) && this.areAllModuleOptionsEqual(jar);
    }

    @Override
    public NameEnvironmentAnswer findClass(String binaryFileName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName, boolean asBinaryOnly, Predicate<String> moduleNameFilter) {
        if (!this.isPackage(qualifiedPackageName, moduleName)) {
            return null;
        }
        try {
            String fileNameWithoutExtension = qualifiedBinaryFileName.substring(0, qualifiedBinaryFileName.length() - SuffixConstants.SUFFIX_CLASS.length);
            ClassFileReader reader = ClassFileReader.readFromModule(this.jrtFile, moduleName, qualifiedBinaryFileName, moduleNameFilter);
            if (reader != null) {
                return this.createAnswer(fileNameWithoutExtension, reader, reader.getModule());
            }
        }
        catch (IOException | ClassFormatException exception) {}
        return null;
    }

    @Override
    public IPath getProjectRelativePath() {
        return null;
    }

    public int hashCode() {
        return this.zipFilename == null ? super.hashCode() : this.zipFilename.hashCode();
    }

    @Override
    public char[][] getModulesDeclaringPackage(String qualifiedPackageName, String moduleName) {
        List<String> moduleNames = JRTUtil.getModulesDeclaringPackage(this.jrtFile, qualifiedPackageName, moduleName);
        return CharOperation.toCharArrays(moduleNames);
    }

    @Override
    public boolean hasCompilationUnit(String qualifiedPackageName, String moduleName) {
        return JRTUtil.hasCompilationUnit(this.jrtFile, qualifiedPackageName, moduleName);
    }

    @Override
    public boolean isPackage(String qualifiedPackageName, String moduleName) {
        return JRTUtil.getModulesDeclaringPackage(this.jrtFile, qualifiedPackageName, moduleName) != null;
    }

    public String toString() {
        String start = "Classpath jrt file " + this.zipFilename;
        return start;
    }

    @Override
    public String debugPathString() {
        return this.zipFilename;
    }

    @Override
    public NameEnvironmentAnswer findClass(char[] typeName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName, boolean asBinaryOnly, Predicate<String> moduleNameFilter) {
        String fileName = new String(typeName);
        return this.findClass(fileName, qualifiedPackageName, moduleName, qualifiedBinaryFileName, asBinaryOnly, moduleNameFilter);
    }

    @Override
    public boolean hasModule() {
        return true;
    }

    @Override
    public IModule getModule(char[] moduleName) {
        return this.getModule(String.valueOf(moduleName));
    }

    public IModule getModule(String moduleName) {
        if (!this.hasModule()) {
            return null;
        }
        Map<String, IModule> modules = ModulesCache.get(this.getKey());
        if (modules != null) {
            return modules.get(moduleName);
        }
        return null;
    }

    @Override
    public Collection<String> getModuleNames(Collection<String> limitModules) {
        Map<String, SimpleSet> cache = ClasspathJrt.findPackagesInModules(this);
        if (cache != null) {
            return this.selectModules(cache.keySet(), limitModules);
        }
        return Collections.emptyList();
    }

    protected Collection<String> selectModules(Set<String> keySet, Collection<String> limitModules) {
        Collection<String> rootModules;
        if (limitModules == NO_LIMIT_MODULES) {
            rootModules = new HashSet<String>(keySet);
        } else if (limitModules != null) {
            HashSet<String> result = new HashSet<String>(keySet);
            result.retainAll(limitModules);
            rootModules = result;
        } else {
            rootModules = JavaProject.internalDefaultRootModules(keySet, s -> s, m -> this.getModule((String)m));
        }
        HashSet<String> allModules = new HashSet<String>(rootModules);
        for (String mod : rootModules) {
            this.addRequired(mod, allModules);
        }
        return allModules;
    }

    protected void addRequired(String mod, Set<String> allModules) {
        IModule iMod = this.getModule(mod);
        if (iMod == null) {
            return;
        }
        IModule.IModuleReference[] iModuleReferenceArray = iMod.requires();
        int n = iModuleReferenceArray.length;
        int n2 = 0;
        while (n2 < n) {
            IModule.IModuleReference requiredRef = iModuleReferenceArray[n2];
            String moduleName = String.valueOf(requiredRef.name());
            IModule reqMod = this.getModule(moduleName);
            if (reqMod != null && allModules.add(moduleName)) {
                this.addRequired(moduleName, allModules);
            }
            ++n2;
        }
    }

    @Override
    public NameEnvironmentAnswer findClass(String typeName, String qualifiedPackageName, String moduleName, String qualifiedBinaryFileName) {
        return this.findClass(typeName, qualifiedPackageName, moduleName, qualifiedBinaryFileName, false, null);
    }

    public static void resetCaches() {
        PackageCache.clear();
        ModulesCache.clear();
    }

    static final class JrtPackageVisitor
    implements JRTUtil.JrtFileVisitor<Path> {
        private final Map<String, SimpleSet> packagesInModule;
        SimpleSet packageSet;

        JrtPackageVisitor(Map<String, SimpleSet> packagesInModule) {
            this.packagesInModule = packagesInModule;
        }

        @Override
        public FileVisitResult visitPackage(Path dir, Path mod, BasicFileAttributes attrs) throws IOException {
            ClasspathJar.addToPackageSet(this.packageSet, dir.toString(), true);
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitModule(Path path, String name) throws IOException {
            this.packageSet = new SimpleSet(41);
            this.packageSet.add("");
            if (name.endsWith("/")) {
                name = name.substring(0, name.length() - 1);
            }
            this.packagesInModule.put(name, this.packageSet);
            return FileVisitResult.CONTINUE;
        }
    }
}

