/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxml.compiler;

import com.google.common.base.Objects;
import java.net.URL;
import java.util.HashSet;
import java.util.List;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.fx.ide.fxgraph.fXGraph.ComponentDefinition;
import org.eclipse.fx.ide.fxgraph.fXGraph.ControllerHandledValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.Element;
import org.eclipse.fx.ide.fxgraph.fXGraph.ListValueElement;
import org.eclipse.fx.ide.fxgraph.fXGraph.ListValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.LocationValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.Model;
import org.eclipse.fx.ide.fxgraph.fXGraph.PackageDeclaration;
import org.eclipse.fx.ide.fxgraph.fXGraph.Property;
import org.eclipse.fx.ide.fxgraph.fXGraph.ReferenceType;
import org.eclipse.fx.ide.fxgraph.fXGraph.ReferenceValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.ResourceValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.SimpleValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.StaticCallValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.StaticValueProperty;
import org.eclipse.fx.ide.fxgraph.fXGraph.StringValue;
import org.eclipse.fx.ide.fxgraph.fXGraph.ValueProperty;
import org.eclipse.fx.ide.fxml.compiler.ReflectionHelper;
import org.eclipse.fx.ide.fxml.compiler.ValueType;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.common.types.JvmType;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.StringExtensions;

public class FXGraphJavaGenerator {
    private int varIndex = 0;
    private Set<String> extraImports = new HashSet<String>();
    private Model model;
    private boolean fieldReflection;
    private boolean resourceUrl;

    public FXGraphJavaGenerator(Model model) {
        this.model = model;
        this.registerImport("java.net.URL");
        this.registerImport("org.eclipse.fx.core.fxml.FXMLDocument");
        this.registerImport("org.eclipse.fx.core.fxml.FXMLDocument.LoadData");
        this.registerImport("java.util.Map");
        this.registerImport("java.util.HashMap");
        this.registerImport("java.util.ResourceBundle");
        this.registerImport("javafx.util.Callback");
    }

    public int getVarIndex() {
        ++this.varIndex;
        return this.varIndex;
    }

    public CharSequence generate() {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append((Object)"package ");
        PackageDeclaration _package = this.model.getPackage();
        String _name = _package.getName();
        _builder.append((Object)_name, "");
        _builder.append((Object)";");
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        ComponentDefinition _componentDef = this.model.getComponentDef();
        Element _rootNode = _componentDef.getRootNode();
        ComponentDefinition _componentDef_1 = this.model.getComponentDef();
        boolean _isDynamicRoot = _componentDef_1.isDynamicRoot();
        CharSequence content = this.generateElementDef("root", _rootNode, _isDynamicRoot);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        EList _imports = this.model.getImports();
        for (Object i : _imports) {
            _builder.append((Object)"import ");
            String _importedNamespace = i.getImportedNamespace();
            _builder.append((Object)_importedNamespace, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        for (String i_1 : this.extraImports) {
            _builder.append((Object)"import ");
            _builder.append((Object)i_1, "");
            _builder.append((Object)";");
            _builder.newLineIfNotEmpty();
        }
        _builder.newLine();
        _builder.append((Object)"@SuppressWarnings(\"all\")");
        _builder.newLine();
        _builder.append((Object)"public class ");
        ComponentDefinition _componentDef_2 = this.model.getComponentDef();
        String _name_1 = _componentDef_2.getName();
        _builder.append((Object)_name_1, "");
        _builder.append((Object)" extends FXMLDocument<");
        ComponentDefinition _componentDef_3 = this.model.getComponentDef();
        Element _rootNode_1 = _componentDef_3.getRootNode();
        JvmTypeReference _type = _rootNode_1.getType();
        String _simpleName = _type.getSimpleName();
        _builder.append((Object)_simpleName, "");
        _builder.append((Object)"> {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"private Map<String,Object> namespaceMap = new HashMap<>();");
        _builder.newLine();
        boolean _hasController = this.hasController();
        if (_hasController) {
            _builder.append((Object)"\t");
            ComponentDefinition _componentDef_4 = this.model.getComponentDef();
            JvmTypeReference _controller = _componentDef_4.getController();
            String _qualifiedName = _controller.getQualifiedName();
            _builder.append((Object)_qualifiedName, "\t");
            _builder.append((Object)" _c;");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"public \t");
            ComponentDefinition _componentDef_5 = this.model.getComponentDef();
            JvmTypeReference _controller_1 = _componentDef_5.getController();
            String _qualifiedName_1 = _controller_1.getQualifiedName();
            _builder.append((Object)_qualifiedName_1, "\t");
            _builder.append((Object)" getController() {");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return _c;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        } else {
            _builder.append((Object)"\t");
            _builder.append((Object)"public Object getController() {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return null;");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"public ");
        ComponentDefinition _componentDef_6 = this.model.getComponentDef();
        Element _rootNode_2 = _componentDef_6.getRootNode();
        JvmTypeReference _type_1 = _rootNode_2.getType();
        String _simpleName_1 = _type_1.getSimpleName();
        _builder.append((Object)_simpleName_1, "\t");
        _builder.append((Object)" load(LoadData<");
        ComponentDefinition _componentDef_7 = this.model.getComponentDef();
        Element _rootNode_3 = _componentDef_7.getRootNode();
        JvmTypeReference _type_2 = _rootNode_3.getType();
        String _simpleName_2 = _type_2.getSimpleName();
        _builder.append((Object)_simpleName_2, "\t");
        _builder.append((Object)"> loadData) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"final URL location = loadData.location;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"final ResourceBundle resourceBundle = loadData.bundle;");
        _builder.newLine();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"final Callback<Class<?>, Object> controllerFactory = loadData.controllerFactory;");
        _builder.newLine();
        _builder.newLine();
        boolean _hasController_1 = this.hasController();
        if (_hasController_1) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"if( controllerFactory != null ) {");
            _builder.newLine();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"_c = (");
            ComponentDefinition _componentDef_8 = this.model.getComponentDef();
            JvmTypeReference _controller_2 = _componentDef_8.getController();
            String _qualifiedName_2 = _controller_2.getQualifiedName();
            _builder.append((Object)_qualifiedName_2, "\t\t\t");
            _builder.append((Object)")controllerFactory.call(");
            ComponentDefinition _componentDef_9 = this.model.getComponentDef();
            JvmTypeReference _controller_3 = _componentDef_9.getController();
            String _qualifiedName_3 = _controller_3.getQualifiedName();
            _builder.append((Object)_qualifiedName_3, "\t\t\t");
            _builder.append((Object)".class);");
            _builder.newLineIfNotEmpty();
            _builder.append((Object)"\t\t");
            _builder.append((Object)"} else {");
            _builder.newLine();
            ComponentDefinition _componentDef_10 = this.model.getComponentDef();
            JvmTypeReference _controller_4 = _componentDef_10.getController();
            boolean _hasNoArgConstructor = ReflectionHelper.hasNoArgConstructor(_controller_4);
            if (_hasNoArgConstructor) {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"_c = new ");
                ComponentDefinition _componentDef_11 = this.model.getComponentDef();
                JvmTypeReference _controller_5 = _componentDef_11.getController();
                String _qualifiedName_4 = _controller_5.getQualifiedName();
                _builder.append((Object)_qualifiedName_4, "\t\t\t");
                _builder.append((Object)"();");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append((Object)"\t\t");
                _builder.append((Object)"\t");
                _builder.append((Object)"// ");
                ComponentDefinition _componentDef_12 = this.model.getComponentDef();
                JvmTypeReference _controller_6 = _componentDef_12.getController();
                String _qualifiedName_5 = _controller_6.getQualifiedName();
                _builder.append((Object)_qualifiedName_5, "\t\t\t");
                _builder.append((Object)" cannot be instantiated by reflection");
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)"\t\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        if (this.resourceUrl) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"final String baseURL = createBaseURL(location);");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)content, "\t\t");
        _builder.newLineIfNotEmpty();
        boolean _and = false;
        boolean _hasController_2 = this.hasController();
        if (!_hasController_2) {
            _and = false;
        } else {
            boolean _hasMethod;
            ComponentDefinition _componentDef_13 = this.model.getComponentDef();
            JvmTypeReference _controller_7 = _componentDef_13.getController();
            _and = _hasMethod = ReflectionHelper.hasMethod(_controller_7, "initialize", URL.class, ResourceBundle.class);
        }
        if (_and) {
            _builder.append((Object)"\t\t");
            _builder.append((Object)"_c.initialize(location,resourceBundle);");
            _builder.newLine();
        }
        _builder.append((Object)"\t\t");
        _builder.append((Object)"return root;");
        _builder.newLine();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.newLine();
        if (this.resourceUrl) {
            _builder.append((Object)"\t");
            _builder.append((Object)"private static String createBaseURL(URL url) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"String externalForm = url.toExternalForm();");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"return externalForm.substring(0,externalForm.lastIndexOf('/'));");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.newLine();
        if (this.fieldReflection) {
            _builder.append((Object)"\t");
            _builder.append((Object)"private static void setFieldReflective(Class<?> owner, String n, Object c, Object v) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"try {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"Field f = owner.getDeclaredField(n);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"f.setAccessible(true);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"f.set(c, v);");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"} catch(Throwable e) {");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t\t");
            _builder.append((Object)"e.printStackTrace();");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
            _builder.append((Object)"\t");
            _builder.append((Object)"}");
            _builder.newLine();
        }
        _builder.append((Object)"}");
        _builder.newLine();
        return _builder;
    }

    public boolean hasController() {
        ComponentDefinition _componentDef = this.model.getComponentDef();
        JvmTypeReference _controller = _componentDef.getController();
        return !Objects.equal((Object)_controller, null);
    }

    public void enableFieldReflection(String name) {
        this.fieldReflection = true;
        this.registerImport("java.lang.reflect.*");
    }

    public void registerImport(String name) {
        this.extraImports.add(name);
    }

    public void enableResourceUrl() {
        this.resourceUrl = true;
    }

    public CharSequence controllerFieldAccess(String name, Element element) {
        String _name_1;
        PackageDeclaration _package;
        String _name;
        StringConcatenation _builder = new StringConcatenation();
        ComponentDefinition _componentDef = this.model.getComponentDef();
        JvmTypeReference _controller = _componentDef.getController();
        boolean _hasField = ReflectionHelper.hasField(_controller, _name = (_package = this.model.getPackage()).getName(), _name_1 = element.getName());
        if (_hasField) {
            String _name_3;
            PackageDeclaration _package_1;
            String _name_2;
            ComponentDefinition _componentDef_1 = this.model.getComponentDef();
            JvmTypeReference _controller_1 = _componentDef_1.getController();
            boolean _hasAccessibleField = ReflectionHelper.hasAccessibleField(_controller_1, _name_2 = (_package_1 = this.model.getPackage()).getName(), _name_3 = element.getName());
            if (_hasAccessibleField) {
                _builder.append((Object)"_c.");
                String _name_4 = element.getName();
                _builder.append((Object)_name_4, "");
                _builder.append((Object)" = ");
                _builder.append((Object)name, "");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
            } else {
                String _name_5 = element.getName();
                this.enableFieldReflection(_name_5);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"// resort to reflection");
                _builder.newLine();
                _builder.append((Object)"setFieldReflective(");
                ComponentDefinition _componentDef_2 = this.model.getComponentDef();
                JvmTypeReference _controller_2 = _componentDef_2.getController();
                String _name_6 = element.getName();
                String _fieldOwner = ReflectionHelper.getFieldOwner(_controller_2, _name_6);
                _builder.append((Object)_fieldOwner, "");
                _builder.append((Object)".class, \"");
                String _name_7 = element.getName();
                _builder.append((Object)_name_7, "");
                _builder.append((Object)"\", _c, ");
                _builder.append((Object)name, "");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    public CharSequence eventBindingAccess(String name, String propertyName, String methodName, Element element) {
        boolean _not;
        StringConcatenation _builder = new StringConcatenation();
        this.registerImport("javafx.event.EventHandler");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)name, "");
        _builder.append((Object)".set");
        String _firstUpper = StringExtensions.toFirstUpper((String)propertyName);
        _builder.append((Object)_firstUpper, "");
        _builder.append((Object)"(new EventHandler<");
        JvmTypeReference _type = element.getType();
        String _eventType = ReflectionHelper.eventType(_type, propertyName);
        _builder.append((Object)_eventType, "");
        _builder.append((Object)">() {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"public void handle(");
        JvmTypeReference _type_1 = element.getType();
        String _eventType_1 = ReflectionHelper.eventType(_type_1, propertyName);
        _builder.append((Object)_eventType_1, "\t");
        _builder.append((Object)" event) {");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t\t");
        _builder.append((Object)"_c.");
        _builder.append((Object)methodName, "\t\t");
        _builder.append((Object)"(");
        ComponentDefinition _componentDef = this.model.getComponentDef();
        JvmTypeReference _controller = _componentDef.getController();
        boolean _hasMethod = ReflectionHelper.hasMethod(_controller, methodName, new Class[0]);
        boolean bl = _not = !_hasMethod;
        if (_not) {
            _builder.append((Object)"event");
        }
        _builder.append((Object)");");
        _builder.newLineIfNotEmpty();
        _builder.append((Object)"\t");
        _builder.append((Object)"}");
        _builder.newLine();
        _builder.append((Object)"});");
        _builder.newLine();
        return _builder;
    }

    public CharSequence generateElementDef(String name, Element element) {
        return this.generateElementDef(name, element, false);
    }

    public CharSequence generateElementDef(String name, Element element, boolean dynRoot) {
        String _name_36;
        boolean _notEquals_14;
        StringConcatenation _builder = new StringConcatenation();
        boolean _and = false;
        if (dynRoot) {
            _and = false;
        } else {
            boolean _needsBuilder;
            JvmTypeReference _type = element.getType();
            _and = _needsBuilder = ReflectionHelper.needsBuilder(_type);
        }
        if (_and) {
            boolean _hasController;
            JvmTypeReference _type_1 = element.getType();
            String _qualifiedName = _type_1.getQualifiedName();
            boolean _equals = Objects.equal((Object)"javafx.scene.image.Image", (Object)_qualifiedName);
            if (_equals) {
                _builder.append((Object)"Image ");
                _builder.append((Object)name, "");
                _builder.append((Object)";");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"ImageBuilder ");
                _builder.append((Object)name, "");
                _builder.append((Object)"Builder = ImageBuilder.create();");
                _builder.newLineIfNotEmpty();
                this.registerImport("org.eclipse.fx.core.fxml.ImageBuilder");
                _builder.newLineIfNotEmpty();
            } else {
                JvmTypeReference _type_2 = element.getType();
                String _qualifiedName_1 = _type_2.getQualifiedName();
                boolean _equals_1 = Objects.equal((Object)"java.net.URL", (Object)_qualifiedName_1);
                if (_equals_1) {
                    _builder.append((Object)"URL ");
                    _builder.append((Object)name, "");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"URLBuilder ");
                    _builder.append((Object)name, "");
                    _builder.append((Object)"Builder = URLBuilder.create();");
                    _builder.newLineIfNotEmpty();
                    this.registerImport("org.eclipse.fx.core.fxml.URLBuilder");
                    _builder.newLineIfNotEmpty();
                } else {
                    JvmTypeReference _type_3 = element.getType();
                    String _simpleName = _type_3.getSimpleName();
                    _builder.append((Object)_simpleName, "");
                    _builder.append((Object)" ");
                    _builder.append((Object)name, "");
                    _builder.append((Object)";");
                    _builder.newLineIfNotEmpty();
                    JvmTypeReference _type_4 = element.getType();
                    String _simpleName_1 = _type_4.getSimpleName();
                    _builder.append((Object)_simpleName_1, "");
                    _builder.append((Object)"Builder ");
                    _builder.append((Object)name, "");
                    _builder.append((Object)"Builder = ");
                    JvmTypeReference _type_5 = element.getType();
                    String _simpleName_2 = _type_5.getSimpleName();
                    _builder.append((Object)_simpleName_2, "");
                    _builder.append((Object)"Builder.create();");
                    _builder.newLineIfNotEmpty();
                    JvmTypeReference _type_6 = element.getType();
                    String _qualifiedName_2 = _type_6.getQualifiedName();
                    String _plus = String.valueOf(_qualifiedName_2) + "Builder";
                    this.registerImport(_plus);
                    _builder.newLineIfNotEmpty();
                }
            }
            EList _properties = element.getProperties();
            for (Property p : _properties) {
                ValueProperty _value = p.getValue();
                if (_value instanceof SimpleValueProperty) {
                    boolean _notEquals;
                    ValueProperty _value_1 = p.getValue();
                    String _stringValue = ((SimpleValueProperty)_value_1).getStringValue();
                    boolean bl = _notEquals = !Objects.equal((Object)_stringValue, null);
                    if (_notEquals) {
                        boolean _notEquals_1;
                        JvmTypeReference _type_7 = element.getType();
                        String _name = p.getName();
                        String enumType = ReflectionHelper.getEnumType(_type_7, _name, false);
                        _builder.newLineIfNotEmpty();
                        boolean bl2 = _notEquals_1 = !Objects.equal((Object)enumType, null);
                        if (_notEquals_1) {
                            _builder.append((Object)name, "");
                            _builder.append((Object)"Builder.");
                            String _name_1 = p.getName();
                            _builder.append((Object)_name_1, "");
                            _builder.append((Object)"(");
                            _builder.append((Object)enumType, "");
                            _builder.append((Object)".");
                            ValueProperty _value_2 = p.getValue();
                            String _stringValue_1 = ((SimpleValueProperty)_value_2).getStringValue();
                            _builder.append((Object)_stringValue_1, "");
                            _builder.append((Object)");");
                            _builder.newLineIfNotEmpty();
                            continue;
                        }
                        JvmTypeReference _type_8 = element.getType();
                        JvmType _type_9 = _type_8.getType();
                        String _name_2 = p.getName();
                        ValueType type = ReflectionHelper.getValueType(_type_9, _name_2);
                        _builder.newLineIfNotEmpty();
                        boolean _equals_2 = Objects.equal((Object)((Object)type), (Object)((Object)ValueType.CLASS));
                        if (_equals_2) {
                            _builder.append((Object)name, "");
                            _builder.append((Object)"Builder.");
                            String _name_3 = p.getName();
                            _builder.append((Object)_name_3, "");
                            _builder.append((Object)"(");
                            JvmTypeReference _type_10 = element.getType();
                            JvmType _type_11 = _type_10.getType();
                            String _name_4 = p.getName();
                            String _type_12 = ReflectionHelper.getType(_type_11, _name_4);
                            _builder.append((Object)_type_12, "");
                            _builder.append((Object)".valueOf(\"");
                            ValueProperty _value_3 = p.getValue();
                            String _stringValue_2 = ((SimpleValueProperty)_value_3).getStringValue();
                            _builder.append((Object)_stringValue_2, "");
                            _builder.append((Object)"\"));");
                            _builder.newLineIfNotEmpty();
                            continue;
                        }
                        _builder.append((Object)name, "");
                        _builder.append((Object)"Builder.");
                        String _name_5 = p.getName();
                        _builder.append((Object)_name_5, "");
                        _builder.append((Object)"(");
                        ValueProperty _value_4 = p.getValue();
                        String _simpleAttributeValue = this.simpleAttributeValue((SimpleValueProperty)_value_4);
                        _builder.append((Object)_simpleAttributeValue, "");
                        _builder.append((Object)");");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    _builder.append((Object)name, "");
                    _builder.append((Object)"Builder.");
                    String _name_6 = p.getName();
                    _builder.append((Object)_name_6, "");
                    _builder.append((Object)"(");
                    ValueProperty _value_5 = p.getValue();
                    String _simpleAttributeValue_1 = this.simpleAttributeValue((SimpleValueProperty)_value_5);
                    _builder.append((Object)_simpleAttributeValue_1, "");
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                ValueProperty _value_6 = p.getValue();
                if (!(_value_6 instanceof LocationValueProperty)) continue;
                _builder.append((Object)name, "");
                _builder.append((Object)"Builder.");
                String _name_7 = p.getName();
                _builder.append((Object)_name_7, "");
                _builder.append((Object)"(baseURL + \"/");
                ValueProperty _value_7 = p.getValue();
                String _value_8 = ((LocationValueProperty)_value_7).getValue();
                _builder.append((Object)_value_8, "");
                _builder.append((Object)"\");");
                _builder.newLineIfNotEmpty();
                this.enableResourceUrl();
                _builder.newLineIfNotEmpty();
            }
            _builder.append((Object)name, "");
            _builder.append((Object)" = ");
            _builder.append((Object)name, "");
            _builder.append((Object)"Builder.build();");
            _builder.newLineIfNotEmpty();
            boolean _and_1 = false;
            String _name_8 = element.getName();
            boolean _notEquals_2 = !Objects.equal((Object)_name_8, null);
            _and_1 = !_notEquals_2 ? false : (_hasController = this.hasController());
            if (_and_1) {
                CharSequence _controllerFieldAccess = this.controllerFieldAccess(name, element);
                _builder.append((Object)_controllerFieldAccess, "");
                _builder.newLineIfNotEmpty();
            }
        } else {
            boolean _hasController_2;
            if (dynRoot) {
                JvmTypeReference _type_13 = element.getType();
                String _simpleName_3 = _type_13.getSimpleName();
                _builder.append((Object)_simpleName_3, "");
                _builder.append((Object)" ");
                _builder.append((Object)name, "");
                _builder.append((Object)" = loadData.rootNode;");
                _builder.newLineIfNotEmpty();
            } else {
                JvmTypeReference _type_14 = element.getType();
                String _qualifiedName_3 = _type_14.getQualifiedName();
                boolean _equals_3 = Objects.equal((Object)_qualifiedName_3, (Object)"java.lang.String");
                if (_equals_3) {
                    JvmTypeReference _type_15 = element.getType();
                    String _simpleName_4 = _type_15.getSimpleName();
                    _builder.append((Object)_simpleName_4, "");
                    _builder.append((Object)" ");
                    _builder.append((Object)name, "");
                    _builder.append((Object)" = ");
                    JvmTypeReference _type_16 = element.getType();
                    String _simpleName_5 = _type_16.getSimpleName();
                    _builder.append((Object)_simpleName_5, "");
                    _builder.append((Object)".valueOf(\"");
                    _builder.append((Object)element, "");
                    _builder.append((Object)"\");");
                    _builder.newLineIfNotEmpty();
                } else {
                    JvmTypeReference _type_17 = element.getType();
                    String _simpleName_6 = _type_17.getSimpleName();
                    _builder.append((Object)_simpleName_6, "");
                    _builder.append((Object)" ");
                    _builder.append((Object)name, "");
                    _builder.append((Object)" = new ");
                    JvmTypeReference _type_18 = element.getType();
                    String _simpleName_7 = _type_18.getSimpleName();
                    _builder.append((Object)_simpleName_7, "");
                    _builder.append((Object)"();");
                    _builder.newLineIfNotEmpty();
                }
            }
            EList _properties_1 = element.getProperties();
            for (Property p_1 : _properties_1) {
                boolean _hasController_1;
                ValueProperty _value_9 = p_1.getValue();
                if (_value_9 instanceof SimpleValueProperty) {
                    boolean _notEquals_3;
                    ValueProperty _value_10 = p_1.getValue();
                    String _stringValue_3 = ((SimpleValueProperty)_value_10).getStringValue();
                    boolean bl = _notEquals_3 = !Objects.equal((Object)_stringValue_3, null);
                    if (_notEquals_3) {
                        boolean _notEquals_4;
                        JvmTypeReference _type_19 = element.getType();
                        String _name_9 = p_1.getName();
                        String enumType_1 = ReflectionHelper.getEnumType(_type_19, _name_9, false);
                        _builder.newLineIfNotEmpty();
                        boolean bl3 = _notEquals_4 = !Objects.equal((Object)enumType_1, null);
                        if (_notEquals_4) {
                            _builder.append((Object)name, "");
                            _builder.append((Object)".set");
                            String _name_10 = p_1.getName();
                            String _firstUpper = StringExtensions.toFirstUpper((String)_name_10);
                            _builder.append((Object)_firstUpper, "");
                            _builder.append((Object)"(");
                            _builder.append((Object)enumType_1, "");
                            _builder.append((Object)".");
                            ValueProperty _value_11 = p_1.getValue();
                            String _stringValue_4 = ((SimpleValueProperty)_value_11).getStringValue();
                            _builder.append((Object)_stringValue_4, "");
                            _builder.append((Object)");");
                            _builder.newLineIfNotEmpty();
                            continue;
                        }
                        JvmTypeReference _type_20 = element.getType();
                        JvmType _type_21 = _type_20.getType();
                        String _name_11 = p_1.getName();
                        ValueType type_1 = ReflectionHelper.getValueType(_type_21, _name_11);
                        _builder.newLineIfNotEmpty();
                        boolean _equals_4 = Objects.equal((Object)((Object)type_1), (Object)((Object)ValueType.CLASS));
                        if (_equals_4) {
                            _builder.append((Object)name, "");
                            _builder.append((Object)".set");
                            String _name_12 = p_1.getName();
                            String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_12);
                            _builder.append((Object)_firstUpper_1, "");
                            _builder.append((Object)"(");
                            JvmTypeReference _type_22 = element.getType();
                            JvmType _type_23 = _type_22.getType();
                            String _name_13 = p_1.getName();
                            String _type_24 = ReflectionHelper.getType(_type_23, _name_13);
                            _builder.append((Object)_type_24, "");
                            _builder.append((Object)".valueOf(\"");
                            ValueProperty _value_12 = p_1.getValue();
                            String _stringValue_5 = ((SimpleValueProperty)_value_12).getStringValue();
                            _builder.append((Object)_stringValue_5, "");
                            _builder.append((Object)"\"));");
                            _builder.newLineIfNotEmpty();
                            continue;
                        }
                        _builder.append((Object)name, "");
                        _builder.append((Object)".set");
                        String _name_14 = p_1.getName();
                        String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_14);
                        _builder.append((Object)_firstUpper_2, "");
                        _builder.append((Object)"(");
                        ValueProperty _value_13 = p_1.getValue();
                        String _simpleAttributeValue_2 = this.simpleAttributeValue((SimpleValueProperty)_value_13);
                        _builder.append((Object)_simpleAttributeValue_2, "");
                        _builder.append((Object)");");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    _builder.append((Object)name, "");
                    _builder.append((Object)".set");
                    String _name_15 = p_1.getName();
                    String _firstUpper_3 = StringExtensions.toFirstUpper((String)_name_15);
                    _builder.append((Object)_firstUpper_3, "");
                    _builder.append((Object)"(");
                    ValueProperty _value_14 = p_1.getValue();
                    String _simpleAttributeValue_3 = this.simpleAttributeValue((SimpleValueProperty)_value_14);
                    _builder.append((Object)_simpleAttributeValue_3, "");
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                boolean _and_2 = false;
                ValueProperty _value_15 = p_1.getValue();
                _and_2 = !(_value_15 instanceof ControllerHandledValueProperty) ? false : (_hasController_1 = this.hasController());
                if (_and_2) {
                    String _name_16 = p_1.getName();
                    ValueProperty _value_16 = p_1.getValue();
                    String _methodname = ((ControllerHandledValueProperty)_value_16).getMethodname();
                    CharSequence _eventBindingAccess = this.eventBindingAccess(name, _name_16, _methodname, element);
                    _builder.append((Object)_eventBindingAccess, "");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                ValueProperty _value_17 = p_1.getValue();
                if (_value_17 instanceof ReferenceValueProperty) {
                    _builder.append((Object)name, "");
                    _builder.append((Object)".set");
                    String _name_17 = p_1.getName();
                    String _firstUpper_4 = StringExtensions.toFirstUpper((String)_name_17);
                    _builder.append((Object)_firstUpper_4, "");
                    _builder.append((Object)"((");
                    ValueProperty _value_18 = p_1.getValue();
                    ReferenceType _reference = ((ReferenceValueProperty)_value_18).getReference();
                    JvmTypeReference _type_25 = ((Element)_reference).getType();
                    String _qualifiedName_4 = _type_25.getQualifiedName();
                    _builder.append((Object)_qualifiedName_4, "");
                    _builder.append((Object)")namespaceMap.get(\"");
                    ValueProperty _value_19 = p_1.getValue();
                    ReferenceType _reference_1 = ((ReferenceValueProperty)_value_19).getReference();
                    String _name_18 = ((Element)_reference_1).getName();
                    _builder.append((Object)_name_18, "");
                    _builder.append((Object)"\"));");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                ValueProperty _value_20 = p_1.getValue();
                if (_value_20 instanceof Element) {
                    _builder.append((Object)"{");
                    _builder.newLine();
                    _builder.append((Object)"\t");
                    int _varIndex = this.getVarIndex();
                    String varName = "e_" + Integer.valueOf(_varIndex);
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    ValueProperty _value_21 = p_1.getValue();
                    CharSequence _generateElementDef = this.generateElementDef(varName, (Element)_value_21);
                    _builder.append((Object)_generateElementDef, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    _builder.append((Object)name, "\t");
                    _builder.append((Object)".set");
                    String _name_19 = p_1.getName();
                    String _firstUpper_5 = StringExtensions.toFirstUpper((String)_name_19);
                    _builder.append((Object)_firstUpper_5, "\t");
                    _builder.append((Object)"(");
                    _builder.append((Object)varName, "\t");
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    ValueProperty _value_22 = p_1.getValue();
                    CharSequence _staticProperties = this.staticProperties(varName, (Element)_value_22);
                    _builder.append((Object)_staticProperties, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"\t");
                    ValueProperty _value_23 = p_1.getValue();
                    CharSequence _staticCallProperties = this.staticCallProperties(varName, (Element)_value_23);
                    _builder.append((Object)_staticCallProperties, "\t");
                    _builder.newLineIfNotEmpty();
                    _builder.append((Object)"}");
                    _builder.newLine();
                    continue;
                }
                ValueProperty _value_24 = p_1.getValue();
                if (_value_24 instanceof ListValueProperty) {
                    ValueProperty _value_25 = p_1.getValue();
                    EList _value_26 = ((ListValueProperty)_value_25).getValue();
                    boolean _onlyPrimitive = this.onlyPrimitive((List<ListValueElement>)_value_26);
                    if (_onlyPrimitive) {
                        JvmTypeReference _type_26 = element.getType();
                        String _name_20 = p_1.getName();
                        String lt = ReflectionHelper.listType(_type_26, _name_20);
                        _builder.newLineIfNotEmpty();
                        _builder.append((Object)name, "");
                        _builder.append((Object)".get");
                        String _name_21 = p_1.getName();
                        String _firstUpper_6 = StringExtensions.toFirstUpper((String)_name_21);
                        _builder.append((Object)_firstUpper_6, "");
                        _builder.append((Object)"().setAll(");
                        _builder.newLineIfNotEmpty();
                        ValueProperty _value_27 = p_1.getValue();
                        EList _value_28 = ((ListValueProperty)_value_27).getValue();
                        for (ListValueElement l : _value_28) {
                            boolean _notEquals_11;
                            boolean _notEquals_5;
                            _builder.append((Object)"\t");
                            SimpleValueProperty sl = (SimpleValueProperty)l;
                            _builder.newLineIfNotEmpty();
                            String _stringValue_6 = sl.getStringValue();
                            boolean bl = _notEquals_5 = !Objects.equal((Object)_stringValue_6, null);
                            if (_notEquals_5) {
                                boolean _notEquals_10;
                                boolean _equals_9;
                                boolean _equals_8;
                                boolean _equals_7;
                                boolean _equals_5 = Objects.equal((Object)"java.lang.String", (Object)lt);
                                if (_equals_5) {
                                    boolean _notEquals_6;
                                    _builder.append((Object)"\t");
                                    ValueProperty _value_29 = p_1.getValue();
                                    EList _value_30 = ((ListValueProperty)_value_29).getValue();
                                    ListValueElement _head = (ListValueElement)IterableExtensions.head((Iterable)_value_30);
                                    boolean bl4 = _notEquals_6 = !Objects.equal((Object)_head, (Object)sl);
                                    if (_notEquals_6) {
                                        _builder.append((Object)", ");
                                    }
                                    String _simpleAttributeValue_4 = this.simpleAttributeValue(sl);
                                    _builder.append((Object)_simpleAttributeValue_4, "\t");
                                    _builder.newLineIfNotEmpty();
                                    continue;
                                }
                                boolean _or = false;
                                boolean _or_1 = false;
                                boolean _or_2 = false;
                                boolean _equals_6 = Objects.equal((Object)"java.lang.Double", (Object)lt);
                                _or_2 = _equals_6 ? true : (_equals_7 = Objects.equal((Object)"java.lang.Integer", (Object)lt));
                                _or_1 = _or_2 ? true : (_equals_8 = Objects.equal((Object)"java.lang.Long", (Object)lt));
                                _or = _or_1 ? true : (_equals_9 = Objects.equal((Object)"java.lang.Float", (Object)lt));
                                if (_or) {
                                    boolean _notEquals_9;
                                    boolean _equals_10 = Objects.equal((Object)"java.lang.Double", (Object)lt);
                                    if (_equals_10) {
                                        boolean _notEquals_7;
                                        _builder.append((Object)"\t");
                                        ValueProperty _value_31 = p_1.getValue();
                                        EList _value_32 = ((ListValueProperty)_value_31).getValue();
                                        ListValueElement _head_1 = (ListValueElement)IterableExtensions.head((Iterable)_value_32);
                                        boolean bl5 = _notEquals_7 = !Objects.equal((Object)_head_1, (Object)sl);
                                        if (_notEquals_7) {
                                            _builder.append((Object)", ");
                                        }
                                        String _stringValue_7 = sl.getStringValue();
                                        _builder.append((Object)_stringValue_7, "\t");
                                        _builder.append((Object)"d");
                                        _builder.newLineIfNotEmpty();
                                        continue;
                                    }
                                    boolean _equals_11 = Objects.equal((Object)"java.lang.Float", (Object)lt);
                                    if (_equals_11) {
                                        boolean _notEquals_8;
                                        _builder.append((Object)"\t");
                                        ValueProperty _value_33 = p_1.getValue();
                                        EList _value_34 = ((ListValueProperty)_value_33).getValue();
                                        ListValueElement _head_2 = (ListValueElement)IterableExtensions.head((Iterable)_value_34);
                                        boolean bl6 = _notEquals_8 = !Objects.equal((Object)_head_2, (Object)sl);
                                        if (_notEquals_8) {
                                            _builder.append((Object)", ");
                                        }
                                        String _stringValue_8 = sl.getStringValue();
                                        _builder.append((Object)_stringValue_8, "\t");
                                        _builder.append((Object)"f");
                                        _builder.newLineIfNotEmpty();
                                        continue;
                                    }
                                    _builder.append((Object)"\t");
                                    ValueProperty _value_35 = p_1.getValue();
                                    EList _value_36 = ((ListValueProperty)_value_35).getValue();
                                    ListValueElement _head_3 = (ListValueElement)IterableExtensions.head((Iterable)_value_36);
                                    boolean bl7 = _notEquals_9 = !Objects.equal((Object)_head_3, (Object)sl);
                                    if (_notEquals_9) {
                                        _builder.append((Object)", ");
                                    }
                                    String _stringValue_9 = sl.getStringValue();
                                    _builder.append((Object)_stringValue_9, "\t");
                                    _builder.newLineIfNotEmpty();
                                    continue;
                                }
                                _builder.append((Object)"\t");
                                ValueProperty _value_37 = p_1.getValue();
                                EList _value_38 = ((ListValueProperty)_value_37).getValue();
                                ListValueElement _head_4 = (ListValueElement)IterableExtensions.head((Iterable)_value_38);
                                boolean bl8 = _notEquals_10 = !Objects.equal((Object)_head_4, (Object)sl);
                                if (_notEquals_10) {
                                    _builder.append((Object)", ");
                                }
                                _builder.append((Object)lt, "\t");
                                _builder.append((Object)".valueOf(");
                                String _simpleAttributeValue_5 = this.simpleAttributeValue(sl);
                                _builder.append((Object)_simpleAttributeValue_5, "\t");
                                _builder.append((Object)")");
                                _builder.newLineIfNotEmpty();
                                continue;
                            }
                            _builder.append((Object)"\t");
                            ValueProperty _value_39 = p_1.getValue();
                            EList _value_40 = ((ListValueProperty)_value_39).getValue();
                            ListValueElement _head_5 = (ListValueElement)IterableExtensions.head((Iterable)_value_40);
                            boolean bl9 = _notEquals_11 = !Objects.equal((Object)_head_5, (Object)sl);
                            if (_notEquals_11) {
                                _builder.append((Object)", ");
                            }
                            String _simpleAttributeValue_6 = this.simpleAttributeValue(sl);
                            _builder.append((Object)_simpleAttributeValue_6, "\t");
                            _builder.newLineIfNotEmpty();
                        }
                        _builder.append((Object)");");
                        _builder.newLine();
                        continue;
                    }
                    ValueProperty _value_41 = p_1.getValue();
                    EList _value_42 = ((ListValueProperty)_value_41).getValue();
                    for (ListValueElement l_1 : _value_42) {
                        _builder.append((Object)"{");
                        _builder.newLine();
                        int i = this.getVarIndex();
                        _builder.newLineIfNotEmpty();
                        String varName_1 = "e_" + Integer.valueOf(i);
                        _builder.newLineIfNotEmpty();
                        if (l_1 instanceof Element) {
                            _builder.append((Object)"\t");
                            CharSequence _generateElementDef_1 = this.generateElementDef(varName_1, (Element)l_1);
                            _builder.append((Object)_generateElementDef_1, "\t");
                            _builder.newLineIfNotEmpty();
                            JvmTypeReference _type_27 = ((Element)l_1).getType();
                            String _qualifiedName_5 = _type_27.getQualifiedName();
                            boolean _equals_12 = Objects.equal((Object)"java.net.URL", (Object)_qualifiedName_5);
                            if (_equals_12) {
                                _builder.append((Object)"\t");
                                _builder.append((Object)name, "\t");
                                _builder.append((Object)".get");
                                String _name_22 = p_1.getName();
                                String _firstUpper_7 = StringExtensions.toFirstUpper((String)_name_22);
                                _builder.append((Object)_firstUpper_7, "\t");
                                _builder.append((Object)"().add(");
                                _builder.append((Object)varName_1, "\t");
                                _builder.append((Object)".toExternalForm());");
                                _builder.newLineIfNotEmpty();
                            } else {
                                _builder.append((Object)"\t");
                                _builder.append((Object)name, "\t");
                                _builder.append((Object)".get");
                                String _name_23 = p_1.getName();
                                String _firstUpper_8 = StringExtensions.toFirstUpper((String)_name_23);
                                _builder.append((Object)_firstUpper_8, "\t");
                                _builder.append((Object)"().add(");
                                _builder.append((Object)varName_1, "\t");
                                _builder.append((Object)");");
                                _builder.newLineIfNotEmpty();
                            }
                            _builder.append((Object)"\t");
                            CharSequence _staticProperties_1 = this.staticProperties(varName_1, (Element)l_1);
                            _builder.append((Object)_staticProperties_1, "\t");
                            _builder.newLineIfNotEmpty();
                            _builder.append((Object)"\t");
                            CharSequence _staticCallProperties_1 = this.staticCallProperties(varName_1, (Element)l_1);
                            _builder.append((Object)_staticCallProperties_1, "\t");
                            _builder.newLineIfNotEmpty();
                        } else if (l_1 instanceof SimpleValueProperty) {
                            boolean _notEquals_12;
                            String _stringValue_10 = ((SimpleValueProperty)l_1).getStringValue();
                            boolean bl = _notEquals_12 = !Objects.equal((Object)_stringValue_10, null);
                            if (_notEquals_12) {
                                _builder.append((Object)"\t");
                                JvmTypeReference _type_28 = element.getType();
                                String _name_24 = p_1.getName();
                                String lt_1 = ReflectionHelper.listType(_type_28, _name_24);
                                _builder.newLineIfNotEmpty();
                                boolean _equals_13 = Objects.equal((Object)"java.lang.String", (Object)lt_1);
                                if (_equals_13) {
                                    _builder.append((Object)"\t");
                                    _builder.append((Object)name, "\t");
                                    _builder.append((Object)".get");
                                    String _name_25 = p_1.getName();
                                    String _firstUpper_9 = StringExtensions.toFirstUpper((String)_name_25);
                                    _builder.append((Object)_firstUpper_9, "\t");
                                    _builder.append((Object)"().add(");
                                    String _simpleAttributeValue_7 = this.simpleAttributeValue((SimpleValueProperty)l_1);
                                    _builder.append((Object)_simpleAttributeValue_7, "\t");
                                    _builder.append((Object)");");
                                    _builder.newLineIfNotEmpty();
                                } else {
                                    boolean _equals_17;
                                    boolean _equals_16;
                                    boolean _equals_15;
                                    boolean _or_3 = false;
                                    boolean _or_4 = false;
                                    boolean _or_5 = false;
                                    boolean _equals_14 = Objects.equal((Object)"java.lang.Double", (Object)lt_1);
                                    _or_5 = _equals_14 ? true : (_equals_15 = Objects.equal((Object)"java.lang.Integer", (Object)lt_1));
                                    _or_4 = _or_5 ? true : (_equals_16 = Objects.equal((Object)"java.lang.Long", (Object)lt_1));
                                    _or_3 = _or_4 ? true : (_equals_17 = Objects.equal((Object)"java.lang.Float", (Object)lt_1));
                                    if (_or_3) {
                                        boolean _equals_18 = Objects.equal((Object)"java.lang.Double", (Object)lt_1);
                                        if (_equals_18) {
                                            _builder.append((Object)"\t");
                                            _builder.append((Object)name, "\t");
                                            _builder.append((Object)".get");
                                            String _name_26 = p_1.getName();
                                            String _firstUpper_10 = StringExtensions.toFirstUpper((String)_name_26);
                                            _builder.append((Object)_firstUpper_10, "\t");
                                            _builder.append((Object)"().add(");
                                            String _stringValue_11 = ((SimpleValueProperty)l_1).getStringValue();
                                            _builder.append((Object)_stringValue_11, "\t");
                                            _builder.append((Object)"d);");
                                            _builder.newLineIfNotEmpty();
                                        } else {
                                            boolean _equals_19 = Objects.equal((Object)"java.lang.Float", (Object)lt_1);
                                            if (_equals_19) {
                                                _builder.append((Object)"\t");
                                                _builder.append((Object)name, "\t");
                                                _builder.append((Object)".get");
                                                String _name_27 = p_1.getName();
                                                String _firstUpper_11 = StringExtensions.toFirstUpper((String)_name_27);
                                                _builder.append((Object)_firstUpper_11, "\t");
                                                _builder.append((Object)"().add(");
                                                String _stringValue_12 = ((SimpleValueProperty)l_1).getStringValue();
                                                _builder.append((Object)_stringValue_12, "\t");
                                                _builder.append((Object)"f);");
                                                _builder.newLineIfNotEmpty();
                                            } else {
                                                _builder.append((Object)"\t");
                                                _builder.append((Object)name, "\t");
                                                _builder.append((Object)".get");
                                                String _name_28 = p_1.getName();
                                                String _firstUpper_12 = StringExtensions.toFirstUpper((String)_name_28);
                                                _builder.append((Object)_firstUpper_12, "\t");
                                                _builder.append((Object)"().add(");
                                                String _stringValue_13 = ((SimpleValueProperty)l_1).getStringValue();
                                                _builder.append((Object)_stringValue_13, "\t");
                                                _builder.append((Object)");");
                                                _builder.newLineIfNotEmpty();
                                            }
                                        }
                                    } else {
                                        _builder.append((Object)"\t");
                                        _builder.append((Object)name, "\t");
                                        _builder.append((Object)".get");
                                        String _name_29 = p_1.getName();
                                        String _firstUpper_13 = StringExtensions.toFirstUpper((String)_name_29);
                                        _builder.append((Object)_firstUpper_13, "\t");
                                        _builder.append((Object)"().add(");
                                        _builder.append((Object)lt_1, "\t");
                                        _builder.append((Object)".valueOf(");
                                        String _simpleAttributeValue_8 = this.simpleAttributeValue((SimpleValueProperty)l_1);
                                        _builder.append((Object)_simpleAttributeValue_8, "\t");
                                        _builder.append((Object)"));");
                                        _builder.newLineIfNotEmpty();
                                    }
                                }
                            } else {
                                _builder.append((Object)"\t");
                                _builder.append((Object)name, "\t");
                                _builder.append((Object)".get");
                                String _name_30 = p_1.getName();
                                String _firstUpper_14 = StringExtensions.toFirstUpper((String)_name_30);
                                _builder.append((Object)_firstUpper_14, "\t");
                                _builder.append((Object)"().add(");
                                String _simpleAttributeValue_9 = this.simpleAttributeValue((SimpleValueProperty)l_1);
                                _builder.append((Object)_simpleAttributeValue_9, "\t");
                                _builder.append((Object)");");
                                _builder.newLineIfNotEmpty();
                            }
                        } else if (l_1 instanceof ResourceValueProperty) {
                            _builder.append((Object)"\t");
                            _builder.append((Object)name, "\t");
                            _builder.append((Object)".get");
                            String _name_31 = p_1.getName();
                            String _firstUpper_15 = StringExtensions.toFirstUpper((String)_name_31);
                            _builder.append((Object)_firstUpper_15, "\t");
                            _builder.append((Object)"().add(resourceBundle.getString(\"");
                            StringValue _value_43 = ((ResourceValueProperty)l_1).getValue();
                            String _value_44 = _value_43.getValue();
                            _builder.append((Object)_value_44, "\t");
                            _builder.append((Object)"\"));");
                            _builder.newLineIfNotEmpty();
                        } else if (l_1 instanceof LocationValueProperty) {
                            _builder.append((Object)"\t");
                            _builder.append((Object)name, "\t");
                            _builder.append((Object)".get");
                            String _name_32 = p_1.getName();
                            String _firstUpper_16 = StringExtensions.toFirstUpper((String)_name_32);
                            _builder.append((Object)_firstUpper_16, "\t");
                            _builder.append((Object)"().add(baseURL + \"/");
                            String _value_45 = ((LocationValueProperty)l_1).getValue();
                            _builder.append((Object)_value_45, "\t");
                            _builder.append((Object)"\");");
                            _builder.newLineIfNotEmpty();
                        }
                        _builder.append((Object)"}");
                        _builder.newLine();
                    }
                    continue;
                }
                ValueProperty _value_46 = p_1.getValue();
                if (_value_46 instanceof LocationValueProperty) {
                    _builder.append((Object)name, "");
                    _builder.append((Object)".set");
                    String _name_33 = p_1.getName();
                    String _firstUpper_17 = StringExtensions.toFirstUpper((String)_name_33);
                    _builder.append((Object)_firstUpper_17, "");
                    _builder.append((Object)"(baseURL + \"/");
                    ValueProperty _value_47 = p_1.getValue();
                    String _value_48 = ((LocationValueProperty)_value_47).getValue();
                    _builder.append((Object)_value_48, "");
                    _builder.append((Object)"\");");
                    _builder.newLineIfNotEmpty();
                    this.enableResourceUrl();
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                ValueProperty _value_49 = p_1.getValue();
                if (!(_value_49 instanceof ResourceValueProperty)) continue;
                _builder.append((Object)name, "");
                _builder.append((Object)".set");
                String _name_34 = p_1.getName();
                String _firstUpper_18 = StringExtensions.toFirstUpper((String)_name_34);
                _builder.append((Object)_firstUpper_18, "");
                _builder.append((Object)"(resourceBundle.getString(\"");
                ValueProperty _value_50 = p_1.getValue();
                StringValue _value_51 = ((ResourceValueProperty)_value_50).getValue();
                String _value_52 = _value_51.getValue();
                _builder.append((Object)_value_52, "");
                _builder.append((Object)"\"));");
                _builder.newLineIfNotEmpty();
                this.enableResourceUrl();
                _builder.newLineIfNotEmpty();
            }
            EList _defaultChildren = element.getDefaultChildren();
            for (Element p_2 : _defaultChildren) {
                _builder.append((Object)"{");
                _builder.newLine();
                _builder.append((Object)"\t");
                int i_1 = this.getVarIndex();
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                String varName_2 = "e_" + Integer.valueOf(i_1);
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                CharSequence _generateElementDef_2 = this.generateElementDef(varName_2, p_2);
                _builder.append((Object)_generateElementDef_2, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                CharSequence _staticProperties_2 = this.staticProperties(varName_2, p_2);
                _builder.append((Object)_staticProperties_2, "\t");
                _builder.newLineIfNotEmpty();
                _builder.append((Object)"\t");
                CharSequence _staticCallProperties_2 = this.staticCallProperties(varName_2, p_2);
                _builder.append((Object)_staticCallProperties_2, "\t");
                _builder.newLineIfNotEmpty();
                _builder.newLine();
                JvmTypeReference _type_29 = p_2.getType();
                String _qualifiedName_6 = _type_29.getQualifiedName();
                boolean _equals_20 = Objects.equal((Object)"java.net.URL", (Object)_qualifiedName_6);
                if (_equals_20) {
                    _builder.append((Object)"\t");
                    _builder.append((Object)name, "\t");
                    _builder.append((Object)".get");
                    JvmTypeReference _type_30 = element.getType();
                    String _defaultAttribute = ReflectionHelper.defaultAttribute(_type_30);
                    String _firstUpper_19 = StringExtensions.toFirstUpper((String)_defaultAttribute);
                    _builder.append((Object)_firstUpper_19, "\t");
                    _builder.append((Object)"().add(");
                    _builder.append((Object)varName_2, "\t");
                    _builder.append((Object)".toExternalForm());");
                    _builder.newLineIfNotEmpty();
                } else {
                    _builder.append((Object)"\t");
                    _builder.append((Object)name, "\t");
                    _builder.append((Object)".get");
                    JvmTypeReference _type_31 = element.getType();
                    String _defaultAttribute_1 = ReflectionHelper.defaultAttribute(_type_31);
                    String _firstUpper_20 = StringExtensions.toFirstUpper((String)_defaultAttribute_1);
                    _builder.append((Object)_firstUpper_20, "\t");
                    _builder.append((Object)"().add(");
                    _builder.append((Object)varName_2, "\t");
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                }
                _builder.append((Object)"}");
                _builder.newLine();
            }
            boolean _and_3 = false;
            String _name_35 = element.getName();
            boolean _notEquals_13 = !Objects.equal((Object)_name_35, null);
            _and_3 = !_notEquals_13 ? false : (_hasController_2 = this.hasController());
            if (_and_3) {
                CharSequence _controllerFieldAccess_1 = this.controllerFieldAccess(name, element);
                _builder.append((Object)_controllerFieldAccess_1, "");
                _builder.newLineIfNotEmpty();
            }
        }
        boolean bl = _notEquals_14 = !Objects.equal((Object)(_name_36 = element.getName()), null);
        if (_notEquals_14) {
            _builder.append((Object)"namespaceMap.put(\"");
            String _name_37 = element.getName();
            _builder.append((Object)_name_37, "");
            _builder.append((Object)"\",");
            _builder.append((Object)name, "");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence staticCallProperties(String name, Element element) {
        StringConcatenation _builder = new StringConcatenation();
        EList _staticCallProperties = element.getStaticCallProperties();
        for (StaticCallValueProperty prop : _staticCallProperties) {
            JvmTypeReference type = prop.getType();
            _builder.newLineIfNotEmpty();
            ValueProperty _value = prop.getValue();
            if (_value instanceof SimpleValueProperty) {
                boolean _notEquals;
                ValueProperty _value_1 = prop.getValue();
                String _stringValue = ((SimpleValueProperty)_value_1).getStringValue();
                boolean bl = _notEquals = !Objects.equal((Object)_stringValue, null);
                if (_notEquals) {
                    boolean _notEquals_1;
                    String _name = prop.getName();
                    String enumType = ReflectionHelper.getEnumType(type, _name, true);
                    _builder.newLineIfNotEmpty();
                    boolean bl2 = _notEquals_1 = !Objects.equal((Object)enumType, null);
                    if (_notEquals_1) {
                        _builder.append((Object)"// an enum type");
                        _builder.newLine();
                        String _simpleName = type.getSimpleName();
                        _builder.append((Object)_simpleName, "");
                        _builder.append((Object)".set");
                        String _name_1 = prop.getName();
                        String _firstUpper = StringExtensions.toFirstUpper((String)_name_1);
                        _builder.append((Object)_firstUpper, "");
                        _builder.append((Object)"(");
                        _builder.append((Object)name, "");
                        _builder.append((Object)",");
                        _builder.append((Object)enumType, "");
                        _builder.append((Object)".");
                        ValueProperty _value_2 = prop.getValue();
                        String _stringValue_1 = ((SimpleValueProperty)_value_2).getStringValue();
                        _builder.append((Object)_stringValue_1, "");
                        _builder.append((Object)");");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    _builder.append((Object)"// a simple value");
                    _builder.newLine();
                    String _simpleName_1 = type.getSimpleName();
                    _builder.append((Object)_simpleName_1, "");
                    _builder.append((Object)".set");
                    String _name_2 = prop.getName();
                    String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_2);
                    _builder.append((Object)_firstUpper_1, "");
                    _builder.append((Object)"(");
                    _builder.append((Object)name, "");
                    _builder.append((Object)",");
                    ValueProperty _value_3 = prop.getValue();
                    String _simpleAttributeValue = this.simpleAttributeValue((SimpleValueProperty)_value_3);
                    _builder.append((Object)_simpleAttributeValue, "");
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                String _simpleName_2 = type.getSimpleName();
                _builder.append((Object)_simpleName_2, "");
                _builder.append((Object)".set");
                String _name_3 = prop.getName();
                String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_3);
                _builder.append((Object)_firstUpper_2, "");
                _builder.append((Object)"(");
                _builder.append((Object)name, "");
                _builder.append((Object)",");
                ValueProperty _value_4 = prop.getValue();
                String _simpleAttributeValue_1 = this.simpleAttributeValue((SimpleValueProperty)_value_4);
                _builder.append((Object)_simpleAttributeValue_1, "");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_5 = prop.getValue();
            if (_value_5 instanceof ReferenceValueProperty) {
                String _simpleName_3 = type.getSimpleName();
                _builder.append((Object)_simpleName_3, "");
                _builder.append((Object)".set");
                String _name_4 = prop.getName();
                String _firstUpper_3 = StringExtensions.toFirstUpper((String)_name_4);
                _builder.append((Object)_firstUpper_3, "");
                _builder.append((Object)"(");
                _builder.append((Object)name, "");
                _builder.append((Object)",(");
                ValueProperty _value_6 = prop.getValue();
                ReferenceType _reference = ((ReferenceValueProperty)_value_6).getReference();
                JvmTypeReference _type = ((Element)_reference).getType();
                String _qualifiedName = _type.getQualifiedName();
                _builder.append((Object)_qualifiedName, "");
                _builder.append((Object)")namespaceMap.get(\"");
                ValueProperty _value_7 = prop.getValue();
                ReferenceType _reference_1 = ((ReferenceValueProperty)_value_7).getReference();
                String _name_5 = ((Element)_reference_1).getName();
                _builder.append((Object)_name_5, "");
                _builder.append((Object)"\"));");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_8 = prop.getValue();
            if (!(_value_8 instanceof Element)) continue;
            int _varIndex = this.getVarIndex();
            String varname = "e_" + Integer.valueOf(_varIndex);
            _builder.newLineIfNotEmpty();
            ValueProperty _value_9 = prop.getValue();
            CharSequence _generateElementDef = this.generateElementDef(varname, (Element)_value_9);
            _builder.append((Object)_generateElementDef, "");
            _builder.newLineIfNotEmpty();
            String _simpleName_4 = type.getSimpleName();
            _builder.append((Object)_simpleName_4, "");
            _builder.append((Object)".set");
            String _name_6 = prop.getName();
            String _firstUpper_4 = StringExtensions.toFirstUpper((String)_name_6);
            _builder.append((Object)_firstUpper_4, "");
            _builder.append((Object)"(");
            _builder.append((Object)name, "");
            _builder.append((Object)",");
            _builder.append((Object)varname, "");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public CharSequence staticProperties(String name, Element element) {
        StringConcatenation _builder = new StringConcatenation();
        EList _staticProperties = element.getStaticProperties();
        for (StaticValueProperty prop : _staticProperties) {
            JvmTypeReference type = this.type(prop);
            _builder.newLineIfNotEmpty();
            ValueProperty _value = prop.getValue();
            if (_value instanceof SimpleValueProperty) {
                boolean _notEquals;
                ValueProperty _value_1 = prop.getValue();
                String _stringValue = ((SimpleValueProperty)_value_1).getStringValue();
                boolean bl = _notEquals = !Objects.equal((Object)_stringValue, null);
                if (_notEquals) {
                    boolean _notEquals_1;
                    String _name = prop.getName();
                    String enumType = ReflectionHelper.getEnumType(type, _name, true);
                    _builder.newLineIfNotEmpty();
                    boolean bl2 = _notEquals_1 = !Objects.equal((Object)enumType, null);
                    if (_notEquals_1) {
                        String _simpleName = type.getSimpleName();
                        _builder.append((Object)_simpleName, "");
                        _builder.append((Object)".set");
                        String _name_1 = prop.getName();
                        String _firstUpper = StringExtensions.toFirstUpper((String)_name_1);
                        _builder.append((Object)_firstUpper, "");
                        _builder.append((Object)"(");
                        _builder.append((Object)name, "");
                        _builder.append((Object)",");
                        _builder.append((Object)enumType, "");
                        _builder.append((Object)".");
                        ValueProperty _value_2 = prop.getValue();
                        String _stringValue_1 = ((SimpleValueProperty)_value_2).getStringValue();
                        _builder.append((Object)_stringValue_1, "");
                        _builder.append((Object)");");
                        _builder.newLineIfNotEmpty();
                        continue;
                    }
                    String _simpleName_1 = type.getSimpleName();
                    _builder.append((Object)_simpleName_1, "");
                    _builder.append((Object)".set");
                    String _name_2 = prop.getName();
                    String _firstUpper_1 = StringExtensions.toFirstUpper((String)_name_2);
                    _builder.append((Object)_firstUpper_1, "");
                    _builder.append((Object)"(");
                    _builder.append((Object)name, "");
                    _builder.append((Object)",");
                    ValueProperty _value_3 = prop.getValue();
                    String _simpleAttributeValue = this.simpleAttributeValue((SimpleValueProperty)_value_3);
                    _builder.append((Object)_simpleAttributeValue, "");
                    _builder.append((Object)");");
                    _builder.newLineIfNotEmpty();
                    continue;
                }
                String _simpleName_2 = type.getSimpleName();
                _builder.append((Object)_simpleName_2, "");
                _builder.append((Object)".set");
                String _name_3 = prop.getName();
                String _firstUpper_2 = StringExtensions.toFirstUpper((String)_name_3);
                _builder.append((Object)_firstUpper_2, "");
                _builder.append((Object)"(");
                _builder.append((Object)name, "");
                _builder.append((Object)",");
                ValueProperty _value_4 = prop.getValue();
                String _simpleAttributeValue_1 = this.simpleAttributeValue((SimpleValueProperty)_value_4);
                _builder.append((Object)_simpleAttributeValue_1, "");
                _builder.append((Object)");");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_5 = prop.getValue();
            if (_value_5 instanceof ReferenceValueProperty) {
                String _simpleName_3 = type.getSimpleName();
                _builder.append((Object)_simpleName_3, "");
                _builder.append((Object)".set");
                String _name_4 = prop.getName();
                String _firstUpper_3 = StringExtensions.toFirstUpper((String)_name_4);
                _builder.append((Object)_firstUpper_3, "");
                _builder.append((Object)"(");
                _builder.append((Object)name, "");
                _builder.append((Object)",((");
                ValueProperty _value_6 = prop.getValue();
                ReferenceType _reference = ((ReferenceValueProperty)_value_6).getReference();
                JvmTypeReference _type = ((Element)_reference).getType();
                String _qualifiedName = _type.getQualifiedName();
                _builder.append((Object)_qualifiedName, "");
                _builder.append((Object)")namespaceMap.get(\"");
                ValueProperty _value_7 = prop.getValue();
                ReferenceType _reference_1 = ((ReferenceValueProperty)_value_7).getReference();
                String _name_5 = ((Element)_reference_1).getName();
                _builder.append((Object)_name_5, "");
                _builder.append((Object)"\"));");
                _builder.newLineIfNotEmpty();
                continue;
            }
            ValueProperty _value_8 = prop.getValue();
            if (!(_value_8 instanceof Element)) continue;
            int _varIndex = this.getVarIndex();
            String varname = "e_" + Integer.valueOf(_varIndex);
            _builder.newLineIfNotEmpty();
            ValueProperty _value_9 = prop.getValue();
            CharSequence _generateElementDef = this.generateElementDef(varname, (Element)_value_9);
            _builder.append((Object)_generateElementDef, "");
            _builder.newLineIfNotEmpty();
            String _simpleName_4 = type.getSimpleName();
            _builder.append((Object)_simpleName_4, "");
            _builder.append((Object)".set");
            String _name_6 = prop.getName();
            String _firstUpper_4 = StringExtensions.toFirstUpper((String)_name_6);
            _builder.append((Object)_firstUpper_4, "");
            _builder.append((Object)"(");
            _builder.append((Object)name, "");
            _builder.append((Object)",");
            _builder.append((Object)varname, "");
            _builder.append((Object)");");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    public String simpleAttributeValue(SimpleValueProperty value) {
        boolean _notEquals_2;
        boolean _notEquals_1;
        boolean _notEquals;
        String _stringValue = value.getStringValue();
        boolean bl = _notEquals = !Objects.equal((Object)_stringValue, null);
        if (_notEquals) {
            String _stringValue_1 = value.getStringValue();
            String _plus = "\"" + _stringValue_1;
            return String.valueOf(_plus) + "\"";
        }
        String _booleanValue = value.getBooleanValue();
        boolean bl2 = _notEquals_1 = !Objects.equal((Object)_booleanValue, null);
        if (_notEquals_1) {
            return value.getBooleanValue();
        }
        String _number = value.getNumber();
        boolean bl3 = _notEquals_2 = !Objects.equal((Object)_number, null);
        if (_notEquals_2) {
            boolean _isNegative = value.isNegative();
            if (_isNegative) {
                String _number_1 = value.getNumber();
                boolean _equals = Objects.equal((Object)_number_1, (Object)"-Infinity");
                if (_equals) {
                    return "Double.NEGATIVE_INFINITY";
                }
                String _number_2 = value.getNumber();
                return "-" + _number_2;
            }
            String _number_3 = value.getNumber();
            boolean _equals_1 = Objects.equal((Object)_number_3, (Object)"-Infinity");
            if (_equals_1) {
                return "Double.NEGATIVE_INFINITY";
            }
            String _number_4 = value.getNumber();
            boolean _equals_2 = Objects.equal((Object)_number_4, (Object)"Infinity");
            if (_equals_2) {
                return "Double.POSITIVE_INFINITY";
            }
            return value.getNumber();
        }
        return null;
    }

    public JvmTypeReference type(StaticValueProperty prop) {
        EObject el = prop.eContainer();
        while (!Objects.equal((Object)el.eContainer(), null)) {
            EObject _eContainer_2;
            EObject _eContainer = el.eContainer();
            if (_eContainer instanceof Element) {
                EObject _eContainer_1 = el.eContainer();
                Element e = (Element)_eContainer_1;
                return e.getType();
            }
            el = _eContainer_2 = el.eContainer();
        }
        return null;
    }

    public boolean onlyPrimitive(List<ListValueElement> list) {
        Functions.Function1<ListValueElement, Boolean> _function = new Functions.Function1<ListValueElement, Boolean>(){

            public Boolean apply(ListValueElement e) {
                return !(e instanceof SimpleValueProperty);
            }
        };
        ListValueElement _findFirst = (ListValueElement)IterableExtensions.findFirst(list, (Functions.Function1)_function);
        return Objects.equal((Object)_findFirst, null);
    }
}

