/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.fxml.compiler.ant;

import com.google.inject.Injector;
import java.io.File;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.eclipse.fx.ide.fxgraph.FXGraphStandaloneSetupGenerated;
import org.eclipse.fx.ide.fxml.compiler.FXGraphCompiler;
import org.xml.sax.SAXException;

public abstract class CompilerTask
extends Task {
    private String srcDir;
    private String destDir;
    private String classpathref;
    private final boolean fxgraph;

    public CompilerTask(boolean fxgraph) {
        this.fxgraph = fxgraph;
    }

    public void setSourceDir(String srcDir) {
        this.srcDir = srcDir;
    }

    public String getSrcDir() {
        return this.srcDir;
    }

    public void setDestDir(String destDir) {
        this.destDir = destDir;
    }

    public String getDestDir() {
        return this.destDir;
    }

    public void execute() throws BuildException {
        File f = new File(this.getLocation().getFileName());
        File sourceDirectory = new File(f.getParentFile(), this.srcDir);
        File outDirectory = new File(f.getParentFile(), this.destDir);
        final String sourcePrefix = sourceDirectory.getAbsolutePath();
        final String outPrefix = outDirectory.getAbsolutePath();
        final Injector injector = new FXGraphStandaloneSetupGenerated().createInjectorAndDoEMFRegistration();
        final FXGraphCompiler compiler = (FXGraphCompiler)injector.getInstance(FXGraphCompiler.class);
        try {
            Files.walkFileTree(Paths.get(sourceDirectory.getAbsolutePath(), new String[0]), new FileFinder(new Callable(){

                @Override
                public void call(String file) {
                    System.out.println("Compiling " + file);
                    try {
                        compiler.compile(injector, file, sourcePrefix, outPrefix);
                    }
                    catch (IOException | ParserConfigurationException | SAXException e) {
                        e.printStackTrace();
                    }
                }
            }));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static interface Callable {
        public void call(String var1);
    }

    class FileFinder
    extends SimpleFileVisitor<Path> {
        private final Callable runnable;

        public FileFinder(Callable runnable) {
            this.runnable = runnable;
        }

        @Override
        public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
            if (file.toFile().getAbsolutePath().endsWith(".fxml") && !CompilerTask.this.fxgraph || file.toFile().getAbsolutePath().endsWith(".fxgraph") && CompilerTask.this.fxgraph) {
                this.runnable.call(file.toFile().getAbsolutePath());
            }
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult postVisitDirectory(Path dir, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
            return FileVisitResult.CONTINUE;
        }

        @Override
        public FileVisitResult visitFileFailed(Path file, IOException exc) throws IOException {
            return FileVisitResult.CONTINUE;
        }
    }
}

