/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.fx.ide.jdt.ui.internal.wizard;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.fx.ide.jdt.core.JavaFXCore;
import org.eclipse.fx.ide.jdt.ui.internal.wizard.NewJavaFXProjectWizardPageTwo;
import org.eclipse.jdt.core.IClasspathEntry;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.JavaPluginImages;
import org.eclipse.jdt.internal.ui.packageview.PackageExplorerPart;
import org.eclipse.jdt.internal.ui.util.ExceptionHandler;
import org.eclipse.jdt.internal.ui.wizards.NewElementWizard;
import org.eclipse.jdt.internal.ui.wizards.NewWizardMessages;
import org.eclipse.jdt.ui.IPackagesViewPart;
import org.eclipse.jdt.ui.wizards.NewJavaProjectWizardPageOne;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.wizards.newresource.BasicNewProjectResourceWizard;

public class JavaFXLibraryProjectWizard
extends NewElementWizard
implements IExecutableExtension {
    private NewJavaProjectWizardPageOne fFirstPage;
    private NewJavaFXProjectWizardPageTwo fSecondPage;
    private IConfigurationElement fConfigElement;

    public JavaFXLibraryProjectWizard() {
        this(null, null);
    }

    public JavaFXLibraryProjectWizard(NewJavaProjectWizardPageOne pageOne, NewJavaFXProjectWizardPageTwo pageTwo) {
        this.setDefaultPageImageDescriptor(JavaPluginImages.DESC_WIZBAN_NEWJPRJ);
        this.setDialogSettings(JavaPlugin.getDefault().getDialogSettings());
        this.setWindowTitle(NewWizardMessages.JavaProjectWizard_title);
        this.fFirstPage = pageOne;
        this.fSecondPage = pageTwo;
    }

    public void addPages() {
        if (this.fFirstPage == null) {
            this.fFirstPage = new NewJavaProjectWizardPageOne();
        }
        this.addPage((IWizardPage)this.fFirstPage);
        if (this.fSecondPage == null) {
            this.fSecondPage = new NewJavaFXProjectWizardPageTwo(this.fFirstPage);
        }
        this.addPage((IWizardPage)this.fSecondPage);
        this.fFirstPage.init(this.getSelection(), this.getActivePart());
    }

    protected void finishPage(IProgressMonitor monitor) throws InterruptedException, CoreException {
        this.fSecondPage.performFinish(monitor);
    }

    public boolean performFinish() {
        boolean res = super.performFinish();
        if (res) {
            final IJavaElement newElement = this.getCreatedElement();
            try {
                IJavaProject p = (IJavaProject)newElement;
                IClasspathEntry[] current = p.getRawClasspath();
                IClasspathEntry[] currentFX = new IClasspathEntry[current.length + 1];
                System.arraycopy(current, 0, currentFX, 0, current.length);
                currentFX[current.length] = JavaCore.newContainerEntry((IPath)JavaFXCore.JAVAFX_CONTAINER_PATH);
                p.setRawClasspath(currentFX, (IProgressMonitor)new NullProgressMonitor());
            }
            catch (JavaModelException e1) {
                e1.printStackTrace();
            }
            IWorkingSet[] workingSets = this.fFirstPage.getWorkingSets();
            if (workingSets.length > 0) {
                PlatformUI.getWorkbench().getWorkingSetManager().addToWorkingSets((IAdaptable)newElement, workingSets);
            }
            BasicNewProjectResourceWizard.updatePerspective((IConfigurationElement)this.fConfigElement);
            this.selectAndReveal((IResource)this.fSecondPage.getJavaProject().getProject());
            Display.getDefault().asyncExec(new Runnable(){

                @Override
                public void run() {
                    IWorkbenchPart activePart = JavaFXLibraryProjectWizard.this.getActivePart();
                    if (activePart instanceof IPackagesViewPart) {
                        PackageExplorerPart view = PackageExplorerPart.openInActivePerspective();
                        view.tryToReveal((Object)newElement);
                    }
                }
            });
        }
        return res;
    }

    private IWorkbenchPart getActivePart() {
        IWorkbenchPage activePage;
        IWorkbenchWindow activeWindow = this.getWorkbench().getActiveWorkbenchWindow();
        if (activeWindow != null && (activePage = activeWindow.getActivePage()) != null) {
            return activePage.getActivePart();
        }
        return null;
    }

    protected void handleFinishException(Shell shell, InvocationTargetException e) {
        String title = NewWizardMessages.JavaProjectWizard_op_error_title;
        String message = NewWizardMessages.JavaProjectWizard_op_error_create_message;
        ExceptionHandler.handle((InvocationTargetException)e, (Shell)this.getShell(), (String)title, (String)message);
    }

    public void setInitializationData(IConfigurationElement cfig, String propertyName, Object data) {
        this.fConfigElement = cfig;
    }

    public boolean performCancel() {
        this.fSecondPage.performCancel();
        return super.performCancel();
    }

    public IJavaElement getCreatedElement() {
        return this.fSecondPage.getJavaProject();
    }
}

