/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.etrice.generator.cpp.gen;

import com.google.common.base.Objects;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Singleton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.eclipse.emf.common.util.EList;
import org.eclipse.etrice.core.common.converter.TimeConverter;
import org.eclipse.etrice.core.etmap.util.ETMapUtil;
import org.eclipse.etrice.core.etphys.eTPhys.ExecMode;
import org.eclipse.etrice.core.etphys.eTPhys.NodeRef;
import org.eclipse.etrice.core.etphys.eTPhys.PhysicalThread;
import org.eclipse.etrice.core.genmodel.etricegen.AbstractInstance;
import org.eclipse.etrice.core.genmodel.etricegen.ActorInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Root;
import org.eclipse.etrice.core.genmodel.etricegen.StructureInstance;
import org.eclipse.etrice.core.genmodel.etricegen.SubSystemInstance;
import org.eclipse.etrice.core.genmodel.etricegen.Wire;
import org.eclipse.etrice.core.genmodel.etricegen.WiredSubSystemClass;
import org.eclipse.etrice.core.room.ActorRef;
import org.eclipse.etrice.core.room.RoomClass;
import org.eclipse.etrice.core.room.SubSystemClass;
import org.eclipse.etrice.generator.base.io.IGeneratorFileIO;
import org.eclipse.etrice.generator.cpp.Main;
import org.eclipse.etrice.generator.cpp.gen.CppExtensions;
import org.eclipse.etrice.generator.cpp.gen.Initialization;
import org.eclipse.etrice.generator.cpp.setup.GeneratorOptionsHelper;
import org.eclipse.etrice.generator.fsm.base.Indexed;
import org.eclipse.etrice.generator.generic.ProcedureHelpers;
import org.eclipse.etrice.generator.generic.RoomExtensions;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.xbase.lib.CollectionLiterals;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.ListExtensions;

@Singleton
public class NodeGen {
    @Inject
    @Extension
    private CppExtensions _cppExtensions;
    @Inject
    @Extension
    private RoomExtensions _roomExtensions;
    @Inject
    @Extension
    private ProcedureHelpers _procedureHelpers;
    @Inject
    @Extension
    private GeneratorOptionsHelper _generatorOptionsHelper;
    @Inject
    private IGeneratorFileIO fileIO;
    @Inject
    private Initialization initHelper;

    public void doGenerate(Root root) {
        final HashMap sscc2wired = CollectionLiterals.newHashMap();
        Consumer<WiredSubSystemClass> consumer = new Consumer<WiredSubSystemClass>(){

            @Override
            public void accept(WiredSubSystemClass it) {
                sscc2wired.put(it.getSubSystemClass(), it);
            }
        };
        Iterables.filter((Iterable)root.getWiredInstances(), WiredSubSystemClass.class).forEach(consumer);
        Collection collection = ETMapUtil.getNodeRefs();
        for (NodeRef nr : collection) {
            List list = ETMapUtil.getSubSystemInstancePaths((NodeRef)nr);
            for (String instpath : list) {
                StructureInstance structureInstance = root.getInstance(instpath);
                SubSystemInstance ssi = (SubSystemInstance)structureInstance;
                if (ssi == null) continue;
                WiredSubSystemClass wired = (WiredSubSystemClass)sscc2wired.get(ssi.getSubSystemClass());
                String path = this._roomExtensions.getPath((RoomClass)ssi.getSubSystemClass());
                Set usedThreads = ETMapUtil.getUsedThreads((NodeRef)nr, (SubSystemInstance)ssi);
                String string = this._cppExtensions.getCppHeaderFileName(nr, ssi);
                String string2 = String.valueOf(path) + string;
                this.fileIO.generateFile("generating Node declaration", string2, this.generateHeaderFile(root, ssi, wired, usedThreads));
                String string3 = this._cppExtensions.getCppSourceFileName(nr, ssi);
                String string4 = String.valueOf(path) + string3;
                this.fileIO.generateFile("generating Node implementation", string4, this.generateSourceFile(root, ssi, wired, usedThreads));
            }
        }
    }

    public CharSequence generateHeaderFile(Root root, SubSystemInstance comp, WiredSubSystemClass wired, final Collection<PhysicalThread> usedThreads) {
        Object object;
        StringConcatenation stringConcatenation = null;
        SubSystemClass cc = comp.getSubSystemClass();
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)comp);
        String clsname = this._cppExtensions.getCppClassName(nr, comp);
        Functions.Function1<PhysicalThread, Boolean> function1 = new Functions.Function1<PhysicalThread, Boolean>(){

            public Boolean apply(PhysicalThread t) {
                return usedThreads.contains(t);
            }
        };
        Iterable threads = IterableExtensions.filter((Iterable)nr.getType().getThreads(), (Functions.Function1)function1);
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/**");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* @author generated by eTrice");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* Header File of SubSystemClass ");
        stringConcatenation2.append(clsname, " ");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        CharSequence charSequence = this._cppExtensions.generateIncludeGuardBegin((RoomClass)cc, "");
        stringConcatenation2.append((Object)charSequence);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"common/messaging/IMessageService.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"common/modelbase/SubSystemClassBase.h\"");
        stringConcatenation2.newLine();
        Object object2 = comp.getActorInstances();
        for (ActorInstance ai : object2) {
            stringConcatenation2.append("#include \"");
            object = this._cppExtensions.getActorIncludePath(ai.getActorClass());
            stringConcatenation2.append((String)object);
            stringConcatenation2.append("\"");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        object2 = this._procedureHelpers.userCode(cc.getUserCode1());
        stringConcatenation2.append(object2);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        String string = this._cppExtensions.generateNamespaceBegin((RoomClass)cc);
        stringConcatenation2.append(string);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("class ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append(" : public etRuntime::SubSystemClassBase{");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        CharSequence charSequence2 = this._procedureHelpers.userCode(cc.getUserCode2());
        stringConcatenation2.append((Object)charSequence2, "\t");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("public:");
        stringConcatenation2.newLine();
        object = Indexed.indexed((Iterable)threads);
        Object object3 = object.iterator();
        while (object3.hasNext()) {
            Indexed thread = (Indexed)object3.next();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("static const int ");
            String string2 = this.getThreadId((PhysicalThread)thread.getValue());
            stringConcatenation2.append(string2, "\t\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.append("\t\t");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("// sub actors");
        stringConcatenation2.newLine();
        object = cc.getActorRefs();
        object3 = object.iterator();
        while (object3.hasNext()) {
            String string3;
            String string4;
            boolean bl;
            ActorRef sub = (ActorRef)object3.next();
            int n = sub.getMultiplicity();
            boolean bl2 = bl = n > 1;
            if (bl) {
                stringConcatenation2.append("\t\t");
                stringConcatenation2.append("Replicated");
                string4 = this._cppExtensions.getImplementationClassName(sub.getType());
                stringConcatenation2.append(string4, "\t\t");
                stringConcatenation2.append(" ");
                string3 = sub.getName();
                stringConcatenation2.append(string3, "\t\t");
                stringConcatenation2.append(";");
                stringConcatenation2.newLineIfNotEmpty();
                continue;
            }
            stringConcatenation2.append("\t\t");
            string4 = this._cppExtensions.getImplementationClassName(sub.getType());
            stringConcatenation2.append(string4, "\t\t");
            stringConcatenation2.append(" ");
            string3 = sub.getName();
            stringConcatenation2.append(string3, "\t\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append(clsname, "\t\t");
        stringConcatenation2.append("(IRTObject* parent, const String& name);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("~");
        stringConcatenation2.append(clsname, "\t\t");
        stringConcatenation2.append("();");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("virtual void receiveEvent(etRuntime::InterfaceItemBase* ifitem, int evt, void* data);");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("virtual void instantiateMessageServices();");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("virtual void mapThreads(void);");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("virtual void initialize(void);");
        stringConcatenation2.newLine();
        boolean bl = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (bl) {
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("virtual void setProbesActive(bool recursive, bool active);");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("virtual void init();");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        bl = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (bl) {
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("etBool hasGeneratedMSCInstrumentation() const { return true; }");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("virtual void destroy();");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("private:");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append("// MessageServices");
        stringConcatenation2.newLine();
        for (PhysicalThread thread_1 : threads) {
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("IMessageService* msgSvc_");
            object3 = thread_1.getName();
            stringConcatenation2.append((String)object3, "\t\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append(clsname, "\t\t");
        stringConcatenation2.append("();");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append(clsname, "\t\t");
        stringConcatenation2.append("(");
        stringConcatenation2.append(clsname, "\t\t");
        stringConcatenation2.append(" const&);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t");
        stringConcatenation2.append(clsname, "\t\t");
        stringConcatenation2.append("& operator=(");
        stringConcatenation2.append(clsname, "\t\t");
        stringConcatenation2.append(" const&);");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("};");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        String string5 = this._cppExtensions.generateNamespaceEnd((RoomClass)cc);
        stringConcatenation2.append(string5);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        CharSequence charSequence3 = this._cppExtensions.generateIncludeGuardEnd((RoomClass)cc, "");
        stringConcatenation2.append((Object)charSequence3);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }

    private String getThreadId(PhysicalThread thread) {
        String string = thread.getName().toUpperCase();
        return "THREAD_" + string;
    }

    private CharSequence generateConstructorInitalizerList(SubSystemClass cc) {
        CharSequence charSequence = null;
        Initialization initHelper = this.initHelper;
        ArrayList initList = CollectionLiterals.newArrayList();
        StringConcatenation stringConcatenation = new StringConcatenation();
        stringConcatenation.append("SubSystemClassBase(parent, name)");
        initList.add(stringConcatenation.toString());
        Functions.Function1<ActorRef, String> function1 = new Functions.Function1<ActorRef, String>(){

            public String apply(ActorRef it) {
                StringConcatenation stringConcatenation = new StringConcatenation();
                String string = it.getName();
                stringConcatenation.append(string);
                stringConcatenation.append("(this, \"");
                String string2 = it.getName();
                stringConcatenation.append(string2);
                stringConcatenation.append("\")");
                return stringConcatenation.toString();
            }
        };
        List list = ListExtensions.map((List)cc.getActorRefs(), (Functions.Function1)function1);
        Iterables.addAll((Collection)initList, (Iterable)list);
        charSequence = initHelper.generateCtorInitializerList(initList);
        return charSequence;
    }

    public CharSequence generateSourceFile(Root root, SubSystemInstance comp, WiredSubSystemClass wired, final Collection<PhysicalThread> usedThreads) {
        String string;
        int n;
        String string2;
        int n2;
        Object sub2;
        int n3;
        Object object;
        StringConcatenation stringConcatenation = null;
        SubSystemClass cc = comp.getSubSystemClass();
        NodeRef nr = ETMapUtil.getNodeRef((AbstractInstance)comp);
        String clsname = this._cppExtensions.getCppClassName(nr, comp);
        Functions.Function1<PhysicalThread, Boolean> function1 = new Functions.Function1<PhysicalThread, Boolean>(){

            public Boolean apply(PhysicalThread t) {
                return usedThreads.contains(t);
            }
        };
        Iterable threads = IterableExtensions.filter((Iterable)nr.getType().getThreads(), (Functions.Function1)function1);
        StringConcatenation stringConcatenation2 = new StringConcatenation();
        stringConcatenation2.append("/**");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* @author generated by eTrice");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("* Source File of SubsystemClass ");
        stringConcatenation2.append(clsname, " ");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*");
        stringConcatenation2.newLine();
        stringConcatenation2.append(" ");
        stringConcatenation2.append("*/");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"");
        String string3 = this._cppExtensions.getCppHeaderFileName(nr, comp);
        stringConcatenation2.append(string3);
        stringConcatenation2.append("\"");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"common/debugging/DebuggingService.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"common/debugging/MSCFunctionObject.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"common/messaging/IMessageService.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"common/messaging/MessageService.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"common/messaging/MessageServiceController.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"common/messaging/RTServices.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"common/messaging/StaticMessageMemory.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.append("#include \"common/modelbase/InterfaceItemBase.h\"");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("using namespace etRuntime;");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        String string4 = this._cppExtensions.generateNamespaceBegin((RoomClass)cc);
        stringConcatenation2.append(string4);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        Object object2 = Indexed.indexed((Iterable)threads);
        EList eList = object2.iterator();
        while (eList.hasNext()) {
            Indexed thread = (Indexed)eList.next();
            stringConcatenation2.append("const int ");
            stringConcatenation2.append(clsname);
            stringConcatenation2.append("::");
            object = this.getThreadId((PhysicalThread)thread.getValue());
            stringConcatenation2.append((String)object);
            stringConcatenation2.append(" = ");
            n3 = thread.getIndex0();
            stringConcatenation2.append((Object)n3);
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("::");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("(IRTObject* parent, const String& name)");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t\t");
        object2 = this.generateConstructorInitalizerList(cc);
        stringConcatenation2.append(object2, "\t\t");
        stringConcatenation2.newLineIfNotEmpty();
        for (PhysicalThread thread_522 : threads) {
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append(", msgSvc_");
            object = thread_522.getName();
            stringConcatenation2.append((String)object, "\t\t");
            stringConcatenation2.append("(NULL)");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.append("{");
        stringConcatenation2.newLine();
        boolean thread_522 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (thread_522) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("MSCFunctionObject mscFunctionObject(getInstancePathName(), \"Constructor\");");
            stringConcatenation2.newLine();
        }
        EList thread_522 = cc.getActorRefs();
        for (Object sub2 : thread_522) {
            n3 = sub2.getMultiplicity();
            int n4 = n2 = n3 > 1 ? 1 : 0;
            if (n2 == 0) continue;
            stringConcatenation2.append("\t");
            string2 = sub2.getName();
            stringConcatenation2.append(string2, "\t");
            stringConcatenation2.append(".createSubActors(");
            n = sub2.getMultiplicity();
            stringConcatenation2.append((Object)n, "\t");
            stringConcatenation2.append(");");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("::~");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("() {");
        stringConcatenation2.newLineIfNotEmpty();
        boolean thread_522 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (thread_522) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("MSCFunctionObject mscFunctionObject(getInstancePathName(), \"Destructor\");");
            stringConcatenation2.newLine();
        }
        for (PhysicalThread thread_2 : threads) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("delete msgSvc_");
            object = thread_2.getName();
            stringConcatenation2.append((String)object, "\t");
            stringConcatenation2.append(";");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("::receiveEvent(InterfaceItemBase* ifitem, int evt, void* data){");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("::instantiateMessageServices(){");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        boolean bl = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (bl) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("MSCFunctionObject mscFunctionObject(getInstancePathName(), \"instantiateMessageServices()\");");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("IMessageMemory* msgMemory;");
        stringConcatenation2.newLine();
        Functions.Function1<PhysicalThread, Long> function12 = new Functions.Function1<PhysicalThread, Long>(){

            public Long apply(PhysicalThread it) {
                long l = it.getPrio();
                return -l;
            }
        };
        sub2 = IterableExtensions.sortBy((Iterable)threads, (Functions.Function1)function12);
        Object object3 = sub2.iterator();
        while (object3.hasNext()) {
            PhysicalThread thread_3 = (PhysicalThread)object3.next();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("{");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("msgMemory = new StaticMessageMemory(this, \"MessageMemory_");
            String string5 = thread_3.getName();
            stringConcatenation2.append(string5, "\t\t");
            stringConcatenation2.append("\", ");
            int n5 = thread_3.getMsgblocksize();
            stringConcatenation2.append((Object)n5, "\t\t");
            stringConcatenation2.append(", ");
            n = thread_3.getMsgpoolsize();
            stringConcatenation2.append((Object)n, "\t\t");
            stringConcatenation2.append(");");
            stringConcatenation2.newLineIfNotEmpty();
            if (Objects.equal((Object)thread_3.getExecmode(), (Object)ExecMode.POLLED) || Objects.equal((Object)thread_3.getExecmode(), (Object)ExecMode.MIXED)) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("etTime interval;");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("interval.sec = ");
                long l = TimeConverter.split((long)thread_3.getTime(), (String)"s", (boolean)true);
                stringConcatenation2.append((Object)l, "\t\t");
                stringConcatenation2.append(";");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("interval.nSec = ");
                long l2 = TimeConverter.split((long)thread_3.getTime(), (String)"ms", (boolean)false);
                stringConcatenation2.append((Object)l2, "\t\t");
                stringConcatenation2.append("L;");
                stringConcatenation2.newLineIfNotEmpty();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("msgSvc_");
                String string6 = thread_3.getName();
                stringConcatenation2.append(string6, "\t\t");
                stringConcatenation2.append(" = new MessageService(this, IMessageService::");
                String string7 = thread_3.getExecmode().getName();
                stringConcatenation2.append(string7, "\t\t");
                stringConcatenation2.append(", interval, 0, ");
                String string8 = this.getThreadId(thread_3);
                stringConcatenation2.append(string8, "\t\t");
                stringConcatenation2.append(", \"MessageService_");
                String string9 = thread_3.getName();
                stringConcatenation2.append(string9, "\t\t");
                stringConcatenation2.append("\", msgMemory, ");
                long l3 = thread_3.getPrio();
                stringConcatenation2.append((Object)l3, "\t\t");
                stringConcatenation2.append(");");
                stringConcatenation2.newLineIfNotEmpty();
            } else {
                stringConcatenation2.append("\t");
                stringConcatenation2.append("\t");
                stringConcatenation2.append("msgSvc_");
                string = thread_3.getName();
                stringConcatenation2.append(string, "\t\t");
                stringConcatenation2.append(" = new MessageService(this, IMessageService::");
                String string10 = thread_3.getExecmode().getName();
                stringConcatenation2.append(string10, "\t\t");
                stringConcatenation2.append(", 0, ");
                String string11 = this.getThreadId(thread_3);
                stringConcatenation2.append(string11, "\t\t");
                stringConcatenation2.append(", \"MessageService_");
                String string12 = thread_3.getName();
                stringConcatenation2.append(string12, "\t\t");
                stringConcatenation2.append("\", msgMemory, ");
                long l = thread_3.getPrio();
                stringConcatenation2.append((Object)l, "\t\t");
                stringConcatenation2.append(");");
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.append("\t");
            stringConcatenation2.append("\t");
            stringConcatenation2.append("RTServices::getInstance().getMsgSvcCtrl().addMsgSvc(*msgSvc_");
            string = thread_3.getName();
            stringConcatenation2.append(string, "\t\t");
            stringConcatenation2.append(");");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("::mapThreads() {");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("// thread mappings");
        stringConcatenation2.newLine();
        function12 = comp.getAllContainedInstances();
        for (ActorInstance ai : function12) {
            stringConcatenation2.append("\t");
            ETMapUtil.MappedThread mapped = ETMapUtil.getMappedThread((AbstractInstance)ai);
            stringConcatenation2.newLineIfNotEmpty();
            int n6 = n2 = mapped.isImplicit() || mapped.isAsParent() ? 0 : 1;
            if (n2 == 0) continue;
            stringConcatenation2.append("\t");
            stringConcatenation2.append("addPathToThread(\"");
            string2 = ai.getPath();
            stringConcatenation2.append(string2, "\t");
            stringConcatenation2.append("\", ");
            String string13 = this.getThreadId(mapped.getThread());
            stringConcatenation2.append(string13, "\t");
            stringConcatenation2.append(");");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("::initialize() {");
        stringConcatenation2.newLineIfNotEmpty();
        boolean bl2 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (bl2) {
            ActorInstance ai;
            stringConcatenation2.append("\t");
            stringConcatenation2.append("DebuggingService::getInstance().getSyncLogger().addVisibleComment(\"starting initialization\");");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("MSCFunctionObject mscFunctionObject(getInstancePathName(), \"initialize()\");");
            stringConcatenation2.newLine();
            ai = cc.getActorRefs();
            for (Iterator sub_1 : ai) {
                boolean bl3;
                n2 = sub_1.getMultiplicity();
                boolean bl4 = bl3 = n2 > 1;
                if (bl3) {
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("for (int i=0; i<");
                    int n7 = sub_1.getMultiplicity();
                    stringConcatenation2.append((Object)n7, "\t");
                    stringConcatenation2.append("; ++i) {");
                    stringConcatenation2.newLineIfNotEmpty();
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("DebuggingService::getInstance().addMessageActorCreate(*this, ");
                    string = sub_1.getName();
                    stringConcatenation2.append(string, "\t\t");
                    stringConcatenation2.append(".getSubActor(i)->getName());");
                    stringConcatenation2.newLineIfNotEmpty();
                    stringConcatenation2.append("\t");
                    stringConcatenation2.append("}");
                    stringConcatenation2.newLine();
                    continue;
                }
                stringConcatenation2.append("\t");
                stringConcatenation2.append("DebuggingService::getInstance().addMessageActorCreate(*this, \"");
                String string14 = sub_1.getName();
                stringConcatenation2.append(string14, "\t");
                stringConcatenation2.append("\");");
                stringConcatenation2.newLineIfNotEmpty();
            }
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("// wiring");
        stringConcatenation2.newLine();
        EList eList2 = wired.getWires();
        for (Wire wire : eList2) {
            stringConcatenation2.append("\t");
            object3 = null;
            n2 = wire.isDataDriven() ? 1 : 0;
            object3 = n2 != 0 ? "DataPortBase" : "InterfaceItemBase";
            stringConcatenation2.append((String)object3, "\t");
            stringConcatenation2.append("::connect(this, \"");
            String string15 = IterableExtensions.join((Iterable)wire.getPath1(), (CharSequence)"/");
            stringConcatenation2.append(string15, "\t");
            stringConcatenation2.append("\", \"");
            String string16 = IterableExtensions.join((Iterable)wire.getPath2(), (CharSequence)"/");
            stringConcatenation2.append(string16, "\t");
            stringConcatenation2.append("\");");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.append("\t");
        stringConcatenation2.newLine();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("// call initialize of sub actors");
        stringConcatenation2.newLine();
        eList2 = cc.getActorRefs();
        for (ActorRef sub_2 : eList2) {
            stringConcatenation2.append("\t");
            object3 = sub_2.getName();
            stringConcatenation2.append((String)object3, "\t");
            stringConcatenation2.append(".initialize();");
            stringConcatenation2.newLineIfNotEmpty();
        }
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        stringConcatenation2.newLine();
        boolean bl5 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (bl5) {
            stringConcatenation2.append("void ");
            stringConcatenation2.append(clsname);
            stringConcatenation2.append("::setProbesActive(bool recursive, bool active) {");
            stringConcatenation2.newLineIfNotEmpty();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("for(int i = 0; i < m_RTSystemPort.getNInterfaceItems(); i++)");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t\t");
            stringConcatenation2.append("DebuggingService::getInstance().addPortInstance(*(m_RTSystemPort.getInterfaceItem(i)));");
            stringConcatenation2.newLine();
            stringConcatenation2.append("\t");
            stringConcatenation2.append("if(recursive) {");
            stringConcatenation2.newLine();
            eList = cc.getActorRefs();
            for (ActorRef sub_3 : eList) {
                stringConcatenation2.append("\t\t");
                String string17 = sub_3.getName();
                stringConcatenation2.append(string17, "\t\t");
                stringConcatenation2.append(".setProbesActive(recursive, active);");
                stringConcatenation2.newLineIfNotEmpty();
            }
            stringConcatenation2.append("\t");
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.newLine();
        stringConcatenation2.append("void ");
        stringConcatenation2.append(clsname);
        stringConcatenation2.append("::init(){");
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.append("\t");
        stringConcatenation2.append("SubSystemClassBase::init();");
        stringConcatenation2.newLine();
        bl5 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (bl5) {
            stringConcatenation2.append("\t");
            stringConcatenation2.append("DebuggingService::getInstance().addVisibleComment(\"done sub system initialization\");");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.append("}");
        stringConcatenation2.newLine();
        bl5 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
        if (bl5) {
            stringConcatenation2.newLine();
            stringConcatenation2.append("void ");
            stringConcatenation2.append(clsname);
            stringConcatenation2.append("::destroy() {");
            stringConcatenation2.newLineIfNotEmpty();
            boolean bl6 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
            if (bl6) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append("DebuggingService::getInstance().getSyncLogger().addVisibleComment(\"starting destruction\");");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("MSCFunctionObject mscFunctionObject(getInstancePathName(), \"destroy()\");");
                stringConcatenation2.newLine();
                stringConcatenation2.append("\t");
                stringConcatenation2.append("DebuggingService::getInstance().addVisibleComment(\"begin sub system destruction\");");
                stringConcatenation2.newLine();
            }
            stringConcatenation2.append("\t");
            stringConcatenation2.append("SubSystemClassBase::destroy();");
            stringConcatenation2.newLine();
            bl6 = this._generatorOptionsHelper.isGenerateMSCInstrumentation(Main.getSettings());
            if (bl6) {
                stringConcatenation2.append("\t");
                stringConcatenation2.append("DebuggingService::getInstance().addVisibleComment(\"done sub system destruction\");");
                stringConcatenation2.newLine();
            }
            stringConcatenation2.append("}");
            stringConcatenation2.newLine();
        }
        stringConcatenation2.newLine();
        String string18 = this._cppExtensions.generateNamespaceEnd((RoomClass)cc);
        stringConcatenation2.append(string18);
        stringConcatenation2.newLineIfNotEmpty();
        stringConcatenation2.newLine();
        stringConcatenation = stringConcatenation2;
        return stringConcatenation;
    }
}

