/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.gemini.web.tomcat.internal.bundleresources;

import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.catalina.LifecycleException;
import org.apache.catalina.WebResource;
import org.apache.catalina.WebResourceRoot;
import org.apache.catalina.util.ResourceSet;
import org.apache.catalina.webresources.EmptyResource;
import org.eclipse.gemini.web.tomcat.internal.bundleresources.AbstractReadOnlyResourceSet;
import org.eclipse.gemini.web.tomcat.internal.bundleresources.BundleWebResource;

final class BundleWebResourceSet
extends AbstractReadOnlyResourceSet {
    private final WebResource bundleEntry;

    BundleWebResourceSet(WebResource bundleEntry, WebResourceRoot root, String webAppMount, String base, String internalPath) {
        this.setRoot(root);
        this.setWebAppMount(webAppMount);
        this.setBase(base);
        this.setInternalPath(internalPath);
        this.bundleEntry = bundleEntry;
        if (this.getRoot().getState().isAvailable()) {
            try {
                this.start();
            }
            catch (LifecycleException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public WebResource getResource(String path) {
        WebResource bundleEntry;
        Map.Entry<BundleWebResource, URL> entry;
        this.checkPath(path);
        String webAppMount = this.getWebAppMount();
        WebResourceRoot root = this.getRoot();
        if (path.startsWith(webAppMount) && (entry = this.getNamedEntry(path.substring(webAppMount.length()))) != null && (bundleEntry = (WebResource)entry.getKey()) != null) {
            return bundleEntry;
        }
        return new EmptyResource(root, path);
    }

    public String[] list(String path) {
        this.checkPath(path);
        String webAppMount = this.getWebAppMount();
        if (path.startsWith(webAppMount)) {
            List<BundleWebResource> list;
            BundleWebResource bundleEntry;
            Map.Entry<BundleWebResource, URL> entry = this.getNamedEntry(path.substring(webAppMount.length()));
            if (entry != null && (bundleEntry = entry.getKey()) != null && (list = bundleEntry.list()) != null) {
                ArrayList<String> resources = new ArrayList<String>();
                for (BundleWebResource resource : list) {
                    resources.add(resource.getName());
                }
                return resources.toArray(new String[resources.size()]);
            }
        } else {
            if (!path.endsWith("/")) {
                path = String.valueOf(path) + "/";
            }
            if (webAppMount.startsWith(path)) {
                int i = webAppMount.indexOf(47, path.length());
                if (i == -1) {
                    return new String[]{webAppMount.substring(path.length())};
                }
                return new String[]{webAppMount.substring(path.length(), i)};
            }
        }
        return new String[0];
    }

    public Set<String> listWebAppPaths(String path) {
        this.checkPath(path);
        String webAppMount = this.getWebAppMount();
        ResourceSet result = new ResourceSet();
        if (path.startsWith(webAppMount)) {
            List<BundleWebResource> list;
            BundleWebResource bundleEntry;
            Map.Entry<BundleWebResource, URL> entry = this.getNamedEntry(path.substring(webAppMount.length()));
            if (entry != null && (bundleEntry = entry.getKey()) != null && (list = bundleEntry.list()) != null) {
                for (BundleWebResource bEntry : list) {
                    StringBuilder sb = new StringBuilder(path);
                    if (path.charAt(path.length() - 1) != '/') {
                        sb.append('/');
                    }
                    sb.append(bEntry.getName());
                    if (bEntry.isDirectory()) {
                        sb.append('/');
                    }
                    result.add((Object)sb.toString());
                }
            }
        } else {
            if (!path.endsWith("/")) {
                path = String.valueOf(path) + "/";
            }
            if (webAppMount.startsWith(path)) {
                int i = webAppMount.indexOf(47, path.length());
                if (i == -1) {
                    result.add((Object)(String.valueOf(webAppMount) + "/"));
                } else {
                    result.add((Object)webAppMount.substring(0, i + 1));
                }
            }
        }
        result.setLocked(true);
        return result;
    }

    public URL getBaseUrl() {
        return this.bundleEntry.getURL();
    }

    protected void initInternal() throws LifecycleException {
    }

    private Map.Entry<BundleWebResource, URL> getNamedEntry(String name) {
        return ((BundleWebResource)this.bundleEntry).getNamedEntry(name);
    }

    public void gc() {
    }
}

