/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hawk.sqlite.timeaware;

import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.function.Function;
import org.eclipse.hawk.core.graph.IGraphEdge;
import org.eclipse.hawk.core.graph.IGraphNode;
import org.eclipse.hawk.core.graph.timeaware.ITimeAwareGraphNode;
import org.eclipse.hawk.sqlite.iteration.EndNodeEdgeIterable;
import org.eclipse.hawk.sqlite.iteration.StatementIterable;
import org.eclipse.hawk.sqlite.timeaware.TimeAwareSQLiteDatabase;
import org.eclipse.hawk.sqlite.timeaware.TimeAwareSQLiteEdge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TimeAwareSQLiteNode
implements ITimeAwareGraphNode {
    private static final Logger LOGGER = LoggerFactory.getLogger(TimeAwareSQLiteNode.class);
    private final TimeAwareSQLiteDatabase db;
    private final int id;
    private final long time;

    public TimeAwareSQLiteNode(TimeAwareSQLiteDatabase db, int nodeId, long time) {
        this.db = db;
        this.id = nodeId;
        this.time = time;
    }

    public Integer getId() {
        return this.id;
    }

    public Set<String> getPropertyKeys() {
        try {
            PreparedStatement stmt = this.db.getQueries().getNodePropKeysStatement(this.id, this.time);
            stmt.execute();
            return this.db.getConnection().getStrings(stmt);
        }
        catch (SQLException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return Collections.emptySet();
        }
    }

    public Object getProperty(String name) {
        try {
            PreparedStatement stmt = this.db.getQueries().getNodePropValueStatement(this.id, name, this.time);
            stmt.execute();
            return this.db.getConnection().getPropertyValue(stmt);
        }
        catch (IOException | ClassNotFoundException | SQLException e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public void setProperty(String name, Object value) {
        if (value == null) {
            this.removeProperty(name);
        } else {
            try {
                value = this.db.getConnection().preprocessPropertyValue(value);
                PreparedStatement stmt = this.db.getQueries().getUpsertNodePropStatement(this.id, name, value, this.time);
                int rows = stmt.executeUpdate();
                assert (rows == 1) : "One row should have been inserted or updated";
            }
            catch (IOException | SQLException ex) {
                LOGGER.error(ex.getMessage(), (Throwable)ex);
            }
        }
    }

    public Iterable<IGraphEdge> getEdges() {
        return new StatementIterable<IGraphEdge>(() -> this.db.getQueries().getEdgesStatement(this.id, this.time), rs -> {
            int edgeId = rs.getInt(1);
            int startId = rs.getInt(2);
            int endId = rs.getInt(3);
            String type = rs.getString(4);
            return new TimeAwareSQLiteEdge(this.db, edgeId, startId, endId, type, this.time);
        });
    }

    public Iterable<IGraphEdge> getEdgesWithType(String type) {
        return new StatementIterable<IGraphEdge>(() -> this.db.getQueries().getEdgesWithTypeStatement(type, this.id, this.time), rs -> {
            int edgeId = rs.getInt(1);
            int startId = rs.getInt(2);
            int endId = rs.getInt(3);
            return new TimeAwareSQLiteEdge(this.db, edgeId, startId, endId, type, this.time);
        });
    }

    public Iterable<IGraphEdge> getOutgoingWithType(String type) {
        return new StatementIterable<IGraphEdge>(() -> this.db.getQueries().getOutgoingEdgesWithTypeStatement(type, this.id, this.time), rs -> {
            int edgeId = rs.getInt(1);
            int endId = rs.getInt(2);
            return new TimeAwareSQLiteEdge(this.db, edgeId, this.id, endId, type, this.time);
        });
    }

    public Iterable<IGraphEdge> getOutgoingWithType(String type, Iterable<IGraphNode> endNodes) {
        Function<IGraphNode, IGraphEdge> endNodeToEdge = node -> {
            try {
                PreparedStatement stmt = this.db.getQueries().getOutgoingEdgesWithTypeAndNodeStatement(type, this.id, (Integer)node.getId());
                Throwable throwable = null;
                Object var5_7 = null;
                try (ResultSet rs = stmt.executeQuery();){
                    if (rs.next()) {
                        int edgeId = rs.getInt(1);
                        int endId = rs.getInt(2);
                        return new TimeAwareSQLiteEdge(this.db, edgeId, this.id, endId, type, this.time);
                    }
                }
                catch (Throwable throwable2) {
                    if (throwable == null) {
                        throwable = throwable2;
                    } else if (throwable != throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
            }
            catch (SQLException e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
            }
            return null;
        };
        return new EndNodeEdgeIterable(endNodes, endNodeToEdge);
    }

    public Iterable<IGraphEdge> getOutgoingWithTypeBetween(String type, long fromInclusive, long toInclusive) throws Exception {
        return new StatementIterable<IGraphEdge>(() -> this.db.getQueries().getOutgoingEdgesWithTypeBetweenStatement(type, this.id, fromInclusive, toInclusive + 1L), rs -> {
            int edgeId = rs.getInt(1);
            int endId = rs.getInt(2);
            long validFrom = rs.getLong(3);
            return new TimeAwareSQLiteEdge(this.db, edgeId, this.id, endId, type, validFrom);
        });
    }

    public Iterable<IGraphEdge> getIncomingWithTypeBetween(String type, long fromInclusive, long toInclusive) throws Exception {
        return new StatementIterable<IGraphEdge>(() -> this.db.getQueries().getIncomingEdgesWithTypeBetweenStatement(type, this.id, fromInclusive, toInclusive + 1L), rs -> {
            int edgeId = rs.getInt(1);
            int startId = rs.getInt(2);
            long validFrom = rs.getLong(3);
            return new TimeAwareSQLiteEdge(this.db, edgeId, startId, this.id, type, validFrom);
        });
    }

    public Iterable<IGraphEdge> getOutgoingWithTypeCreatedBetween(String type, long fromInclusive, long toInclusive) throws Exception {
        return new StatementIterable<IGraphEdge>(() -> this.db.getQueries().getOutgoingEdgesWithTypeCreatedBetweenStatement(type, this.id, fromInclusive, toInclusive + 1L), rs -> {
            int edgeId = rs.getInt(1);
            int endId = rs.getInt(2);
            long validFrom = rs.getLong(3);
            return new TimeAwareSQLiteEdge(this.db, edgeId, this.id, endId, type, validFrom);
        });
    }

    public Iterable<IGraphEdge> getIncomingWithTypeCreatedBetween(String type, long fromInclusive, long toInclusive) throws Exception {
        return new StatementIterable<IGraphEdge>(() -> this.db.getQueries().getIncomingEdgesWithTypeCreatedBetweenStatement(type, this.id, fromInclusive, toInclusive + 1L), rs -> {
            int edgeId = rs.getInt(1);
            int startId = rs.getInt(2);
            long validFrom = rs.getLong(3);
            return new TimeAwareSQLiteEdge(this.db, edgeId, startId, this.id, type, validFrom);
        });
    }

    public Iterable<IGraphEdge> getIncomingWithType(String type) {
        return new StatementIterable<IGraphEdge>(() -> this.db.getQueries().getIncomingEdgesWithTypeStatement(type, this.id, this.time), rs -> {
            int edgeId = rs.getInt(1);
            int startId = rs.getInt(2);
            return new TimeAwareSQLiteEdge(this.db, edgeId, startId, this.id, type, this.time);
        });
    }

    public Iterable<IGraphEdge> getIncoming() {
        return new StatementIterable<IGraphEdge>(() -> this.db.getQueries().getIncomingEdgesStatement(this.id, this.time), rs -> {
            int edgeId = rs.getInt(1);
            int startId = rs.getInt(2);
            String type = rs.getString(3);
            return new TimeAwareSQLiteEdge(this.db, edgeId, startId, this.id, type, this.time);
        });
    }

    public Iterable<IGraphEdge> getOutgoing() {
        return new StatementIterable<IGraphEdge>(() -> this.db.getQueries().getOutgoingEdgesStatement(this.id, this.time), rs -> {
            int edgeId = rs.getInt(1);
            int endId = rs.getInt(2);
            String type = rs.getString(3);
            return new TimeAwareSQLiteEdge(this.db, edgeId, this.id, endId, type, this.time);
        });
    }

    public void delete() {
        try {
            this.db.getQueries().getDeleteNodePropsStatement(this.id, this.time).executeUpdate();
            this.db.getQueries().getDeleteEdgePropsForNodeStatement(this.id, this.time).executeUpdate();
            this.db.getQueries().getDeleteEdgesForNodeStatement(this.id, this.time).executeUpdate();
            this.db.getQueries().getDeleteNodeStatement(this.id, this.time).executeUpdate();
            for (String idxName : this.db.getNodeIndexNames()) {
                this.db.getOrCreateNodeIndex(idxName).travelInTime(this.time).remove((IGraphNode)this);
            }
        }
        catch (SQLException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public TimeAwareSQLiteDatabase getGraph() {
        return this.db;
    }

    public void removeProperty(String name) {
        try {
            PreparedStatement stmt = this.db.getQueries().getDeleteNodePropStatement(this.id, name, this.time);
            stmt.executeUpdate();
        }
        catch (SQLException ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
        }
    }

    public boolean isAlive() {
        try {
            PreparedStatement stmt = this.db.getQueries().getIsAliveStatement(this.id, this.time);
            Throwable throwable = null;
            Object var3_5 = null;
            try (ResultSet rs = stmt.executeQuery();){
                return rs.getBoolean(1);
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception ex) {
            LOGGER.error(ex.getMessage(), (Throwable)ex);
            return false;
        }
    }

    public long getTime() {
        return this.time;
    }

    public List<Long> getAllInstants() throws Exception {
        StatementIterable<Long> iterInstants = new StatementIterable<Long>(() -> this.getGraph().getQueries().getAllInstantsForNodeStatement(this.getId()), rs -> rs.getLong(1));
        ArrayList<Long> results = new ArrayList<Long>();
        iterInstants.forEach(results::add);
        return results;
    }

    public long getEarliestInstant() throws Exception {
        return this.getInstant(this.db.getQueries().getEarliestInstantStatement(this.id));
    }

    public long getPreviousInstant() throws Exception {
        return this.getInstant(this.db.getQueries().getPrevInstantStatement(this.id, this.time));
    }

    public long getLatestInstant() throws Exception {
        return this.getInstant(this.db.getQueries().getLatestInstantStatement(this.id));
    }

    public long getNextInstant() throws Exception {
        return this.getInstant(this.db.getQueries().getNextInstantStatement(this.id, this.time));
    }

    protected long getInstant(PreparedStatement stmt) throws SQLException {
        stmt.execute();
        Throwable throwable = null;
        Object var3_4 = null;
        try (ResultSet rs = stmt.getResultSet();){
            if (rs.next()) {
                return rs.getLong(1);
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return -1L;
    }

    public void end() {
        this.travelInTime(this.time + 1L).delete();
    }

    public ITimeAwareGraphNode travelInTime(long time) {
        if (time == -1L) {
            return null;
        }
        return new TimeAwareSQLiteNode(this.getGraph(), this.getId(), time);
    }

    public List<Long> getInstantsBetween(long fromInclusive, long toInclusive) {
        return this.getInstants(() -> this.db.getQueries().getInstantsBetweenStatement(this.id, fromInclusive, toInclusive));
    }

    public List<Long> getInstantsFrom(long fromInclusive) {
        return this.getInstants(() -> this.db.getQueries().getInstantsFromStatement(this.id, fromInclusive));
    }

    public List<Long> getInstantsUpTo(long toInclusive) {
        return this.getInstants(() -> this.db.getQueries().getInstantsUpToStatement(this.id, toInclusive));
    }

    protected List<Long> getInstants(Callable<PreparedStatement> supplier) {
        try {
            PreparedStatement stmt = supplier.call();
            Throwable throwable = null;
            Object var4_6 = null;
            try (ResultSet rs = stmt.executeQuery();){
                ArrayList<Long> results = new ArrayList<Long>();
                while (rs.next()) {
                    results.add(rs.getLong(1));
                }
                return results;
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
            return Collections.emptyList();
        }
    }

    public int hashCode() {
        return Objects.hash(this.id, this.time);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        TimeAwareSQLiteNode other = (TimeAwareSQLiteNode)obj;
        return this.id == other.id && this.time == other.time;
    }

    public String toString() {
        return "TimeAwareSQLiteNode [id=" + this.id + ", time=" + this.time + "]";
    }
}

