/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.cli;

import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.dns.AddressResolverOptions;
import org.eclipse.hono.client.ApplicationClientFactory;
import org.eclipse.hono.client.HonoConnection;
import org.eclipse.hono.config.ClientConfigProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class AppConfiguration {
    @Bean
    public Vertx vertx() {
        VertxOptions options = new VertxOptions().setWarningExceptionTime(1500000000L).setAddressResolverOptions(this.addressResolverOptions());
        return Vertx.vertx((VertxOptions)options);
    }

    @ConfigurationProperties(prefix="address.resolver")
    @Bean
    public AddressResolverOptions addressResolverOptions() {
        AddressResolverOptions addressResolverOptions = new AddressResolverOptions();
        return addressResolverOptions;
    }

    @ConfigurationProperties(prefix="hono.client")
    @Bean
    public ClientConfigProperties honoClientConfig() {
        ClientConfigProperties config = new ClientConfigProperties();
        return config;
    }

    @Bean
    public ApplicationClientFactory clientFactory() {
        return ApplicationClientFactory.create((HonoConnection)HonoConnection.newConnection((Vertx)this.vertx(), (ClientConfigProperties)this.honoClientConfig()));
    }
}

