/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.client.command;

import io.vertx.core.Context;
import io.vertx.core.Future;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import org.eclipse.hono.client.command.CommandContext;
import org.eclipse.hono.client.command.CommandHandlerWrapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommandHandlers {
    protected static final Logger LOG = LoggerFactory.getLogger(CommandHandlers.class);
    private final Map<String, CommandHandlerWrapper> commandHandlers = new HashMap<String, CommandHandlerWrapper>();

    public CommandHandlerWrapper putCommandHandler(String tenantId, String deviceId, String gatewayId, Function<CommandContext, Future<Void>> commandHandler, Context context) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        Objects.requireNonNull(commandHandler);
        return this.putCommandHandler(new CommandHandlerWrapper(tenantId, deviceId, gatewayId, commandHandler, context, null));
    }

    public CommandHandlerWrapper putCommandHandler(CommandHandlerWrapper commandHandlerWrapper) {
        Objects.requireNonNull(commandHandlerWrapper);
        String key = this.getDeviceKey(commandHandlerWrapper);
        if (this.commandHandlers.containsKey(key)) {
            LOG.debug("replacing existing command handler [tenant-id: {}, device-id: {}]", (Object)commandHandlerWrapper.getTenantId(), (Object)commandHandlerWrapper.getDeviceId());
        }
        return this.commandHandlers.put(key, commandHandlerWrapper);
    }

    public CommandHandlerWrapper getCommandHandler(String tenantId, String deviceId) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        return this.commandHandlers.get(this.getDeviceKey(tenantId, deviceId));
    }

    public Collection<CommandHandlerWrapper> getCommandHandlers() {
        return this.commandHandlers.values();
    }

    public boolean removeCommandHandler(String tenantId, String deviceId) {
        Objects.requireNonNull(tenantId);
        Objects.requireNonNull(deviceId);
        CommandHandlerWrapper removedHandler = this.commandHandlers.remove(this.getDeviceKey(tenantId, deviceId));
        LOG.trace("Removed handler for tenant {}, device {}: {}", tenantId, deviceId, removedHandler != null);
        return removedHandler != null;
    }

    public boolean removeCommandHandler(CommandHandlerWrapper commandHandlerWrapper) {
        Objects.requireNonNull(commandHandlerWrapper);
        boolean removed = this.commandHandlers.remove(this.getDeviceKey(commandHandlerWrapper), commandHandlerWrapper);
        LOG.trace("Removed {}: {}", (Object)commandHandlerWrapper, (Object)removed);
        return removed;
    }

    private String getDeviceKey(CommandHandlerWrapper commandHandlerWrapper) {
        return this.getDeviceKey(commandHandlerWrapper.getTenantId(), commandHandlerWrapper.getDeviceId());
    }

    private String getDeviceKey(String tenantId, String deviceId) {
        return String.format("%s/%s", tenantId, deviceId);
    }
}

