/*
 * Decompiled with CFR 0.152.
 */
package io.micrometer.core.instrument.binder.grpc;

import io.grpc.ClientCall;
import io.grpc.ForwardingClientCallListener;
import io.grpc.Metadata;
import io.grpc.Status;
import io.micrometer.core.instrument.binder.grpc.GrpcClientObservationContext;
import io.micrometer.core.instrument.binder.grpc.GrpcObservationDocumentation;
import io.micrometer.observation.Observation;

class ObservationGrpcClientCallListener<RespT>
extends ForwardingClientCallListener.SimpleForwardingClientCallListener<RespT> {
    private final Observation.Scope scope;

    ObservationGrpcClientCallListener(ClientCall.Listener<RespT> delegate, Observation.Scope scope) {
        super(delegate);
        this.scope = scope;
    }

    public void onClose(Status status, Metadata metadata) {
        Observation observation = this.scope.getCurrentObservation();
        GrpcClientObservationContext context = (GrpcClientObservationContext)observation.getContext();
        context.setStatusCode(status.getCode());
        if (status.getCause() != null) {
            observation.error(status.getCause());
        }
        this.scope.close();
        observation.stop();
        super.onClose(status, metadata);
    }

    public void onMessage(RespT message) {
        this.scope.getCurrentObservation().event(GrpcObservationDocumentation.GrpcClientEvents.MESSAGE_RECEIVED);
        super.onMessage(message);
    }
}

