/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.context.impl.wrappers;

import io.smallrye.context.impl.wrappers.ContextualFunction;
import java.util.function.Function;

public class ContextualFunctionN<T, R>
implements ContextualFunction<T, R> {
    private ThreadLocal<Object>[] tl;
    private Object[] state;
    private final Function<T, R> function;

    public ContextualFunctionN(Function<T, R> function, int n) {
        this.function = function;
        this.tl = new ThreadLocal[n];
        this.state = new Object[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public R apply(T t) {
        Object[] moved = new Object[this.tl.length];
        for (int i = 0; i < this.tl.length; ++i) {
            moved[i] = this.tl[i].get();
            this.tl[i].set(this.state[i]);
        }
        try {
            R r = this.function.apply(t);
            return r;
        }
        finally {
            for (int i = 0; i < this.tl.length; ++i) {
                this.tl[i].set(moved[i]);
            }
        }
    }

    @Override
    public void captureThreadLocal(int index, ThreadLocal<Object> threadLocal, Object value) {
        if (index < 0 || index >= this.state.length) {
            throw new IllegalArgumentException("Illegal index " + index);
        }
        this.tl[index] = threadLocal;
        this.state[index] = value;
    }
}

