/*
 * Decompiled with CFR 0.152.
 */
package io.smallrye.config;

import io.smallrye.config.PropertyName;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

class ConfigMappingNames {
    private final Map<String, Names> names;

    public ConfigMappingNames(Map<String, Map<String, Set<String>>> names) {
        this.names = new HashMap<String, Names>(names.size());
        for (Map.Entry<String, Map<String, Set<String>>> entry : names.entrySet()) {
            this.names.put(entry.getKey(), new Names(entry.getValue()));
        }
    }

    Set<PropertyName> get(String mapping, String name) {
        return this.names.get(mapping).get(name);
    }

    private static class Names {
        private final Map<PropertyName, Set<PropertyName>> names = new HashMap<PropertyName, Set<PropertyName>>();
        private final Map<PropertyName, Set<PropertyName>> anys = new HashMap<PropertyName, Set<PropertyName>>();

        Names(Map<String, Set<String>> names) {
            for (Map.Entry<String, Set<String>> entry : names.entrySet()) {
                if (entry.getKey().indexOf(42) == -1) {
                    this.names.put(new PropertyName(entry.getKey()), Names.toMappingNameSet(entry.getValue()));
                    continue;
                }
                this.anys.put(new PropertyName(entry.getKey()), Names.toMappingNameSet(entry.getValue()));
            }
        }

        Set<PropertyName> get(String name) {
            PropertyName mappingName = new PropertyName(name);
            return this.names.getOrDefault(mappingName, this.anys.get(mappingName));
        }

        private static Set<PropertyName> toMappingNameSet(Set<String> names) {
            HashSet<PropertyName> mappingNames = new HashSet<PropertyName>(names.size());
            for (String name : names) {
                mappingNames.add(new PropertyName(name));
            }
            return mappingNames;
        }
    }
}

