/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.hono.util;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import org.eclipse.hono.annotation.HonoTimestamp;
import org.eclipse.hono.util.LimitedResource;
import org.eclipse.hono.util.ResourceLimitsPeriod;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class ConnectionDuration
extends LimitedResource {
    private final long maxMinutes;

    public ConnectionDuration(@JsonProperty(value="effective-since", required=true) @HonoTimestamp Instant effectiveSince, @JsonProperty(value="period") ResourceLimitsPeriod period) {
        this(effectiveSince, period, -1L);
    }

    @JsonCreator
    public ConnectionDuration(@JsonProperty(value="effective-since", required=true) @HonoTimestamp Instant effectiveSince, @JsonProperty(value="period") ResourceLimitsPeriod period, @JsonProperty(value="max-minutes") long maxMinutes) {
        super(effectiveSince, period);
        if (maxMinutes < -1L) {
            throw new IllegalArgumentException(String.format("Maximum minutes must be set to value >= %s", -1L));
        }
        this.maxMinutes = maxMinutes;
    }

    @JsonProperty(value="max-minutes")
    public final long getMaxMinutes() {
        return this.maxMinutes;
    }

    @JsonIgnore
    public boolean isLimited() {
        return this.getMaxMinutes() != -1L && this.getPeriod().getMode() != ResourceLimitsPeriod.PeriodMode.unknown;
    }
}

