/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.querybasedfeatures.runtime;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.WeakHashMap;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.ECollections;
import org.eclipse.emf.ecore.EAnnotation;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.BasicSettingDelegate;
import org.eclipse.incquery.querybasedfeatures.runtime.QueryBasedFeatureSettingDelegate;
import org.eclipse.incquery.runtime.api.AdvancedIncQueryEngine;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.api.impl.BaseGeneratedEMFQuerySpecification;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.extensibility.QuerySpecificationRegistry;

public class QueryBasedFeatureSettingDelegateFactory
implements EStructuralFeature.Internal.SettingDelegate.Factory {
    private final Map<Notifier, WeakReference<AdvancedIncQueryEngine>> engineMap = new WeakHashMap<Notifier, WeakReference<AdvancedIncQueryEngine>>();
    private final Map<String, IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>> specificationMap = Maps.newHashMap();

    public Map<String, IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>>> getSpecificationMap() {
        return this.specificationMap;
    }

    protected AdvancedIncQueryEngine getEngineForNotifier(Notifier notifier, boolean dynamicEMFMode) throws IncQueryException {
        if (dynamicEMFMode) {
            WeakReference<AdvancedIncQueryEngine> reference = this.engineMap.get(notifier);
            if (reference != null && reference.get() != null) {
                return (AdvancedIncQueryEngine)reference.get();
            }
            AdvancedIncQueryEngine unmanagedEngine = AdvancedIncQueryEngine.createUnmanagedEngine((Notifier)notifier, (boolean)false, (boolean)dynamicEMFMode);
            this.engineMap.put(notifier, new WeakReference<AdvancedIncQueryEngine>(unmanagedEngine));
            return unmanagedEngine;
        }
        return AdvancedIncQueryEngine.from((IncQueryEngine)IncQueryEngine.on((Notifier)notifier));
    }

    public EStructuralFeature.Internal.SettingDelegate createSettingDelegate(EStructuralFeature eStructuralFeature) {
        EStructuralFeature.Internal.SettingDelegate result = null;
        IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>> querySpec = this.findQuerySpecification(eStructuralFeature);
        if (querySpec != null) {
            result = querySpec instanceof BaseGeneratedEMFQuerySpecification ? this.createSettingDelegate(eStructuralFeature, querySpec, false, false) : this.createSettingDelegate(eStructuralFeature, querySpec, true, true);
        } else {
            return new BasicSettingDelegate.Stateless(eStructuralFeature){

                protected boolean isSet(InternalEObject owner) {
                    return false;
                }

                protected Object get(InternalEObject owner, boolean resolve, boolean coreType) {
                    if (this.eStructuralFeature.isMany()) {
                        return ECollections.EMPTY_ELIST;
                    }
                    return null;
                }
            };
        }
        return result;
    }

    public IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>> findQuerySpecification(EStructuralFeature eStructuralFeature) {
        IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>> querySpec = null;
        EAnnotation annotation = eStructuralFeature.getEAnnotation("org.eclipse.incquery.querybasedfeature");
        if (annotation != null) {
            String patternFQN = (String)annotation.getDetails().get((Object)"patternFQN");
            querySpec = this.specificationMap.containsKey(patternFQN) ? this.specificationMap.get(patternFQN) : QuerySpecificationRegistry.getQuerySpecification((String)patternFQN);
        }
        return querySpec;
    }

    public EStructuralFeature.Internal.SettingDelegate createSettingDelegate(EStructuralFeature eStructuralFeature, IQuerySpecification<? extends IncQueryMatcher<? extends IPatternMatch>> querySpecification, boolean isResourceScope, boolean dynamicEMFMode) {
        Preconditions.checkArgument((querySpecification != null ? 1 : 0) != 0, (Object)"Query specification cannot be null!");
        return new QueryBasedFeatureSettingDelegate(eStructuralFeature, this, querySpecification, isResourceScope, dynamicEMFMode);
    }
}

