/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.validation.core;

import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.incquery.runtime.api.IMatchProcessor;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.emf.helper.IncQueryRuntimeHelper;
import org.eclipse.incquery.validation.core.Constraint;
import org.eclipse.incquery.validation.core.Violation;
import org.eclipse.incquery.validation.core.violationkey.ViolationKey;

public class MatchAppearanceJob
implements IMatchProcessor<IPatternMatch> {
    private Constraint constraint;
    private Logger logger;

    public MatchAppearanceJob(Constraint constraint, Logger logger) {
        this.constraint = constraint;
        this.logger = logger;
    }

    public void process(IPatternMatch match) {
        Map<String, Object> keyObjectMap = this.constraint.getSpecification().getKeyObjects(match);
        if (!keyObjectMap.isEmpty()) {
            ViolationKey key = this.constraint.getViolationKey(match);
            Violation violation = this.constraint.getViolation(key);
            if (violation == null) {
                violation = new Violation();
                violation.setConstraint(this.constraint);
                violation.setKeyObjects(this.constraint.getSpecification().getKeyObjects(match));
                violation.setMessage(IncQueryRuntimeHelper.getMessage((IPatternMatch)match, (String)this.constraint.getSpecification().getMessageFormat()));
                this.constraint.addViolation(key, violation);
                this.constraint.notifyListenersViolationAppeared(violation);
            }
            if (violation.addMatch(match)) {
                violation.notifyListenersViolationEntryAppeared(match);
            }
        } else {
            this.logger.error((Object)"Error getting Violation key objects!");
        }
    }
}

