/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.runtime.api.impl;

import java.util.List;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.exception.IncQueryException;
import org.eclipse.incquery.runtime.matchers.psystem.annotations.PAnnotation;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PParameter;
import org.eclipse.incquery.runtime.matchers.psystem.queries.PQuery;
import org.eclipse.incquery.runtime.matchers.psystem.queries.QueryInitializationException;

public abstract class BaseQuerySpecification<Matcher extends IncQueryMatcher<? extends IPatternMatch>>
implements IQuerySpecification<Matcher> {
    protected final PQuery wrappedPQuery;

    protected abstract Matcher instantiate(IncQueryEngine var1) throws IncQueryException;

    public BaseQuerySpecification(PQuery wrappedPQuery) {
        this.wrappedPQuery = wrappedPQuery;
        wrappedPQuery.publishedAs().add(this);
    }

    @Override
    public PQuery getInternalQueryRepresentation() {
        return this.wrappedPQuery;
    }

    @Override
    public Matcher getMatcher(Notifier emfRoot) throws IncQueryException {
        IncQueryEngine engine = IncQueryEngine.on(emfRoot);
        this.ensureInitializedInternal();
        return this.getMatcher(engine);
    }

    @Override
    public Matcher getMatcher(IncQueryEngine engine) throws IncQueryException {
        this.ensureInitializedInternal();
        if (engine.getScope().isCompatibleWithQueryScope(this.getPreferredScopeClass())) {
            return this.instantiate(engine);
        }
        throw new IncQueryException(String.format("Scope class incompatibility: the query %s is formulated over query scopes of class %s,  thus the query engine formulated over scope %s of class %s cannot evaluate it.", this.getFullyQualifiedName(), this.getPreferredScopeClass().getCanonicalName(), engine.getScope(), engine.getScope().getClass().getCanonicalName()), "Incompatible scope classes of engine and query.");
    }

    protected void ensureInitializedInternal() throws IncQueryException {
        try {
            this.wrappedPQuery.ensureInitialized();
        }
        catch (QueryInitializationException e) {
            throw new IncQueryException(e);
        }
    }

    protected void ensureInitializedInternalSneaky() {
        try {
            this.wrappedPQuery.ensureInitialized();
        }
        catch (QueryInitializationException e) {
            throw new RuntimeException(e);
        }
    }

    public List<PAnnotation> getAllAnnotations() {
        return this.wrappedPQuery.getAllAnnotations();
    }

    public List<PAnnotation> getAnnotationsByName(String annotationName) {
        return this.wrappedPQuery.getAnnotationsByName(annotationName);
    }

    public PAnnotation getFirstAnnotationByName(String annotationName) {
        return this.wrappedPQuery.getFirstAnnotationByName(annotationName);
    }

    public String getFullyQualifiedName() {
        return this.wrappedPQuery.getFullyQualifiedName();
    }

    public List<String> getParameterNames() {
        return this.wrappedPQuery.getParameterNames();
    }

    public List<PParameter> getParameters() {
        return this.wrappedPQuery.getParameters();
    }

    public Integer getPositionOfParameter(String parameterName) {
        return this.wrappedPQuery.getPositionOfParameter(parameterName);
    }
}

