/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.tooling.debug.variables.values;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.StringReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.incquery.runtime.util.IncQueryLoggingUtil;
import org.eclipse.incquery.tooling.debug.common.IncQueryDebugValue;
import org.eclipse.incquery.tooling.debug.common.IncQueryDebugVariable;
import org.eclipse.incquery.tooling.debug.variables.ValueWrapper;
import org.eclipse.incquery.tooling.debug.variables.values.MatchParameterValue;
import org.eclipse.jdt.debug.core.IJavaVariable;
import org.eclipse.jdt.internal.debug.core.model.JDIDebugTarget;

public class MatchValue
extends IncQueryDebugValue {
    public MatchValue(JDIDebugTarget debugTarget, ValueWrapper value, String ... additionalData) {
        super(debugTarget, value, additionalData);
    }

    @Override
    protected synchronized List<IJavaVariable> getVariablesList() throws DebugException {
        if (this.fVariables != null) {
            return this.fVariables;
        }
        try {
            this.fVariables = new ArrayList();
            ValueWrapper parameters = this.fValue.invoke("toArray");
            ValueWrapper parameterNames = this.fValue.invoke("parameterNames").invoke("toArray");
            if (parameterNames.isArray() && parameters.isArray()) {
                ArrayReference parametersArray = (ArrayReference)parameters.getValue();
                ArrayReference parameterNamesArray = (ArrayReference)parameterNames.getValue();
                int i = 0;
                while (i < parametersArray.length()) {
                    IncQueryDebugVariable var = new IncQueryDebugVariable(this.getJavaDebugTarget());
                    String parameterName = ((StringReference)parameterNamesArray.getValue(i)).value();
                    ValueWrapper wrappedParameter = ValueWrapper.wrap(parametersArray.getValue(i), this.fValue.getThreadReference());
                    MatchParameterValue value = new MatchParameterValue(this.debugTarget, wrappedParameter, parameterName);
                    var.setValue((IValue)value);
                    this.fVariables.add(var);
                    ++i;
                }
            }
            return this.fVariables;
        }
        catch (Exception e) {
            IncQueryLoggingUtil.getLogger(MatchValue.class).error((Object)"Couldn't retrieve the list of debug variables!", (Throwable)e);
            return Collections.emptyList();
        }
    }

    @Override
    public String getLabel() {
        return "match";
    }

    public String getValueString() throws DebugException {
        ValueWrapper value = this.fValue.invoke("prettyPrint");
        if (value.getValue() != null) {
            return ((StringReference)value.getValue()).value();
        }
        return super.getValueString();
    }
}

