/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.annotations;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.google.inject.Inject;
import com.google.inject.Injector;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.Platform;
import org.eclipse.incquery.patternlanguage.annotations.IPatternAnnotationAdditionalValidator;
import org.eclipse.incquery.patternlanguage.annotations.IPatternAnnotationValidator;
import org.eclipse.incquery.patternlanguage.annotations.impl.ExtensionBasedPatternAnnotationParameter;
import org.eclipse.incquery.patternlanguage.annotations.impl.ExtensionBasedPatternAnnotationValidator;
import org.eclipse.incquery.patternlanguage.patternLanguage.Annotation;
import org.eclipse.incquery.patternlanguage.patternLanguage.AnnotationParameter;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternLanguageFactory;

public class PatternAnnotationProvider {
    private static final String VALIDATOR_PARAMETER_NAME = "additionalValidator";
    @Inject
    private Logger log;
    @Inject
    private Injector injector;
    static final String EXTENSIONID = "org.eclipse.incquery.patternlanguage.annotation";
    private Map<String, IPatternAnnotationValidator> annotationValidators;

    protected void initializeValidators() {
        IConfigurationElement[] config;
        this.annotationValidators = new Hashtable<String, IPatternAnnotationValidator>();
        IConfigurationElement[] iConfigurationElementArray = config = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSIONID);
        int n = config.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement e = iConfigurationElementArray[n2];
            try {
                String annotationName = e.getAttribute("name");
                String description = e.getAttribute("description");
                String deprecatedString = e.getAttribute("deprecated");
                boolean deprecated = Boolean.parseBoolean(deprecatedString);
                IConfigurationElement[] parameters = e.getChildren("annotationparameter");
                IPatternAnnotationAdditionalValidator validator = null;
                Iterable parameterIterable = Iterables.transform(Arrays.asList(parameters), (Function)new ExtensionConverter());
                if (e.getAttribute(VALIDATOR_PARAMETER_NAME) != null) {
                    validator = (IPatternAnnotationAdditionalValidator)e.createExecutableExtension(VALIDATOR_PARAMETER_NAME);
                    this.injector.injectMembers((Object)validator);
                }
                ExtensionBasedPatternAnnotationValidator annotationValidator = new ExtensionBasedPatternAnnotationValidator(annotationName, description, deprecated, parameterIterable, validator);
                this.annotationValidators.put(annotationName, annotationValidator);
            }
            catch (CoreException ex) {
                this.log.error((Object)String.format("Error while initializing the validator for annotation %s.", e.getAttribute("name")), (Throwable)ex);
            }
            ++n2;
        }
    }

    public IPatternAnnotationValidator getValidator(String annotationName) {
        if (this.annotationValidators == null) {
            this.initializeValidators();
        }
        return this.annotationValidators.get(annotationName);
    }

    public Annotation getAnnotationObject(String annotationName) {
        Annotation annotation = PatternLanguageFactory.eINSTANCE.createAnnotation();
        annotation.setName(annotationName);
        return annotation;
    }

    public AnnotationParameter getAnnotationParameter(String annotationName, String parameterName) {
        Annotation annotation = this.getAnnotationObject(annotationName);
        return this.getAnnotationParameter(annotation, parameterName);
    }

    public AnnotationParameter getAnnotationParameter(Annotation annotation, String parameterName) {
        AnnotationParameter parameter = PatternLanguageFactory.eINSTANCE.createAnnotationParameter();
        parameter.setName(parameterName);
        annotation.getParameters().add((Object)parameter);
        return parameter;
    }

    public boolean hasValidator(String annotationName) {
        if (this.annotationValidators == null) {
            this.initializeValidators();
        }
        return this.annotationValidators.containsKey(annotationName);
    }

    public Set<String> getAllAnnotationNames() {
        if (this.annotationValidators == null) {
            this.initializeValidators();
        }
        return this.annotationValidators.keySet();
    }

    public Iterable<String> getAnnotationParameters(String annotationName) {
        if (this.annotationValidators == null) {
            this.initializeValidators();
        }
        return this.annotationValidators.get(annotationName).getAllAvailableParameterNames();
    }

    public String getDescription(Annotation annotation) {
        return this.getDescription(annotation.getName());
    }

    public String getDescription(String annotationName) {
        if (this.annotationValidators == null) {
            this.initializeValidators();
        }
        return this.annotationValidators.get(annotationName).getDescription();
    }

    public String getDescription(AnnotationParameter parameter) {
        Annotation annotation = (Annotation)parameter.eContainer();
        return this.getDescription(annotation.getName(), parameter.getName());
    }

    public String getDescription(String annotationName, String parameterName) {
        if (this.annotationValidators == null) {
            this.initializeValidators();
        }
        if (!this.annotationValidators.containsKey(annotationName)) {
            return "";
        }
        return this.annotationValidators.get(annotationName).getDescription(parameterName);
    }

    public boolean isDeprecated(Annotation annotation) {
        return this.isDeprecated(annotation.getName());
    }

    public boolean isDeprecated(String annotationName) {
        if (this.annotationValidators == null) {
            this.initializeValidators();
        }
        return this.annotationValidators.containsKey(annotationName) && this.annotationValidators.get(annotationName).isDeprecated();
    }

    public boolean isDeprecated(AnnotationParameter parameter) {
        Annotation annotation = (Annotation)parameter.eContainer();
        return this.isDeprecated(annotation.getName(), parameter.getName());
    }

    public boolean isDeprecated(String annotationName, String parameterName) {
        if (this.annotationValidators == null) {
            this.initializeValidators();
        }
        return this.annotationValidators.containsKey(annotationName) && this.annotationValidators.get(annotationName).isDeprecated(parameterName);
    }

    private static final class ExtensionConverter
    implements Function<IConfigurationElement, ExtensionBasedPatternAnnotationParameter> {
        private ExtensionConverter() {
        }

        public ExtensionBasedPatternAnnotationParameter apply(IConfigurationElement input) {
            Preconditions.checkNotNull((Object)input, (Object)"input");
            String parameterName = input.getAttribute("name");
            boolean mandatory = Boolean.parseBoolean(input.getAttribute("mandatory"));
            boolean multiple = Boolean.parseBoolean(input.getAttribute("multiple"));
            String deprecatedString = input.getAttribute("deprecated");
            boolean deprecated = Boolean.parseBoolean(deprecatedString);
            String type = input.getAttribute("type");
            String description = input.getAttribute("description");
            return new ExtensionBasedPatternAnnotationParameter(parameterName, type, description, multiple, mandatory, deprecated);
        }
    }
}

