/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.patternlanguage.validation;

import com.google.common.collect.ImmutableSet;
import com.google.inject.Inject;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.incquery.patternlanguage.annotations.IPatternAnnotationValidator;
import org.eclipse.incquery.patternlanguage.annotations.PatternAnnotationProvider;
import org.eclipse.incquery.patternlanguage.helper.CorePatternLanguageHelper;
import org.eclipse.incquery.patternlanguage.patternLanguage.AggregatedValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.Annotation;
import org.eclipse.incquery.patternlanguage.patternLanguage.AnnotationParameter;
import org.eclipse.incquery.patternlanguage.patternLanguage.BoolValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.CheckConstraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.CompareConstraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.CompareFeature;
import org.eclipse.incquery.patternlanguage.patternLanguage.Constraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.DoubleValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.FunctionEvaluationValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.IntValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.ListValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.ParameterRef;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternBody;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternCall;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternCompositionConstraint;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternLanguagePackage;
import org.eclipse.incquery.patternlanguage.patternLanguage.PatternModel;
import org.eclipse.incquery.patternlanguage.patternLanguage.StringValue;
import org.eclipse.incquery.patternlanguage.patternLanguage.ValueReference;
import org.eclipse.incquery.patternlanguage.patternLanguage.Variable;
import org.eclipse.incquery.patternlanguage.patternLanguage.VariableReference;
import org.eclipse.incquery.patternlanguage.patternLanguage.VariableValue;
import org.eclipse.incquery.patternlanguage.validation.AbstractPatternLanguageJavaValidator;
import org.eclipse.incquery.patternlanguage.validation.IIssueCallback;
import org.eclipse.incquery.patternlanguage.validation.UnionFindForVariables;
import org.eclipse.incquery.patternlanguage.validation.VariableReferenceCount;
import org.eclipse.incquery.patternlanguage.validation.whitelist.XBasePureCheckerUtil;
import org.eclipse.xtext.common.types.JvmIdentifiableElement;
import org.eclipse.xtext.common.types.JvmOperation;
import org.eclipse.xtext.common.types.JvmTypeReference;
import org.eclipse.xtext.common.types.util.Primitives;
import org.eclipse.xtext.common.types.util.TypeConformanceComputer;
import org.eclipse.xtext.util.Strings;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.CheckType;
import org.eclipse.xtext.xbase.XExpression;
import org.eclipse.xtext.xbase.XMemberFeatureCall;
import org.eclipse.xtext.xbase.jvmmodel.IJvmModelAssociations;
import org.eclipse.xtext.xbase.typing.ITypeProvider;

public class PatternLanguageJavaValidator
extends AbstractPatternLanguageJavaValidator
implements IIssueCallback {
    public static final String DUPLICATE_VARIABLE_MESSAGE = "Duplicate parameter ";
    public static final String DUPLICATE_PATTERN_DEFINITION_MESSAGE = "Duplicate pattern ";
    public static final String UNKNOWN_ANNOTATION_ATTRIBUTE = "Undefined annotation attribute ";
    public static final String MISSING_ANNOTATION_ATTRIBUTE = "Required attribute missing ";
    public static final String ANNOTATION_PARAMETER_TYPE_ERROR = "Invalid parameter type %s. Expected %s";
    public static final String TRANSITIVE_CLOSURE_ARITY_IN_PATTERNCALL = "The pattern %s is not of binary arity (it has %d parameters), therefore transitive closure is not supported.";
    public static final String TRANSITIVE_CLOSURE_ONLY_IN_POSITIVE_COMPOSITION = "Transitive closure of %s is currently only allowed in simple positive pattern calls (no negation or aggregation).";
    public static final String UNUSED_PRIVATE_PATTERN_MESSAGE = "The pattern '%s' is never used locally.";
    @Inject
    private PatternAnnotationProvider annotationProvider;
    @Inject
    private ITypeProvider provider;
    @Inject
    private TypeConformanceComputer typeConformance;
    @Inject
    private Primitives primitives;
    @Inject
    private IJvmModelAssociations associations;

    @Check
    public void checkPatternParameters(Pattern pattern) {
        if (pattern.getParameters().size() == 0) {
            this.warning("Parameterless patterns can only be used to check for existence of a condition.", (EStructuralFeature)PatternLanguagePackage.Literals.PATTERN__NAME, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.missing_pattern_parameters", new String[0]);
            return;
        }
        int i = 0;
        while (i < pattern.getParameters().size()) {
            String leftParameterName = ((Variable)pattern.getParameters().get(i)).getName();
            int j = i + 1;
            while (j < pattern.getParameters().size()) {
                if (Strings.equal((String)leftParameterName, (String)((Variable)pattern.getParameters().get(j)).getName())) {
                    this.error(DUPLICATE_VARIABLE_MESSAGE + leftParameterName, (EStructuralFeature)PatternLanguagePackage.Literals.PATTERN__PARAMETERS, i, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.duplicate_pattern_parameter_name", new String[0]);
                    this.error(DUPLICATE_VARIABLE_MESSAGE + leftParameterName, (EStructuralFeature)PatternLanguagePackage.Literals.PATTERN__PARAMETERS, j, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.duplicate_pattern_parameter_name", new String[0]);
                }
                ++j;
            }
            ++i;
        }
    }

    @Check
    public void checkPrivatePatternUsage(Pattern pattern) {
        if (CorePatternLanguageHelper.isPrivate(pattern) && !this.isLocallyUsed(pattern, pattern.eContainer())) {
            String message = String.format(UNUSED_PRIVATE_PATTERN_MESSAGE, pattern.getName());
            this.warning(message, (EStructuralFeature)PatternLanguagePackage.Literals.PATTERN__NAME, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.unused_private_pattern", new String[0]);
        }
    }

    @Check
    public void checkPatternCallParameters(PatternCall call) {
        int callParameterSize;
        int definitionParameterSize;
        if (call.getPatternRef() != null && call.getPatternRef().getName() != null && call.getParameters() != null && (definitionParameterSize = call.getPatternRef().getParameters().size()) != (callParameterSize = call.getParameters().size())) {
            this.error("The pattern " + this.getFormattedPattern(call.getPatternRef()) + " is not applicable for the arguments(" + this.getFormattedArgumentsList(call) + ")", (EStructuralFeature)PatternLanguagePackage.Literals.PATTERN_CALL__PATTERN_REF, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.wrong_number_pattern_parameter", new String[0]);
        }
    }

    @Check
    public void checkApplicabilityOfTransitiveClosureInPatternCall(PatternCall call) {
        Pattern patternRef = call.getPatternRef();
        EObject eContainer = call.eContainer();
        if (patternRef != null && call.isTransitive()) {
            if (patternRef.getParameters() != null) {
                int arity = patternRef.getParameters().size();
                if (2 != arity) {
                    this.error(String.format(TRANSITIVE_CLOSURE_ARITY_IN_PATTERNCALL, this.getFormattedPattern(patternRef), arity), (EStructuralFeature)PatternLanguagePackage.Literals.PATTERN_CALL__TRANSITIVE, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.transitive_patterncall_wrong_arity", new String[0]);
                } else {
                    JvmTypeReference type2;
                    JvmTypeReference type1 = this.provider.getTypeForIdentifiable((JvmIdentifiableElement)patternRef.getParameters().get(0));
                    if (!this.typeConformance.isConformant(type1, type2 = this.provider.getTypeForIdentifiable((JvmIdentifiableElement)patternRef.getParameters().get(1))) && !this.typeConformance.isConformant(type2, type1)) {
                        this.error(String.format("The parameter types %s and %s are not compatible, so no transitive references can exist in instance models.", type1.getSimpleName(), type2.getSimpleName()), (EStructuralFeature)PatternLanguagePackage.Literals.PATTERN_CALL__PARAMETERS, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.transitive_patterncall_incompatibletypes", new String[0]);
                    }
                }
            }
            if (eContainer != null && (!(eContainer instanceof PatternCompositionConstraint) || ((PatternCompositionConstraint)eContainer).isNegative())) {
                this.error(String.format(TRANSITIVE_CLOSURE_ONLY_IN_POSITIVE_COMPOSITION, this.getFormattedPattern(patternRef)), (EStructuralFeature)PatternLanguagePackage.Literals.PATTERN_CALL__TRANSITIVE, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.transitive_patterncall_not_applicable", new String[0]);
            }
        }
    }

    @Check
    public void checkPatterns(PatternModel model) {
        if (model.getPatterns() != null && !model.getPatterns().isEmpty()) {
            int i = 0;
            while (i < model.getPatterns().size()) {
                Pattern leftPattern = (Pattern)model.getPatterns().get(i);
                String leftPatternName = leftPattern.getName();
                int j = i + 1;
                while (j < model.getPatterns().size()) {
                    Pattern rightPattern = (Pattern)model.getPatterns().get(j);
                    String rightPatternName = rightPattern.getName();
                    if (leftPatternName.equalsIgnoreCase(rightPatternName)) {
                        this.error(DUPLICATE_PATTERN_DEFINITION_MESSAGE + leftPatternName, leftPattern, (EStructuralFeature)PatternLanguagePackage.Literals.PATTERN__NAME, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.duplicate_pattern_definition", new String[0]);
                        this.error(DUPLICATE_PATTERN_DEFINITION_MESSAGE + rightPatternName, rightPattern, (EStructuralFeature)PatternLanguagePackage.Literals.PATTERN__NAME, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.duplicate_pattern_definition", new String[0]);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    @Check
    public void checkPatternBody(PatternBody body) {
        if (body.getConstraints().isEmpty()) {
            String bodyName = this.getName(body);
            if (bodyName == null) {
                Pattern pattern = (Pattern)body.eContainer();
                String patternName = pattern.getName();
                this.error("A patternbody of " + patternName + " is empty", body, (EStructuralFeature)PatternLanguagePackage.Literals.PATTERN_BODY__CONSTRAINTS, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.patternbody_empty", new String[0]);
            } else {
                this.error("The patternbody " + bodyName + " cannot be empty", body, (EStructuralFeature)PatternLanguagePackage.Literals.PATTERN_BODY__NAME, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.patternbody_empty", new String[0]);
            }
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkAnnotation(Annotation annotation) {
        if (this.annotationProvider.hasValidator(annotation.getName())) {
            IPatternAnnotationValidator validator = this.annotationProvider.getValidator(annotation.getName());
            for (AnnotationParameter unknownParameter : validator.getUnknownAttributes(annotation)) {
                this.error(UNKNOWN_ANNOTATION_ATTRIBUTE + unknownParameter.getName(), unknownParameter, (EStructuralFeature)PatternLanguagePackage.Literals.ANNOTATION_PARAMETER__NAME, annotation.getParameters().indexOf((Object)unknownParameter), "org.eclipse.incquery.patternlanguage.validation.IssueCodes.unknown_annotation_attribute", new String[0]);
            }
            for (String missingAttribute : validator.getMissingMandatoryAttributes(annotation)) {
                this.error(MISSING_ANNOTATION_ATTRIBUTE + missingAttribute, annotation, (EStructuralFeature)PatternLanguagePackage.Literals.ANNOTATION__PARAMETERS, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.missing_annotation_parameter", new String[0]);
            }
            for (AnnotationParameter parameter : annotation.getParameters()) {
                VariableValue value;
                Class<? extends ValueReference> expectedParameterType = validator.getExpectedParameterType(parameter);
                if (expectedParameterType != null && parameter.getValue() != null && !expectedParameterType.isAssignableFrom(parameter.getValue().getClass())) {
                    this.error(String.format(ANNOTATION_PARAMETER_TYPE_ERROR, this.getTypeName(parameter.getValue().getClass()), this.getTypeName(expectedParameterType)), parameter, (EStructuralFeature)PatternLanguagePackage.Literals.ANNOTATION_PARAMETER__NAME, annotation.getParameters().indexOf((Object)parameter), "org.eclipse.incquery.patternlanguage.validation.IssueCodes.mistyped_annotation_parameter", new String[0]);
                    continue;
                }
                if (!(parameter.getValue() instanceof VariableValue) || (value = (VariableValue)parameter.getValue()).getValue().getVariable() != null) continue;
                this.error(String.format("Unknown variable %s", value.getValue().getVar()), parameter, (EStructuralFeature)PatternLanguagePackage.Literals.ANNOTATION_PARAMETER__VALUE, annotation.getParameters().indexOf((Object)parameter), "org.eclipse.incquery.patternlanguage.validation.IssueCodes.mistyped_annotation_parameter", new String[0]);
            }
            if (validator.getAdditionalValidator() != null) {
                validator.getAdditionalValidator().executeAdditionalValidation(annotation, this);
            }
        } else {
            this.warning("Unknown annotation " + annotation.getName(), (EStructuralFeature)PatternLanguagePackage.Literals.ANNOTATION__NAME, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.unknown_annotation", new String[0]);
        }
    }

    @Check
    public void checkCompareConstraints(CompareConstraint constraint) {
        ValueReference op1 = constraint.getLeftOperand();
        ValueReference op2 = constraint.getRightOperand();
        if (op1 == null || op2 == null) {
            return;
        }
        boolean op1Constant = PatternLanguagePackage.Literals.LITERAL_VALUE_REFERENCE.isSuperTypeOf(op1.eClass());
        boolean op2Constant = PatternLanguagePackage.Literals.LITERAL_VALUE_REFERENCE.isSuperTypeOf(op2.eClass());
        boolean op1Variable = PatternLanguagePackage.Literals.VARIABLE_VALUE.isSuperTypeOf(op1.eClass());
        boolean op2Variable = PatternLanguagePackage.Literals.VARIABLE_VALUE.isSuperTypeOf(op2.eClass());
        if (op1Constant && op2Constant) {
            this.warning("Both operands are constants - constraint is always true or always false.", (EStructuralFeature)PatternLanguagePackage.Literals.COMPARE_CONSTRAINT__LEFT_OPERAND, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.constant_compare_constraint", new String[0]);
            this.warning("Both operands are constants - constraint is always true or always false.", (EStructuralFeature)PatternLanguagePackage.Literals.COMPARE_CONSTRAINT__RIGHT_OPERAND, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.constant_compare_constraint", new String[0]);
        }
        if (op1Variable && op2Variable) {
            VariableValue op1v = (VariableValue)op1;
            VariableValue op2v = (VariableValue)op2;
            if (op1v.getValue().getVar().equals(op2v.getValue().getVar())) {
                this.warning("Comparing a variable with itself.", (EStructuralFeature)PatternLanguagePackage.Literals.COMPARE_CONSTRAINT__LEFT_OPERAND, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.self_compare_constraint", new String[0]);
                this.warning("Comparing a variable with itself.", (EStructuralFeature)PatternLanguagePackage.Literals.COMPARE_CONSTRAINT__RIGHT_OPERAND, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.self_compare_constraint", new String[0]);
            }
        }
    }

    private String getName(PatternBody body) {
        if (body.getName() != null && !body.getName().isEmpty()) {
            return "'" + body.getName() + "'";
        }
        return null;
    }

    private String getTypeName(Class<? extends ValueReference> typeClass) {
        if (IntValue.class.isAssignableFrom(typeClass)) {
            return "Integer";
        }
        if (DoubleValue.class.isAssignableFrom(typeClass)) {
            return "Double";
        }
        if (BoolValue.class.isAssignableFrom(typeClass)) {
            return "Boolean";
        }
        if (StringValue.class.isAssignableFrom(typeClass)) {
            return "String";
        }
        if (ListValue.class.isAssignableFrom(typeClass)) {
            return "List";
        }
        if (VariableValue.class.isAssignableFrom(typeClass)) {
            return "Variable";
        }
        return "UNDEFINED";
    }

    private String getConstantAsString(ValueReference ref) {
        if (ref instanceof IntValue) {
            return Integer.toString(((IntValue)ref).getValue());
        }
        if (ref instanceof DoubleValue) {
            return Double.toString(((DoubleValue)ref).getValue());
        }
        if (ref instanceof BoolValue) {
            return Boolean.toString(((BoolValue)ref).isValue());
        }
        if (ref instanceof StringValue) {
            return "\"" + ((StringValue)ref).getValue() + "\"";
        }
        if (ref instanceof ListValue) {
            StringBuilder sb = new StringBuilder();
            sb.append("{ ");
            Iterator iter = ((ListValue)ref).getValues().iterator();
            while (iter.hasNext()) {
                sb.append(this.getConstantAsString((ValueReference)iter.next()));
                if (!iter.hasNext()) continue;
                sb.append(", ");
            }
            sb.append("}");
            return sb.toString();
        }
        if (ref instanceof VariableValue) {
            return ((VariableValue)ref).getValue().getVar();
        }
        return "UNDEFINED";
    }

    private String getFormattedPattern(Pattern pattern) {
        StringBuilder builder = new StringBuilder();
        builder.append(pattern.getName());
        builder.append("(");
        Iterator iter = pattern.getParameters().iterator();
        while (iter.hasNext()) {
            builder.append(((Variable)iter.next()).getName());
            if (!iter.hasNext()) continue;
            builder.append(", ");
        }
        builder.append(")");
        return builder.toString();
    }

    protected String getFormattedArgumentsList(PatternCall call) {
        StringBuilder builder = new StringBuilder();
        Iterator iter = call.getParameters().iterator();
        while (iter.hasNext()) {
            ValueReference parameter = (ValueReference)iter.next();
            builder.append(this.getConstantAsString(parameter));
            if (!iter.hasNext()) continue;
            builder.append(", ");
        }
        return builder.toString();
    }

    @Check
    public void checkPackageDeclaration(PatternModel model) {
        String packageName = model.getPackageName();
        if (packageName == null || packageName.isEmpty()) {
            this.error("The package declaration must not be empty", (EStructuralFeature)PatternLanguagePackage.Literals.PATTERN_MODEL__PACKAGE_NAME, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.package_name_empty", new String[0]);
        }
        if (packageName != null && !packageName.equals(packageName.toLowerCase())) {
            this.error("Only lowercase package names supported", (EStructuralFeature)PatternLanguagePackage.Literals.PATTERN_MODEL__PACKAGE_NAME, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.package_name_mismatch", new String[0]);
        }
    }

    @Check
    public void checkReturnTypeOfCheckConstraints(CheckConstraint checkConstraint) {
        JvmTypeReference type;
        String simpleName;
        XExpression xExpression = checkConstraint.getExpression();
        if (xExpression != null && !(simpleName = this.primitives.asPrimitiveIfWrapperType(type = this.provider.getCommonReturnType(xExpression, true)).getSimpleName()).equals("boolean")) {
            this.error("Check expressions must return boolean instead of " + type.getSimpleName(), checkConstraint, (EStructuralFeature)PatternLanguagePackage.Literals.CHECK_CONSTRAINT__EXPRESSION, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.check_boolean", new String[0]);
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkVariableNames(PatternBody body) {
        for (Variable var1 : body.getVariables()) {
            Variable otherVar = null;
            for (Variable var2 : body.getVariables()) {
                if (!this.isNamedSingleUse(var1) || !var1.getSimpleName().substring(1).equals(var2.getName())) continue;
                otherVar = var2;
            }
            if (otherVar == null) continue;
            if (var1.eContainer() instanceof PatternBody && !var1.getReferences().isEmpty()) {
                this.warning(String.format("Dubius variable naming: Single use variable %s shares its name with the variable %s", var1.getSimpleName(), otherVar.getSimpleName()), (EObject)var1.getReferences().get(0), (EStructuralFeature)PatternLanguagePackage.Literals.VARIABLE_REFERENCE__VARIABLE, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.dubius_variable_name", new String[0]);
                continue;
            }
            this.warning(String.format("Dubius variable naming: Single use variable %s shares its name with the variable %s", var1.getSimpleName(), otherVar.getSimpleName()), (EObject)var1, (EStructuralFeature)PatternLanguagePackage.Literals.VARIABLE__NAME, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.dubius_variable_name", new String[0]);
        }
    }

    @Check(value=CheckType.NORMAL)
    public void checkVariableUsageCounters(PatternBody body) {
        Map<Variable, VariableReferenceCount> refCounters = this.calculateUsageCounts(body);
        UnionFindForVariables variableUnions = this.calculateEqualVariables(body);
        for (Variable var : body.getVariables()) {
            if (var instanceof ParameterRef) {
                this.checkParameterUsageCounter((ParameterRef)var, refCounters, variableUnions, body);
                continue;
            }
            this.checkLocalVariableUsageCounter(var, refCounters, variableUnions);
        }
    }

    private void checkParameterUsageCounter(ParameterRef var, Map<Variable, VariableReferenceCount> refCounters, UnionFindForVariables variableUnions, PatternBody body) {
        Variable parameter = var.getReferredParam();
        VariableReferenceCount counter = refCounters.get(var);
        if (counter.getReferenceCount() == 0) {
            this.error(String.format("Parameter '%s' is never referenced in body '%s'.", parameter.getName(), this.getPatternBodyName(body)), (EObject)parameter, (EStructuralFeature)PatternLanguagePackage.Literals.VARIABLE__NAME, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.symbolic_variable_never_referenced", new String[0]);
        } else if (counter.getReferenceCount(VariableReferenceCount.ReferenceType.POSITIVE) == 0 && this.getReferenceCount(var, VariableReferenceCount.ReferenceType.POSITIVE, refCounters, variableUnions) == 0) {
            this.error(String.format("Parameter '%s' has no positive reference in body '%s'.", var.getName(), this.getPatternBodyName(body)), (EObject)parameter, (EStructuralFeature)PatternLanguagePackage.Literals.VARIABLE__NAME, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.symbolic_variable_no_positive_reference", new String[0]);
        }
    }

    private void checkLocalVariableUsageCounter(Variable var, Map<Variable, VariableReferenceCount> refCounters, UnionFindForVariables variableUnions) {
        VariableReferenceCount counter = refCounters.get(var);
        if (counter.getReferenceCount(VariableReferenceCount.ReferenceType.POSITIVE) == 1 && counter.getReferenceCount() == 1 && !this.isNamedSingleUse(var) && !this.isUnnamedSingleUseVariable(var)) {
            this.warning(String.format("Local variable '%s' is referenced only once. Is it mistyped? Start its name with '_' if intentional.", var.getName()), (EObject)var.getReferences().get(0), (EStructuralFeature)PatternLanguagePackage.Literals.VARIABLE_REFERENCE__VAR, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.local_variable_referenced_once", new String[0]);
        } else if (counter.getReferenceCount() > 1 && this.isNamedSingleUse(var)) {
            for (VariableReference ref : var.getReferences()) {
                this.error(String.format("Named single-use variable %s used multiple times.", var.getName()), ref, (EStructuralFeature)PatternLanguagePackage.Literals.VARIABLE_REFERENCE__VAR, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.anonym_variable_multiple_reference", new String[0]);
            }
        } else if (counter.getReferenceCount(VariableReferenceCount.ReferenceType.POSITIVE) == 0) {
            if (counter.getReferenceCount(VariableReferenceCount.ReferenceType.NEGATIVE) == 0) {
                this.error(String.format("Local variable '%s' appears in read-only context(s) only, thus its value cannot be determined.", var.getName()), (EObject)var, (EStructuralFeature)PatternLanguagePackage.Literals.VARIABLE__NAME, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.local_variable_no_quantifying_reference", new String[0]);
            } else if (counter.getReferenceCount(VariableReferenceCount.ReferenceType.NEGATIVE) == 1 && counter.getReferenceCount() == 1 && !this.isNamedSingleUse(var) && !this.isUnnamedSingleUseVariable(var)) {
                this.warning(String.format("Local variable '%s' will be quantified because it is used only here. Acknowledge this by prefixing its name with '_'.", var.getName()), (EObject)var.getReferences().get(0), (EStructuralFeature)PatternLanguagePackage.Literals.VARIABLE_REFERENCE__VAR, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.local_variable_quantified_reference", new String[0]);
            } else if (counter.getReferenceCount() > 1) {
                this.error(String.format("Local variable '%s' has no positive reference, thus its value cannot be determined.", var.getName()), (EObject)var.getReferences().get(0), (EStructuralFeature)PatternLanguagePackage.Literals.VARIABLE_REFERENCE__VAR, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.local_variable_no_positive_reference", new String[0]);
            }
        }
    }

    private int getReferenceCount(Variable var, VariableReferenceCount.ReferenceType type, Map<Variable, VariableReferenceCount> refCounters, UnionFindForVariables variableUnions) {
        int sum = 0;
        for (Variable unionVar : variableUnions.getPartitionOfVariable(var)) {
            sum += refCounters.get(unionVar).getReferenceCount(type);
        }
        return sum;
    }

    private Map<Variable, VariableReferenceCount> calculateUsageCounts(PatternBody body) {
        Hashtable<Variable, VariableReferenceCount> refCounters = new Hashtable<Variable, VariableReferenceCount>();
        EList<Variable> variables = body.getVariables();
        for (Variable var : variables) {
            boolean isParameter = var instanceof ParameterRef;
            refCounters.put(var, new VariableReferenceCount(var, isParameter));
        }
        TreeIterator it = body.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (obj instanceof XExpression) {
                XExpression expression = (XExpression)obj;
                for (Variable var : CorePatternLanguageHelper.getReferencedPatternVariablesOfXExpression(expression, this.associations)) {
                    ((VariableReferenceCount)refCounters.get(var)).incrementCounter(VariableReferenceCount.ReferenceType.READ_ONLY);
                }
                it.prune();
            }
            if (!(obj instanceof VariableReference)) continue;
            ((VariableReferenceCount)refCounters.get(((VariableReference)obj).getVariable())).incrementCounter(this.classifyReference((VariableReference)obj));
        }
        return refCounters;
    }

    private UnionFindForVariables calculateEqualVariables(PatternBody body) {
        UnionFindForVariables unions = new UnionFindForVariables((List<Variable>)body.getVariables());
        TreeIterator it = body.eAllContents();
        while (it.hasNext()) {
            EObject obj = (EObject)it.next();
            if (obj instanceof CompareConstraint) {
                CompareConstraint constraint = (CompareConstraint)obj;
                if (constraint.getFeature() == CompareFeature.EQUALITY) {
                    ValueReference left = constraint.getLeftOperand();
                    ValueReference right = constraint.getRightOperand();
                    if (left instanceof VariableValue && right instanceof VariableValue) {
                        unions.unite((Set<Variable>)ImmutableSet.of((Object)((VariableValue)left).getValue().getVariable(), (Object)((VariableValue)right).getValue().getVariable()));
                    }
                }
                it.prune();
                continue;
            }
            if (!(obj instanceof Constraint)) continue;
            it.prune();
        }
        return unions;
    }

    private String getPatternBodyName(PatternBody patternBody) {
        return patternBody.getName() != null ? patternBody.getName() : String.format("#%d", ((Pattern)patternBody.eContainer()).getBodies().indexOf((Object)patternBody) + 1);
    }

    private VariableReferenceCount.ReferenceType classifyReference(VariableReference ref) {
        VariableReference parent = ref;
        while (parent != null && !(parent instanceof Constraint) && !(parent instanceof AggregatedValue)) {
            parent = parent.eContainer();
        }
        if (parent instanceof CheckConstraint) {
            return VariableReferenceCount.ReferenceType.READ_ONLY;
        }
        if (parent instanceof FunctionEvaluationValue) {
            return VariableReferenceCount.ReferenceType.READ_ONLY;
        }
        if (parent instanceof CompareConstraint) {
            CompareConstraint constraint = (CompareConstraint)((Object)parent);
            if (constraint.getFeature() == CompareFeature.EQUALITY) {
                if (constraint.getLeftOperand() instanceof VariableValue && !(constraint.getRightOperand() instanceof VariableValue) && ref.equals(((VariableValue)constraint.getLeftOperand()).getValue())) {
                    return VariableReferenceCount.ReferenceType.POSITIVE;
                }
                if (constraint.getRightOperand() instanceof VariableValue && !(constraint.getLeftOperand() instanceof VariableValue) && ref.equals(((VariableValue)constraint.getRightOperand()).getValue())) {
                    return VariableReferenceCount.ReferenceType.POSITIVE;
                }
            }
            return VariableReferenceCount.ReferenceType.READ_ONLY;
        }
        if (parent instanceof PatternCompositionConstraint && ((PatternCompositionConstraint)((Object)parent)).isNegative()) {
            return VariableReferenceCount.ReferenceType.NEGATIVE;
        }
        if (parent instanceof AggregatedValue) {
            return VariableReferenceCount.ReferenceType.NEGATIVE;
        }
        return VariableReferenceCount.ReferenceType.POSITIVE;
    }

    public boolean isNamedSingleUse(Variable variable) {
        String name = variable.getName();
        return name != null && name.startsWith("_") && !name.contains("<");
    }

    public boolean isUnnamedSingleUseVariable(Variable variable) {
        String name = variable.getName();
        return name != null && name.startsWith("_") && name.contains("<");
    }

    @Check(value=CheckType.NORMAL)
    public void checkForImpureJavaCallsInCheckConstraints(CheckConstraint checkConstraint) {
        this.checkForImpureJavaCallsInternal(checkConstraint.getExpression(), (EStructuralFeature)PatternLanguagePackage.Literals.CHECK_CONSTRAINT__EXPRESSION);
    }

    @Check(value=CheckType.NORMAL)
    public void checkForImpureJavaCallsInEvalExpressions(FunctionEvaluationValue eval) {
        this.checkForImpureJavaCallsInternal(eval.getExpression(), (EStructuralFeature)PatternLanguagePackage.Literals.FUNCTION_EVALUATION_VALUE__EXPRESSION);
    }

    private void checkForImpureJavaCallsInternal(XExpression xExpression, EStructuralFeature feature) {
        HashSet<String> elementsWithWarnings = new HashSet<String>();
        if (xExpression != null) {
            TreeIterator eAllContents = xExpression.eAllContents();
            while (eAllContents.hasNext()) {
                JvmOperation jvmOperation;
                XMemberFeatureCall xFeatureCall;
                JvmIdentifiableElement jvmIdentifiableElement;
                EObject nextEObject = (EObject)eAllContents.next();
                if (!(nextEObject instanceof XMemberFeatureCall) || !((jvmIdentifiableElement = (xFeatureCall = (XMemberFeatureCall)nextEObject).getFeature()) instanceof JvmOperation) || !XBasePureCheckerUtil.isImpureElement(jvmOperation = (JvmOperation)jvmIdentifiableElement)) continue;
                elementsWithWarnings.add(jvmOperation.getQualifiedName());
            }
        }
        if (!elementsWithWarnings.isEmpty()) {
            if (elementsWithWarnings.size() > 1) {
                this.warning("There are potentially problematic java calls in the check()/eval() expression. Custom java calls without @Pure annotations considered unsafe in IncQuery. The possible erroneous calls are the following: " + elementsWithWarnings + ".", xExpression.eContainer(), feature, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.check_with_impure_java_calls", new String[0]);
            } else {
                this.warning("There is a potentially problematic java call in the check()/eval() expression. Custom java calls without @Pure annotations considered unsafe in IncQuery. The possible erroneous call is the following: " + elementsWithWarnings + ".", xExpression.eContainer(), feature, "org.eclipse.incquery.patternlanguage.validation.IssueCodes.check_with_impure_java_calls", new String[0]);
            }
        }
    }

    @Override
    public void warning(String message, EObject source, EStructuralFeature feature, String code, String ... issueData) {
        super.warning(message, source, feature, code, issueData);
    }

    @Override
    public void error(String message, EObject source, EStructuralFeature feature, String code, String ... issueData) {
        super.error(message, source, feature, code, issueData);
    }
}

