/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.testing.core;

import com.google.common.base.Objects;
import java.util.Iterator;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.incquery.patternlanguage.emf.eMFPatternLanguage.PatternModel;
import org.eclipse.incquery.patternlanguage.patternLanguage.Pattern;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.extensibility.QuerySpecificationRegistry;
import org.eclipse.incquery.runtime.util.XmiModelUtil;
import org.eclipse.incquery.runtime.util.XmiModelUtilRunningOptionEnum;
import org.eclipse.incquery.snapshot.EIQSnapshot.IncQuerySnapshot;
import org.eclipse.incquery.snapshot.EIQSnapshot.MatchSetRecord;
import org.eclipse.xtext.xbase.lib.Exceptions;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;

public class ModelLoadHelper {
    public Resource loadModelFromFile(IFile file) {
        IPath _fullPath = file.getFullPath();
        String _string = _fullPath.toString();
        Resource _loadModelFromUri = this.loadModelFromUri(_string);
        return _loadModelFromUri;
    }

    public Resource loadModelFromUri(String platformUri) {
        Resource _loadAdditionalResourceFromUri;
        ResourceSetImpl _resourceSetImpl;
        Resource _xblockexpression = null;
        ResourceSetImpl resourceSet = _resourceSetImpl = new ResourceSetImpl();
        _xblockexpression = _loadAdditionalResourceFromUri = this.loadAdditionalResourceFromUri((ResourceSet)resourceSet, platformUri);
        return _xblockexpression;
    }

    public Resource loadAdditionalResourceFromFile(ResourceSet resourceSet, IFile file) {
        IPath _fullPath = file.getFullPath();
        String _string = _fullPath.toString();
        Resource _loadAdditionalResourceFromUri = this.loadAdditionalResourceFromUri(resourceSet, _string);
        return _loadAdditionalResourceFromUri;
    }

    public Resource loadAdditionalResourceFromUri(ResourceSet resourceSet, String platformUri) {
        boolean _notEquals;
        Resource _xblockexpression = null;
        URI modelURI = XmiModelUtil.resolvePlatformURI((XmiModelUtilRunningOptionEnum)XmiModelUtilRunningOptionEnum.BOTH, (String)platformUri);
        Resource _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)modelURI, null);
        if (_notEquals) {
            Resource _resource;
            _xifexpression = _resource = resourceSet.getResource(modelURI, true);
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public PatternModel loadPatternModelFromFile(IFile file) {
        IPath _fullPath = file.getFullPath();
        String _string = _fullPath.toString();
        PatternModel _loadPatternModelFromUri = this.loadPatternModelFromUri(_string);
        return _loadPatternModelFromUri;
    }

    public PatternModel loadPatternModelFromUri(String platformUri) {
        boolean _greaterThan;
        PatternModel _xblockexpression = null;
        ResourceSet _prepareXtextResource = XmiModelUtil.prepareXtextResource();
        Resource resource = this.loadAdditionalResourceFromUri(_prepareXtextResource, platformUri);
        PatternModel _xifexpression = null;
        EList _contents = resource.getContents();
        int _size = _contents.size();
        boolean bl = _greaterThan = _size > 0;
        if (_greaterThan) {
            PatternModel _xifexpression_1 = null;
            EList _contents_1 = resource.getContents();
            EObject _get = (EObject)_contents_1.get(0);
            if (_get instanceof PatternModel) {
                EList _contents_2 = resource.getContents();
                EObject _get_1 = (EObject)_contents_2.get(0);
                _xifexpression_1 = (PatternModel)_get_1;
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public IncQueryMatcher<? extends IPatternMatch> initializeMatcherFromModel(final PatternModel model, IncQueryEngine engine, final String patternName) {
        try {
            boolean _equals;
            IncQueryMatcher _xblockexpression = null;
            EList _patterns = model.getPatterns();
            Functions.Function1<Pattern, Boolean> _function = new Functions.Function1<Pattern, Boolean>(){

                public Boolean apply(Pattern it) {
                    boolean _xifexpression = false;
                    String _packageName = model.getPackageName();
                    boolean _equals = Objects.equal((Object)_packageName, null);
                    if (_equals) {
                        boolean _equals_1;
                        String _name = it.getName();
                        _xifexpression = _equals_1 = _name.equals(patternName);
                    } else {
                        boolean _equals_2;
                        String _packageName_1 = model.getPackageName();
                        String _plus = String.valueOf(_packageName_1) + ".";
                        String _name_1 = it.getName();
                        String _plus_1 = String.valueOf(_plus) + _name_1;
                        _xifexpression = _equals_2 = _plus_1.equals(patternName);
                    }
                    return _xifexpression;
                }
            };
            Iterable patterns = IterableExtensions.filter((Iterable)_patterns, (Functions.Function1)_function);
            IncQueryMatcher _xifexpression = null;
            int _size = IterableExtensions.size((Iterable)patterns);
            boolean bl = _equals = _size == 1;
            if (_equals) {
                IncQueryMatcher _matcher;
                Iterator _iterator = patterns.iterator();
                Pattern _next = (Pattern)_iterator.next();
                _xifexpression = _matcher = engine.getMatcher(_next);
            }
            _xblockexpression = _xifexpression;
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public IncQueryMatcher<? extends IPatternMatch> initializeMatcherFromModel(PatternModel model, Notifier emfRoot, String patternName) {
        try {
            IncQueryMatcher<? extends IPatternMatch> _initializeMatcherFromModel;
            IncQueryMatcher<? extends IPatternMatch> _xblockexpression = null;
            IncQueryEngine engine = IncQueryEngine.on((Notifier)emfRoot);
            _xblockexpression = _initializeMatcherFromModel = this.initializeMatcherFromModel(model, engine, patternName);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public IncQueryMatcher<? extends IPatternMatch> initializeMatcherFromRegistry(Notifier emfRoot, String patternFQN) {
        try {
            IncQueryMatcher _matcher;
            IncQueryMatcher _xblockexpression = null;
            IQuerySpecification querySpecification = QuerySpecificationRegistry.getQuerySpecification((String)patternFQN);
            IncQueryEngine _on = IncQueryEngine.on((Notifier)emfRoot);
            _xblockexpression = _matcher = querySpecification.getMatcher(_on);
            return _xblockexpression;
        }
        catch (Throwable _e) {
            throw Exceptions.sneakyThrow((Throwable)_e);
        }
    }

    public IncQuerySnapshot loadExpectedResultsFromFile(ResourceSet resourceSet, IFile file) {
        IPath _fullPath = file.getFullPath();
        String _string = _fullPath.toString();
        IncQuerySnapshot _loadExpectedResultsFromUri = this.loadExpectedResultsFromUri(resourceSet, _string);
        return _loadExpectedResultsFromUri;
    }

    public IncQuerySnapshot loadExpectedResultsFromUri(ResourceSet resourceSet, String platformUri) {
        boolean _notEquals;
        IncQuerySnapshot _xblockexpression = null;
        Resource resource = this.loadAdditionalResourceFromUri(resourceSet, platformUri);
        IncQuerySnapshot _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)resource, null);
        if (_notEquals) {
            boolean _greaterThan;
            IncQuerySnapshot _xifexpression_1 = null;
            EList _contents = resource.getContents();
            int _size = _contents.size();
            boolean bl2 = _greaterThan = _size > 0;
            if (_greaterThan) {
                IncQuerySnapshot _xifexpression_2 = null;
                EList _contents_1 = resource.getContents();
                EObject _get = (EObject)_contents_1.get(0);
                if (_get instanceof IncQuerySnapshot) {
                    EList _contents_2 = resource.getContents();
                    EObject _get_1 = (EObject)_contents_2.get(0);
                    _xifexpression_2 = (IncQuerySnapshot)_get_1;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public IncQuerySnapshot loadExpectedResultsFromFile(IFile file) {
        IPath _fullPath = file.getFullPath();
        String _string = _fullPath.toString();
        IncQuerySnapshot _loadExpectedResultsFromUri = this.loadExpectedResultsFromUri(_string);
        return _loadExpectedResultsFromUri;
    }

    public IncQuerySnapshot loadExpectedResultsFromUri(String platformUri) {
        boolean _notEquals;
        IncQuerySnapshot _xblockexpression = null;
        Resource resource = this.loadModelFromUri(platformUri);
        IncQuerySnapshot _xifexpression = null;
        boolean bl = _notEquals = !Objects.equal((Object)resource, null);
        if (_notEquals) {
            boolean _greaterThan;
            IncQuerySnapshot _xifexpression_1 = null;
            EList _contents = resource.getContents();
            int _size = _contents.size();
            boolean bl2 = _greaterThan = _size > 0;
            if (_greaterThan) {
                IncQuerySnapshot _xifexpression_2 = null;
                EList _contents_1 = resource.getContents();
                EObject _get = (EObject)_contents_1.get(0);
                if (_get instanceof IncQuerySnapshot) {
                    EList _contents_2 = resource.getContents();
                    EObject _get_1 = (EObject)_contents_2.get(0);
                    _xifexpression_2 = (IncQuerySnapshot)_get_1;
                }
                _xifexpression_1 = _xifexpression_2;
            }
            _xifexpression = _xifexpression_1;
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }

    public MatchSetRecord loadExpectedResultsForPatternFromFile(ResourceSet resourceSet, IFile file, String patternFQN) {
        IPath _fullPath = file.getFullPath();
        String _string = _fullPath.toString();
        MatchSetRecord _loadExpectedResultsForPatternFromUri = this.loadExpectedResultsForPatternFromUri(resourceSet, _string, patternFQN);
        return _loadExpectedResultsForPatternFromUri;
    }

    public MatchSetRecord loadExpectedResultsForPatternFromUri(ResourceSet resourceSet, String platformUri, final String patternFQN) {
        boolean _equals;
        MatchSetRecord _xblockexpression = null;
        Resource _loadAdditionalResourceFromUri = this.loadAdditionalResourceFromUri(resourceSet, platformUri);
        IncQuerySnapshot snapshot = (IncQuerySnapshot)_loadAdditionalResourceFromUri;
        EList _matchSetRecords = snapshot.getMatchSetRecords();
        Functions.Function1<MatchSetRecord, Boolean> _function = new Functions.Function1<MatchSetRecord, Boolean>(){

            public Boolean apply(MatchSetRecord it) {
                String _patternQualifiedName = it.getPatternQualifiedName();
                boolean _equals = _patternQualifiedName.equals(patternFQN);
                return _equals;
            }
        };
        Iterable matchsetrecord = IterableExtensions.filter((Iterable)_matchSetRecords, (Functions.Function1)_function);
        MatchSetRecord _xifexpression = null;
        int _size = IterableExtensions.size((Iterable)matchsetrecord);
        boolean bl = _equals = _size == 1;
        if (_equals) {
            Iterator _iterator = matchsetrecord.iterator();
            return (MatchSetRecord)_iterator.next();
        }
        _xblockexpression = _xifexpression;
        return _xblockexpression;
    }
}

