/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.testing.core;

import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Appender;
import org.apache.log4j.AppenderSkeleton;
import org.apache.log4j.Level;
import org.apache.log4j.PatternLayout;
import org.apache.log4j.spi.Filter;
import org.apache.log4j.spi.LoggingEvent;
import org.apache.log4j.spi.ThrowableInformation;
import org.apache.log4j.varia.LevelRangeFilter;

public class TestingLogAppender
extends AppenderSkeleton
implements Appender {
    private static final String FORMAT_LAYOUT = "%m%n";
    private static final Level LEVEL_MIN = Level.WARN;
    private final Map<String, StringBuilder> messages = new HashMap<String, StringBuilder>();
    private final StringBuilder output = new StringBuilder();

    public TestingLogAppender() {
        this.layout = new PatternLayout(FORMAT_LAYOUT);
        LevelRangeFilter newFilter = new LevelRangeFilter();
        newFilter.setAcceptOnMatch(true);
        newFilter.setLevelMin(LEVEL_MIN);
        this.addFilter((Filter)newFilter);
    }

    public Map<String, StringBuilder> getMessages() {
        return this.messages;
    }

    public StringBuilder getOutput() {
        return this.output;
    }

    public void close() {
    }

    public boolean requiresLayout() {
        return true;
    }

    protected void append(LoggingEvent event) {
        String formatted = this.layout.format(event);
        String levelName = event.getLevel().toString();
        StringBuilder sb = this.messages.get(levelName);
        if (sb == null) {
            sb = new StringBuilder();
            this.messages.put(levelName, sb);
        }
        sb.append(formatted);
        this.output.append(formatted);
        ThrowableInformation throwInfo = event.getThrowableInformation();
        if (throwInfo != null) {
            String[] lines;
            String[] stringArray = lines = throwInfo.getThrowableStrRep();
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                this.output.append(line).append("%n");
                ++n2;
            }
        }
    }
}

