/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.incquery.databinding.runtime.collection;

import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.databinding.observable.Diffs;
import org.eclipse.core.databinding.observable.IObservable;
import org.eclipse.core.databinding.observable.ObservableTracker;
import org.eclipse.core.databinding.observable.Realm;
import org.eclipse.core.databinding.observable.list.AbstractObservableList;
import org.eclipse.core.databinding.observable.list.ListDiff;
import org.eclipse.core.databinding.observable.list.ListDiffEntry;
import org.eclipse.core.runtime.Assert;
import org.eclipse.incquery.databinding.runtime.collection.IObservablePatternMatchCollectionUpdate;
import org.eclipse.incquery.databinding.runtime.collection.ObservableCollectionHelper;
import org.eclipse.incquery.databinding.runtime.collection.ObservablePatternMatchCollection;
import org.eclipse.incquery.runtime.api.IPatternMatch;
import org.eclipse.incquery.runtime.api.IQuerySpecification;
import org.eclipse.incquery.runtime.api.IncQueryEngine;
import org.eclipse.incquery.runtime.api.IncQueryMatcher;
import org.eclipse.incquery.runtime.evm.api.RuleEngine;
import org.eclipse.incquery.runtime.evm.api.RuleSpecification;
import org.eclipse.incquery.runtime.evm.api.event.EventFilter;
import org.eclipse.incquery.runtime.evm.specific.Rules;

public class ObservablePatternMatchList<Match extends IPatternMatch>
extends AbstractObservableList {
    private final List<Match> cache = Collections.synchronizedList(new LinkedList());
    private ListCollectionUpdate updater;
    private RuleSpecification<Match> specification;
    private EventFilter<Match> matchFilter;
    private RuleEngine ruleEngine;
    private ObservablePatternMatchCollection<Match> internalCollection = new ObservablePatternMatchCollection<Match>(){

        @Override
        public void createUpdater(Function<Match, ?> converter, Comparator<Match> comparator) {
            ObservablePatternMatchList.this.updater = new ListCollectionUpdate(converter, comparator);
        }

        @Override
        public void createRuleSpecification(IQuerySpecification<? extends IncQueryMatcher<Match>> querySpecification) {
            ObservablePatternMatchList.this.specification = ObservableCollectionHelper.createRuleSpecification(ObservablePatternMatchList.this.updater, querySpecification);
        }

        @Override
        public void createRuleSpecification(IncQueryMatcher<Match> matcher) {
            ObservablePatternMatchList.this.specification = ObservableCollectionHelper.createRuleSpecification(ObservablePatternMatchList.this.updater, matcher);
        }

        @Override
        public void setFilter(EventFilter<Match> filter) {
            if (filter == null) {
                ObservablePatternMatchList.this.matchFilter = ObservablePatternMatchList.this.specification.createEmptyFilter();
            } else {
                ObservablePatternMatchList.this.matchFilter = filter;
            }
        }

        @Override
        public void initialize(IncQueryEngine engine) {
            ObservablePatternMatchList.this.ruleEngine = ObservableCollectionHelper.prepareRuleEngine(engine, ObservablePatternMatchList.this.specification, ObservablePatternMatchList.this.matchFilter);
        }

        @Override
        public void initialize(RuleEngine engine) {
            ObservablePatternMatchList.this.ruleEngine = engine;
            engine.addRule(ObservablePatternMatchList.this.specification, ObservablePatternMatchList.this.matchFilter);
            ObservableCollectionHelper.fireActivations(engine, ObservablePatternMatchList.this.specification, ObservablePatternMatchList.this.matchFilter);
        }
    };

    protected ObservablePatternMatchList() {
    }

    protected ObservablePatternMatchCollection<Match> getInternalCollection() {
        return this.internalCollection;
    }

    public void clear() {
        this.cache.clear();
        this.updater.clear();
    }

    public synchronized void dispose() {
        this.ruleEngine.removeRule(this.specification, this.matchFilter);
        this.clear();
        super.dispose();
    }

    public Object getElementType() {
        if (this.updater.converter != null) {
            return Object.class;
        }
        return IPatternMatch.class;
    }

    protected int doGetSize() {
        return this.cache.size();
    }

    public Object get(int index) {
        if (this.updater.converter != null) {
            return this.updater.matchToItem.get(this.cache.get(index));
        }
        return this.cache.get(index);
    }

    private void getterCalled() {
        ObservableTracker.getterCalled((IObservable)this);
    }

    public Iterator iterator() {
        this.getterCalled();
        if (this.updater.converter != null) {
            final Iterator<Match> iterator = this.cache.iterator();
            return new Iterator<Object>(){

                @Override
                public boolean hasNext() {
                    return iterator.hasNext();
                }

                @Override
                public Object next() {
                    IPatternMatch next = (IPatternMatch)iterator.next();
                    return ((ObservablePatternMatchList)ObservablePatternMatchList.this).updater.matchToItem.get(next);
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("This iterator does not support element removal!");
                }
            };
        }
        return this.cache.iterator();
    }

    public RuleSpecification<Match> getSpecification() {
        return this.specification;
    }

    public void setFilter(Match filter) {
        EventFilter<Match> oldFilter = this.matchFilter;
        this.matchFilter = Rules.newSingleMatchFilter(filter);
        if (Objects.equal(this.matchFilter, oldFilter)) {
            return;
        }
        if (oldFilter == null) {
            this.ruleEngine.removeRule(this.specification);
        } else {
            this.ruleEngine.removeRule(this.specification, oldFilter);
        }
        List oldCache = this.updater.pauseUpdates();
        this.updater.removed.addAll(oldCache);
        if (filter == null) {
            this.ruleEngine.addRule(this.specification);
        } else {
            this.ruleEngine.addRule(this.specification, this.matchFilter);
        }
        ObservableCollectionHelper.fireActivations(this.ruleEngine, this.specification, this.matchFilter);
        this.updater.resumeUpdates();
    }

    public class ListCollectionUpdate
    implements IObservablePatternMatchCollectionUpdate<Match> {
        protected static final String DATA_BINDING_REALM_MUST_NOT_BE_NULL = "Data binding Realm must not be null";
        protected final Function<Match, ?> converter;
        protected final Comparator<Match> comparator;
        protected final Map<Match, Object> matchToItem = new HashMap();
        protected ListDiff nextDiff = null;
        private List<Match> oldCache = null;
        private Set<Match> removed;

        public ListCollectionUpdate(Function<Match, ?> converter, Comparator<Match> comparator) {
            this.converter = converter != null ? converter : null;
            this.comparator = comparator;
        }

        private int placeOf(Match match) {
            if (ObservablePatternMatchList.this.cache.size() == 0) {
                return 0;
            }
            int left = 0;
            int right = ObservablePatternMatchList.this.cache.size() - 1;
            while (left <= right) {
                int mid = left + right >> 1;
                int cv = this.comparator.compare(match, (IPatternMatch)ObservablePatternMatchList.this.cache.get(mid));
                if (cv == 0) {
                    return mid;
                }
                if (cv < 0) {
                    right = mid - 1;
                    continue;
                }
                left = mid + 1;
            }
            return left;
        }

        @Override
        public void addMatch(Match match) {
            ListDiffEntry diffentry = this.addItem(match);
            this.sendListUpdates(diffentry);
        }

        @Override
        public void removeMatch(Match match) {
            ListDiffEntry diffentry = this.removeItem(match);
            this.sendListUpdates(diffentry);
        }

        private void sendListUpdates(ListDiffEntry diffentry) {
            if (this.nextDiff == null) {
                ListDiff diff = Diffs.createListDiff((ListDiffEntry)diffentry);
                this.sendListUpdate(diff);
            }
        }

        private void sendListUpdate(final ListDiff diff) {
            Realm realm = ObservablePatternMatchList.this.getRealm();
            Assert.isNotNull((Object)realm, (String)DATA_BINDING_REALM_MUST_NOT_BE_NULL);
            realm.exec(new Runnable(){

                @Override
                public void run() {
                    if (!ObservablePatternMatchList.this.isDisposed()) {
                        ObservablePatternMatchList.this.fireListChange(diff);
                    }
                }
            });
        }

        private ListDiffEntry addItem(Match match) {
            if (this.removed != null && this.removed.remove(match)) {
                return null;
            }
            Object item = match;
            if (this.converter != null) {
                item = this.converter.apply(match);
                this.matchToItem.put(match, item);
            }
            int index = this.comparator == null ? ObservablePatternMatchList.this.cache.size() : this.placeOf(match);
            ListDiffEntry diffentry = Diffs.createListDiffEntry((int)index, (boolean)true, item);
            ObservablePatternMatchList.this.cache.add(index, match);
            return diffentry;
        }

        private ListDiffEntry removeItem(Match match) {
            Object item = match;
            if (this.converter != null) {
                item = this.matchToItem.remove(match);
            }
            int index = ObservablePatternMatchList.this.cache.indexOf(match);
            ListDiffEntry diffentry = Diffs.createListDiffEntry((int)index, (boolean)false, item);
            ObservablePatternMatchList.this.cache.remove(match);
            return diffentry;
        }

        private List<Match> pauseUpdates() {
            if (this.nextDiff == null) {
                this.oldCache = Lists.newArrayList((Iterable)ObservablePatternMatchList.this.cache);
                this.nextDiff = Diffs.computeLazyListDiff(this.oldCache, (List)ObservablePatternMatchList.this.cache);
                this.removed = Sets.newHashSet();
                return this.oldCache;
            }
            return Collections.emptyList();
        }

        private void resumeUpdates() {
            if (this.nextDiff != null) {
                ArrayList entries = Lists.newArrayListWithCapacity((int)this.removed.size());
                for (IPatternMatch match : this.removed) {
                    ListDiffEntry diffEntry = this.removeItem(match);
                    entries.add(diffEntry);
                }
                this.nextDiff = Diffs.createListDiff((ListDiffEntry[])this.nextDiff.getDifferences());
                if (!this.nextDiff.isEmpty()) {
                    ListDiffEntry[] listDiffEntryArray = this.nextDiff.getDifferences();
                    int n = listDiffEntryArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        ListDiffEntry entry = listDiffEntryArray[n2];
                        if (entry.isAddition()) {
                            int index = entry.getPosition();
                            Object item = ObservablePatternMatchList.this.get(index);
                            ListDiffEntry diffentry = Diffs.createListDiffEntry((int)index, (boolean)true, (Object)item);
                            entries.add(diffentry);
                        }
                        ++n2;
                    }
                    ListDiff diff = Diffs.createListDiff((ListDiffEntry[])entries.toArray(new ListDiffEntry[entries.size()]));
                    this.sendListUpdate(diff);
                }
            }
            this.nextDiff = null;
            this.oldCache = null;
            this.removed = null;
        }

        @Override
        public void clear() {
            this.matchToItem.clear();
        }
    }
}

